/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.SWRLRule;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public class SWRLRuleTranslator
extends AxiomTranslator<SWRLRule> {
    @Override
    public void write(SWRLRule axiom, OntGraphModel model) {
        Stream<OntSWRL.Atom> head = axiom.head().map(atom -> WriteHelper.addSWRLAtom(model, atom));
        Stream<OntSWRL.Atom> body = axiom.body().map(atom -> WriteHelper.addSWRLAtom(model, atom));
        WriteHelper.addAnnotations(model.createSWRLImp(head.collect(Collectors.toList()), body.collect(Collectors.toList())), (Stream<OWLAnnotation>)axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listOntObjects(model, OntSWRL.Imp.class).mapWith(OntObject::getRoot);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(OntSWRL.Imp.class);
    }

    @Override
    public ONTObject<SWRLRule> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        OntSWRL.Imp imp = statement.getSubject(OntSWRL.Imp.class);
        Collection head = imp.head().map(reader::get).collect(Collectors.toList());
        Collection body = imp.body().map(reader::get).collect(Collectors.toList());
        Collection annotations = reader.get(statement, config);
        SWRLRule res = reader.getOWLDataFactory().getSWRLRule(body.stream().map(ONTObject::getObject).collect(Collectors.toList()), head.stream().map(ONTObject::getObject).collect(Collectors.toList()), ONTObject.extract(annotations));
        return ONTObject.create(res, imp).append(annotations).appendWildcards(body).appendWildcards(head);
    }
}

