/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import ru.avicomp.ontapi.internal.AbstractSubPropertyTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.ReadHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntStatement;

public class SubAnnotationPropertyOfTranslator
extends AbstractSubPropertyTranslator<OWLSubAnnotationPropertyOfAxiom, OntNAP> {
    @Override
    OWLPropertyExpression getSubProperty(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom.getSubProperty();
    }

    @Override
    OWLPropertyExpression getSuperProperty(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom.getSuperProperty();
    }

    @Override
    Class<OntNAP> getView() {
        return OntNAP.class;
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        return super.listStatements(model, config);
    }

    @Override
    protected boolean filter(OntStatement statement, InternalConfig config) {
        return super.filter(statement, config) && ReadHelper.testAnnotationAxiomOverlaps(statement, config, (AxiomType<? extends OWLObjectPropertyAxiom>)AxiomType.SUB_OBJECT_PROPERTY, (AxiomType<? extends OWLDataPropertyAxiom>)AxiomType.SUB_DATA_PROPERTY);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return config.isLoadAnnotationAxioms() && super.testStatement(statement, config);
    }

    @Override
    public ONTObject<OWLSubAnnotationPropertyOfAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<OWLAnnotationProperty> sub = reader.get(statement.getSubject(OntNAP.class));
        ONTObject<OWLAnnotationProperty> sup = reader.get((OntNAP)statement.getObject().as(OntNAP.class));
        Collection annotations = reader.get(statement, config);
        OWLSubAnnotationPropertyOfAxiom res = reader.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(sub.getObject(), sup.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(sub).append(sup);
    }
}

