/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

public class UnionGraph
extends Union {
    public UnionGraph(Graph base) {
        this(base, new OntEventManager());
    }

    public UnionGraph(Graph base, OntEventManager gem) {
        this(base, new OntMultiUnion(), gem);
    }

    public UnionGraph(Graph base, OntMultiUnion sub, OntEventManager gem) {
        super(Objects.requireNonNull(base), (Graph)Objects.requireNonNull(sub));
        this.gem = (GraphEventManager)Objects.requireNonNull(gem, "Null event manager.");
    }

    public Graph getBaseGraph() {
        return this.L;
    }

    public OntMultiUnion getUnderlying() {
        return (OntMultiUnion)this.R;
    }

    public void performDelete(Triple t) {
        this.L.delete(t);
    }

    public void performAdd(Triple t) {
        if (!this.R.contains(t)) {
            this.L.add(t);
        }
    }

    public OntEventManager getEventManager() {
        return (OntEventManager)this.gem;
    }

    public PrefixMapping getPrefixMapping() {
        return this.L.getPrefixMapping();
    }

    public void addGraph(Graph graph) {
        this.getUnderlying().addGraph(graph);
    }

    public void removeGraph(Graph graph) {
        this.getUnderlying().removeGraph(graph);
    }

    protected ExtendedIterator<Triple> _graphBaseFind(Triple t) {
        if (((OntMultiUnion)this.R).hasSubGraphs()) {
            return super._graphBaseFind(t);
        }
        return this.L.find(t);
    }

    public static class OntEventManager
    extends SimpleEventManager {
        public Stream<GraphListener> listeners() {
            return this.listeners.stream();
        }

        public boolean hasListeners(Class<? extends GraphListener> view) {
            return this.listeners().anyMatch(l -> view.isAssignableFrom(l.getClass()));
        }
    }

    public static class OntMultiUnion
    extends MultiUnion {
        public OntMultiUnion() {
        }

        public OntMultiUnion(Graph[] graphs) {
            super(graphs);
        }

        public OntMultiUnion(Iterator<Graph> graphs) {
            super(graphs);
        }

        public Stream<Graph> graphs() {
            return this.m_subGraphs.stream();
        }

        public boolean hasSubGraphs() {
            return !this.m_subGraphs.isEmpty();
        }
    }
}

