/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntPEImpl;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class OntAPropertyImpl
extends OntPEImpl
implements OntNAP {
    public OntAPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Class<OntNAP> getActualClass() {
        return OntNAP.class;
    }

    @Override
    public OntStatement addDomain(Resource domain) {
        return this.addStatement(RDFS.domain, (RDFNode)OntAPropertyImpl.checkNamed(domain));
    }

    @Override
    public OntStatement addRange(Resource range) {
        return this.addStatement(RDFS.range, (RDFNode)OntAPropertyImpl.checkNamed(range));
    }

    @Override
    public Stream<Resource> domain() {
        return this.objects(RDFS.domain, Resource.class).filter(RDFNode::isURIResource);
    }

    @Override
    public Stream<Resource> range() {
        return this.objects(RDFS.range, Resource.class).filter(RDFNode::isURIResource);
    }

    @Override
    public boolean isBuiltIn() {
        return Entities.ANNOTATION_PROPERTY.builtInURIs().contains(this);
    }

    public Property inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntAPropertyImpl.getOptionalRootStatement(this, OWL.AnnotationProperty);
    }
}

