/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public abstract class OntCEImpl
extends OntObjectImpl
implements OntCE {
    public static final OntFinder CLASS_FINDER = new OntFinder.ByType(OWL.Class);
    public static final OntFinder RESTRICTION_FINDER = new OntFinder.ByType(OWL.Restriction);
    public static final OntFilter RESTRICTION_FILTER = OntFilter.BLANK.and(new OntFilter.HasType(OWL.Restriction));
    public static final OntFilter CE_FITTING_FILTER = new OntFilter.OneOf(Entities.CLASS.builtInURIs()).or(new OntFilter.HasType(OWL.Class).or(new OntFilter.HasType(OWL.Restriction)));
    public static OntObjectFactory unionOfCEFactory = OntCEImpl.createCEFactory(UnionOfImpl.class, OWL.unionOf, RDFList.class);
    public static OntObjectFactory intersectionOfCEFactory = OntCEImpl.createCEFactory(IntersectionOfImpl.class, OWL.intersectionOf, RDFList.class);
    public static OntObjectFactory oneOfCEFactory = OntCEImpl.createCEFactory(OneOfImpl.class, OWL.oneOf, RDFList.class);
    public static OntObjectFactory complementOfCEFactory = OntCEImpl.createCEFactory(ComplementOfImpl.class, OWL.complementOf, OntCE.class);
    public static OntObjectFactory objectSomeValuesOfCEFactory = OntCEImpl.createRestrictionFactory(ObjectSomeValuesFromImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, OWL.someValuesFrom);
    public static OntObjectFactory dataSomeValuesOfCEFactory = OntCEImpl.createRestrictionFactory(DataSomeValuesFromImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, OWL.someValuesFrom);
    public static OntObjectFactory objectAllValuesOfCEFactory = OntCEImpl.createRestrictionFactory(ObjectAllValuesFromImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, OWL.allValuesFrom);
    public static OntObjectFactory dataAllValuesOfCEFactory = OntCEImpl.createRestrictionFactory(DataAllValuesFromImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, OWL.allValuesFrom);
    public static OntObjectFactory objectHasValueCEFactory = OntCEImpl.createRestrictionFactory(ObjectHasValueImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.INDIVIDUAL, OWL.hasValue);
    public static OntObjectFactory dataHasValueCEFactory = OntCEImpl.createRestrictionFactory(DataHasValueImpl.class, RestrictionType.DATA, ObjectRestrictionType.LITERAL, OWL.hasValue);
    public static OntObjectFactory dataMinCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataMinCardinalityImpl.class, RestrictionType.DATA, CardinalityType.MIN);
    public static OntObjectFactory objectMinCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectMinCardinalityImpl.class, RestrictionType.OBJECT, CardinalityType.MIN);
    public static OntObjectFactory dataMaxCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataMaxCardinalityImpl.class, RestrictionType.DATA, CardinalityType.MAX);
    public static OntObjectFactory objectMaxCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectMaxCardinalityImpl.class, RestrictionType.OBJECT, CardinalityType.MAX);
    public static OntObjectFactory dataCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataCardinalityImpl.class, RestrictionType.DATA, CardinalityType.EXACTLY);
    public static OntObjectFactory objectCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectCardinalityImpl.class, RestrictionType.OBJECT, CardinalityType.EXACTLY);
    public static OntObjectFactory hasSelfCEFactory = new CommonOntObjectFactory(new HasSelfMaker(), RESTRICTION_FINDER, OntFilter.BLANK.and(new HasSelfFilter()), new OntFilter[0]);
    public static OntObjectFactory naryDataAllValuesFromCEFactory = OntCEImpl.createNaryFactory(NaryDataAllValuesFromImpl.class, OWL.allValuesFrom);
    public static OntObjectFactory naryDataSomeValuesFromCEFactory = OntCEImpl.createNaryFactory(NaryDataSomeValuesFromImpl.class, OWL.someValuesFrom);
    public static OntObjectFactory abstractNaryRestrictionCEFactory = new MultiOntObjectFactory(RESTRICTION_FINDER, null, naryDataAllValuesFromCEFactory, naryDataSomeValuesFromCEFactory);
    public static OntObjectFactory abstractComponentsCEFactory = new MultiOntObjectFactory(CLASS_FINDER, null, unionOfCEFactory, intersectionOfCEFactory, oneOfCEFactory);
    public static OntObjectFactory abstractNoneRestrictionCEFactory = new MultiOntObjectFactory(CLASS_FINDER, null, abstractComponentsCEFactory, complementOfCEFactory);
    public static OntObjectFactory abstractCardinalityRestrictionCEFactory = new MultiOntObjectFactory(RESTRICTION_FINDER, null, objectMinCardinalityCEFactory, dataMinCardinalityCEFactory, objectMaxCardinalityCEFactory, dataMaxCardinalityCEFactory, objectCardinalityCEFactory, dataCardinalityCEFactory);
    public static OntObjectFactory abstractNoneCardinalityRestrictionCEFactory = new MultiOntObjectFactory(RESTRICTION_FINDER, null, objectSomeValuesOfCEFactory, dataSomeValuesOfCEFactory, objectAllValuesOfCEFactory, dataAllValuesOfCEFactory, objectHasValueCEFactory, dataHasValueCEFactory, abstractNaryRestrictionCEFactory);
    public static OntObjectFactory abstractComponentRestrictionCEFactory = new MultiOntObjectFactory(RESTRICTION_FINDER, null, abstractCardinalityRestrictionCEFactory, abstractNoneCardinalityRestrictionCEFactory);
    public static OntObjectFactory abstractRestrictionCEFactory = new MultiOntObjectFactory(RESTRICTION_FINDER, null, abstractComponentRestrictionCEFactory, hasSelfCEFactory);
    public static OntObjectFactory abstractAnonymousCEFactory = new MultiOntObjectFactory(OntFinder.TYPED, null, abstractNoneRestrictionCEFactory, abstractRestrictionCEFactory);
    public static Configurable<OntObjectFactory> abstractCEFactory = ClassExpressionFactory::build;

    public OntCEImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Deprecated
    protected static OntObjectFactory createCEFactory(Class<? extends OntCEImpl> impl, Property predicate) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Class);
        OntFilter filter = OntFilter.BLANK.and(new OntFilter.HasType(OWL.Class)).and(new OntFilter.HasPredicate(predicate));
        return new CommonOntObjectFactory(maker, CLASS_FINDER, filter, new OntFilter[0]);
    }

    protected static OntObjectFactory createCEFactory(Class<? extends OntCEImpl> impl, Property predicate, Class<? extends RDFNode> view) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Class);
        OntFilter filter = OntFilter.BLANK.and(new OntFilter.HasType(OWL.Class)).and((n, g) -> {
            try (ExtendedIterator res = g.asGraph().find(n, predicate.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    if (!OntObjectImpl.canAs(view, ((Triple)res.next()).getObject(), g)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return new CommonOntObjectFactory(maker, CLASS_FINDER, filter, new OntFilter[0]);
    }

    protected static OntObjectFactory createRestrictionFactory(Class<? extends CardinalityRestrictionCEImpl> impl, RestrictionType restrictionType, CardinalityType cardinalityType) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(cardinalityType.getFilter()).and(restrictionType.getFilter());
        return new CommonOntObjectFactory(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    protected static OntObjectFactory createRestrictionFactory(Class<? extends ComponentRestrictionCEImpl> impl, RestrictionType propertyType, ObjectRestrictionType objectType, Property predicate) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(propertyType.getFilter()).and(objectType.getFilter(predicate));
        return new CommonOntObjectFactory(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    protected static OntObjectFactory createNaryFactory(Class<? extends NaryRestrictionCEImpl> impl, Property predicate) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(new OntFilter.HasPredicate(predicate)).and(new OntFilter.HasPredicate(OWL.onProperties));
        return new CommonOntObjectFactory(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    public static boolean isQualified(OntObject c) {
        return c != null && !OWL.Thing.equals((Object)c) && !RDFS.Literal.equals((Object)c);
    }

    protected static CardinalityType getCardinalityType(Class<? extends OntCE.CardinalityRestrictionCE> view) {
        if (OntCE.ObjectMinCardinality.class.equals(view) || OntCE.DataMinCardinality.class.equals(view)) {
            return CardinalityType.MIN;
        }
        if (OntCE.ObjectMaxCardinality.class.equals(view) || OntCE.DataMaxCardinality.class.equals(view)) {
            return CardinalityType.MAX;
        }
        return CardinalityType.EXACTLY;
    }

    protected static Literal createNonNegativeIntegerLiteral(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't accept negative value.");
        }
        return ResourceFactory.createTypedLiteral((String)String.valueOf(n), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
    }

    protected static Resource createOnPropertyRestriction(OntGraphModelImpl model, OntPE onProperty) {
        OntJenaException.notNull(onProperty, "Null property.");
        return model.createResource().addProperty(RDF.type, (RDFNode)OWL.Restriction).addProperty(OWL.onProperty, (RDFNode)onProperty);
    }

    public static <CE extends OntCE.ComponentRestrictionCE> CE createComponentRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntPE onProperty, RDFNode other, Property predicate) {
        OntJenaException.notNull(other, "Null expression.");
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty).addProperty(predicate, other);
        return (CE)((OntCE.ComponentRestrictionCE)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntCE.CardinalityRestrictionCE> CE createCardinalityRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntPE onProperty, int cardinality, OntObject object) {
        Literal value = OntCEImpl.createNonNegativeIntegerLiteral(cardinality);
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty);
        boolean qualified = OntCEImpl.isQualified(object);
        model.add(res, OntCEImpl.getCardinalityType(view).getPredicate(qualified), (RDFNode)value);
        if (qualified) {
            model.add(res, onProperty instanceof OntOPE ? OWL.onClass : OWL.onDataRange, (RDFNode)object);
        }
        return (CE)((OntCE.CardinalityRestrictionCE)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntCE.ComponentsCE> CE createComponentsCE(OntGraphModelImpl model, Class<CE> view, Property predicate, Iterator<? extends OntObject> components) {
        OntJenaException.notNull(components, "Null components stream.");
        Resource res = model.createResource(OWL.Class).addProperty(predicate, (RDFNode)model.createList(components));
        return (CE)((OntCE.ComponentsCE)model.getNodeAs(res.asNode(), view));
    }

    public static OntCE.HasSelf createHasSelf(OntGraphModelImpl model, OntOPE onProperty) {
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty).addProperty(OWL.hasSelf, (RDFNode)Models.TRUE);
        return model.getNodeAs(res.asNode(), OntCE.HasSelf.class);
    }

    public static OntCE.ComplementOf createComplementOf(OntGraphModelImpl model, OntCE other) {
        OntJenaException.notNull(other, "Null class expression.");
        Resource res = model.createResource(OWL.Class).addProperty(OWL.complementOf, (RDFNode)other);
        return model.getNodeAs(res.asNode(), OntCE.ComplementOf.class);
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(OntGraphModelImpl model, OntCE source) {
        return model.getNodeAs(model.createResource(source).asNode(), OntIndividual.Anonymous.class);
    }

    public static OntIndividual.Named createNamedIndividual(OntGraphModelImpl model, OntCE source, String uri) {
        Resource res = model.createResource(OntJenaException.notNull(uri, "Null uri"), source).addProperty(RDF.type, (RDFNode)OWL.NamedIndividual);
        return model.getNodeAs(res.asNode(), OntIndividual.Named.class);
    }

    public static OntList<OntDOP> createHasKey(OntGraphModelImpl m, OntCE clazz, Stream<? extends OntDOP> collection) {
        return OntListImpl.create(m, clazz, OWL.hasKey, OntDOP.class, collection.distinct().map(OntDOP.class::cast).iterator());
    }

    public static Optional<OntList<OntDOP>> findHasKey(OntCE clazz, RDFNode list) {
        return clazz.listHasKeys().filter(r -> Objects.equals(r, list)).findFirst();
    }

    public static Stream<OntList<OntDOP>> listHasKeys(OntGraphModelImpl m, OntCE clazz) {
        return OntListImpl.stream(m, clazz, OWL.hasKey, OntDOP.class);
    }

    public static void removeHasKey(OntCE clazz, RDFNode rdfList) throws OntJenaException.IllegalArgument {
        clazz.remove(OWL.hasKey, (RDFNode)clazz.findHasKey(rdfList).orElseThrow(() -> new OntJenaException.IllegalArgument("Can't find list " + rdfList)).clearAnnotations().clear());
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntCEImpl.getRequiredRootStatement(this, OWL.Class);
    }

    public abstract Class<? extends OntCE> getActualClass();

    @Override
    public OntIndividual.Anonymous createIndividual() {
        return OntCEImpl.createAnonymousIndividual(this.getModel(), this);
    }

    @Override
    public OntIndividual.Named createIndividual(String uri) {
        return OntCEImpl.createNamedIndividual(this.getModel(), this, uri);
    }

    @Override
    public OntList<OntDOP> createHasKey(Collection<OntOPE> ope, Collection<OntNDP> dpe) {
        return OntCEImpl.createHasKey(this.getModel(), this, Stream.of(ope, dpe).flatMap(Collection::stream));
    }

    @Override
    public OntStatement addHasKey(OntDOP ... properties) {
        return OntCEImpl.createHasKey(this.getModel(), this, Arrays.stream(properties)).getRoot();
    }

    @Override
    public Optional<OntList<OntDOP>> findHasKey(RDFNode list) {
        return OntCEImpl.findHasKey(this, list);
    }

    @Override
    public Stream<OntList<OntDOP>> listHasKeys() {
        return OntCEImpl.listHasKeys(this.getModel(), this);
    }

    @Override
    public void removeHasKey(RDFNode list) throws OntJenaException.IllegalArgument {
        OntCEImpl.removeHasKey(this, list);
    }

    @Override
    public void removeHasKey() {
        this.clearAll(OWL.hasKey);
    }

    public static class ClassExpressionFactory
    extends OntObjectFactory {
        private static final Node CLASS = OWL.Class.asNode();
        private static final Node RESTRICTION = OWL.Restriction.asNode();
        private final OntObjectFactory namedClass;
        private final Collection<OntObjectFactory> anonymousClasses;
        private final Collection<OntObjectFactory> restrictions;

        protected ClassExpressionFactory(OntObjectFactory namedClass, Collection<OntObjectFactory> anonymousClasses, Collection<OntObjectFactory> restrictions) {
            this.namedClass = namedClass;
            this.anonymousClasses = anonymousClasses;
            this.restrictions = restrictions;
        }

        public static OntObjectFactory build(Configurable.Mode m) {
            return new ClassExpressionFactory(Entities.CLASS.select(m), Arrays.asList(unionOfCEFactory, intersectionOfCEFactory, oneOfCEFactory, complementOfCEFactory), Arrays.asList(objectSomeValuesOfCEFactory, dataSomeValuesOfCEFactory, objectAllValuesOfCEFactory, dataAllValuesOfCEFactory, objectHasValueCEFactory, dataHasValueCEFactory, dataMinCardinalityCEFactory, objectMinCardinalityCEFactory, dataMaxCardinalityCEFactory, objectMaxCardinalityCEFactory, dataCardinalityCEFactory, objectCardinalityCEFactory, hasSelfCEFactory, naryDataAllValuesFromCEFactory, naryDataSomeValuesFromCEFactory));
        }

        private static EnhNode map(Collection<OntObjectFactory> factories, Node n, EnhGraph g) {
            for (OntObjectFactory f : factories) {
                EnhNode r = ClassExpressionFactory.map(f, n, g);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        private static EnhNode map(OntObjectFactory f, Node n, EnhGraph g) {
            try {
                return f.wrap(n, g);
            }
            catch (ConversionException c) {
                return null;
            }
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph g) {
            return g.asGraph().find(Node.ANY, RDF.Nodes.type, CLASS).mapWith(t -> {
                Node n = t.getSubject();
                return n.isURI() ? ClassExpressionFactory.map(this.namedClass, n, g) : ClassExpressionFactory.map(this.anonymousClasses, n, g);
            }).andThen((Iterator)g.asGraph().find(Node.ANY, RDF.Nodes.type, RESTRICTION).mapWith(t -> ClassExpressionFactory.map(this.restrictions, t.getSubject(), g))).filterDrop(Objects::isNull);
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            if (node.isURI()) {
                return this.namedClass.canWrap(node, eg);
            }
            if (eg.asGraph().contains(node, RDF.Nodes.type, RESTRICTION)) {
                for (OntObjectFactory f : this.restrictions) {
                    if (!f.canWrap(node, eg)) continue;
                    return true;
                }
                return false;
            }
            for (OntObjectFactory f : this.anonymousClasses) {
                if (!f.canWrap(node, eg)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected EnhNode doWrap(Node node, EnhGraph eg) {
            if (node.isURI()) {
                return ClassExpressionFactory.map(this.namedClass, node, eg);
            }
            if (eg.asGraph().contains(node, RDF.Nodes.type, CLASS)) {
                return ClassExpressionFactory.map(this.anonymousClasses, node, eg);
            }
            return ClassExpressionFactory.map(this.restrictions, node, eg);
        }

        @Override
        public EnhNode wrap(Node node, EnhGraph eg) throws ConversionException {
            if (node.isURI()) {
                return this.namedClass.wrap(node, eg);
            }
            ConversionException ex = new ConversionException("Can't convert node " + node + " to Class Expression.");
            if (eg.asGraph().contains(node, RDF.Nodes.type, RESTRICTION)) {
                for (OntObjectFactory f : this.restrictions) {
                    try {
                        return f.wrap(node, eg);
                    }
                    catch (ConversionException c) {
                        ex.addSuppressed((Throwable)c);
                    }
                }
                throw ex;
            }
            for (OntObjectFactory f : this.anonymousClasses) {
                try {
                    return f.wrap(node, eg);
                }
                catch (ConversionException c) {
                    ex.addSuppressed((Throwable)c);
                }
            }
            throw ex;
        }
    }

    protected static class HasSelfMaker
    extends OntMaker.WithType {
        protected HasSelfMaker() {
            super(HasSelfImpl.class, OWL.Restriction);
        }

        @Override
        public void make(Node node, EnhGraph eg) {
            super.make(node, eg);
            eg.asGraph().add(Triple.create((Node)node, (Node)OWL.hasSelf.asNode(), (Node)Models.TRUE.asNode()));
        }
    }

    protected static class HasSelfFilter
    implements OntFilter {
        protected HasSelfFilter() {
        }

        @Override
        public boolean test(Node n, EnhGraph g) {
            return g.asGraph().contains(n, OWL.hasSelf.asNode(), Models.TRUE.asNode());
        }
    }

    protected static abstract class NaryRestrictionCEImpl<O extends OntObject, P extends OntDOP>
    extends OntCEImpl
    implements OntCE.NaryRestrictionCE<O, P> {
        protected final Property predicate;
        protected final Class<O> objectType;
        protected final Class<P> propertyType;

        protected NaryRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<P> propertyType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.propertyType = propertyType;
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NaryRestrictionCEImpl.getRequiredRootStatement(this, OWL.Restriction);
        }

        @Override
        public O getValue() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectType));
        }

        @Override
        public void setValue(O value) {
            throw new OntJenaException.Unsupported("TODO");
        }

        @Override
        public Class<? extends OntCE> getActualClass() {
            return OntCE.NaryRestrictionCE.class;
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.of(super.spec(), this.required(this.predicate), this.getList().content()).flatMap(Function.identity());
        }

        @Override
        public OntList<P> getList() {
            return OntListImpl.asSafeOntList(this.getRequiredObject(OWL.onProperties, RDFList.class), this.getModel(), this, this.predicate, null, this.propertyType);
        }
    }

    protected static abstract class CardinalityRestrictionCEImpl<O extends OntObject, P extends OntDOP>
    extends ComponentRestrictionCEImpl<O, P>
    implements OntCE.CardinalityRestrictionCE<O, P> {
        protected final CardinalityType cardinalityType;

        protected CardinalityRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView, CardinalityType cardinalityType) {
            super(n, m, predicate, objectView, propertyView);
            this.cardinalityType = cardinalityType;
        }

        @Override
        public Stream<OntStatement> spec() {
            boolean q = this.isQualified();
            return Stream.concat(super.spec(q), this.required(this.getCardinalityPredicate(q)));
        }

        @Override
        public O getValue() {
            return (O)((OntObject)this.object(this.predicate, this.objectView).orElse(null));
        }

        @Override
        public int getCardinality() {
            return this.getRequiredObject(this.getCardinalityPredicate(), Literal.class).getInt();
        }

        @Override
        public void setCardinality(int cardinality) {
            Literal value = CardinalityRestrictionCEImpl.createNonNegativeIntegerLiteral(cardinality);
            Property property = this.getCardinalityPredicate();
            this.clearProperty(property);
            this.addLiteral(property, value);
        }

        protected Property getCardinalityPredicate() {
            return this.getCardinalityPredicate(this.isQualified());
        }

        protected Property getCardinalityPredicate(boolean q) {
            return this.cardinalityType.getPredicate(q);
        }

        @Override
        public boolean isQualified() {
            return CardinalityRestrictionCEImpl.isQualified(this.getValue());
        }
    }

    protected static abstract class ComponentRestrictionCEImpl<O extends RDFNode, P extends OntDOP>
    extends OnPropertyRestrictionCEImpl<P>
    implements OntCE.ComponentRestrictionCE<O, P> {
        protected final Property predicate;
        protected final Class<O> objectView;

        protected ComponentRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView) {
            super(n, m, propertyView);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.objectView = OntJenaException.notNull(objectView, "Null object view.");
        }

        @Override
        public Stream<OntStatement> spec() {
            return this.spec(true);
        }

        protected Stream<OntStatement> spec(boolean requireObject) {
            return requireObject ? Stream.concat(super.spec(), this.required(this.predicate)) : super.spec();
        }

        @Override
        public O getValue() {
            return this.getModel().getNodeAs(this.getRequiredProperty(this.predicate).getObject().asNode(), this.objectView);
        }

        @Override
        public void setValue(O c) {
            this.clearProperty(this.predicate);
            this.addProperty(this.predicate, (RDFNode)c);
        }
    }

    protected static abstract class OnPropertyRestrictionCEImpl<P extends OntDOP>
    extends OntCEImpl
    implements OntCE.ONProperty<P> {
        protected final Class<P> propertyView;

        protected OnPropertyRestrictionCEImpl(Node n, EnhGraph m, Class<P> propertyType) {
            super(n, m);
            this.propertyView = propertyType;
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return OnPropertyRestrictionCEImpl.getRequiredRootStatement(this, OWL.Restriction);
        }

        @Override
        public P getOnProperty() {
            return (P)((OntDOP)this.getRequiredObject(OWL.onProperty, this.propertyView));
        }

        @Override
        public void setOnProperty(P p) {
            Objects.requireNonNull(p, "Null " + OnPropertyRestrictionCEImpl.viewAsString(this.propertyView));
            this.clearProperty(OWL.onProperty);
            this.addProperty(OWL.onProperty, (RDFNode)p);
        }

        protected void clearProperty(Property property) {
            this.removeAll(property);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(OWL.onProperty));
        }
    }

    protected static abstract class ComponentsCEImpl<O extends OntObject>
    extends OntCEImpl
    implements OntCE.ComponentsCE<O> {
        protected final Property predicate;
        protected final Class<O> type;

        protected ComponentsCEImpl(Node n, EnhGraph m, Property predicate, Class<O> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.getList().content());
        }

        @Override
        public OntList<O> getList() {
            return OntListImpl.asSafeOntList(this.getRequiredObject(this.predicate, RDFList.class), this.getModel(), this, this.predicate, null, this.type);
        }
    }

    public static class NaryDataSomeValuesFromImpl
    extends NaryRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.NaryDataSomeValuesFrom {
        public NaryDataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntDR.class, OntNDP.class);
        }

        @Override
        public Class<? extends OntCE> getActualClass() {
            return OntCE.NaryDataSomeValuesFrom.class;
        }
    }

    public static class NaryDataAllValuesFromImpl
    extends NaryRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.NaryDataAllValuesFrom {
        public NaryDataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntDR.class, OntNDP.class);
        }

        @Override
        public Class<? extends OntCE> getActualClass() {
            return OntCE.NaryDataAllValuesFrom.class;
        }
    }

    public static class ComplementOfImpl
    extends OntCEImpl
    implements OntCE.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(OWL.complementOf));
        }

        public Class<OntCE.ComplementOf> getActualClass() {
            return OntCE.ComplementOf.class;
        }

        @Override
        public OntCE getValue() {
            return this.getRequiredObject(OWL.complementOf, OntCE.class);
        }

        @Override
        public void setValue(OntCE c) {
            Objects.requireNonNull(c, "Null component");
            this.clear();
            this.addProperty(OWL.complementOf, (RDFNode)c);
        }

        void clear() {
            this.removeAll(OWL.complementOf);
        }
    }

    public static class HasSelfImpl
    extends OnPropertyRestrictionCEImpl<OntOPE>
    implements OntCE.HasSelf {
        public HasSelfImpl(Node n, EnhGraph m) {
            super(n, m, OntOPE.class);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(OWL.hasSelf));
        }

        public Class<OntCE.HasSelf> getActualClass() {
            return OntCE.HasSelf.class;
        }
    }

    public static class ObjectCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntCE, OntOPE>
    implements OntCE.ObjectCardinality {
        public ObjectCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntCE.class, OntOPE.class, CardinalityType.EXACTLY);
        }

        public Class<OntCE.ObjectCardinality> getActualClass() {
            return OntCE.ObjectCardinality.class;
        }
    }

    public static class DataCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.DataCardinality {
        public DataCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDR.class, OntNDP.class, CardinalityType.EXACTLY);
        }

        public Class<OntCE.DataCardinality> getActualClass() {
            return OntCE.DataCardinality.class;
        }
    }

    public static class ObjectMaxCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntCE, OntOPE>
    implements OntCE.ObjectMaxCardinality {
        public ObjectMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntCE.class, OntOPE.class, CardinalityType.MAX);
        }

        public Class<OntCE.ObjectMaxCardinality> getActualClass() {
            return OntCE.ObjectMaxCardinality.class;
        }
    }

    public static class DataMaxCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.DataMaxCardinality {
        public DataMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDR.class, OntNDP.class, CardinalityType.MAX);
        }

        public Class<OntCE.DataMaxCardinality> getActualClass() {
            return OntCE.DataMaxCardinality.class;
        }
    }

    public static class ObjectMinCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntCE, OntOPE>
    implements OntCE.ObjectMinCardinality {
        public ObjectMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntCE.class, OntOPE.class, CardinalityType.MIN);
        }

        public Class<OntCE.ObjectMinCardinality> getActualClass() {
            return OntCE.ObjectMinCardinality.class;
        }
    }

    public static class DataMinCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.DataMinCardinality {
        public DataMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDR.class, OntNDP.class, CardinalityType.MIN);
        }

        public Class<OntCE.DataMinCardinality> getActualClass() {
            return OntCE.DataMinCardinality.class;
        }
    }

    public static class OneOfImpl
    extends ComponentsCEImpl<OntIndividual>
    implements OntCE.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.oneOf, OntIndividual.class);
        }

        public Class<OntCE.OneOf> getActualClass() {
            return OntCE.OneOf.class;
        }
    }

    public static class IntersectionOfImpl
    extends ComponentsCEImpl<OntCE>
    implements OntCE.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.intersectionOf, OntCE.class);
        }

        public Class<OntCE.IntersectionOf> getActualClass() {
            return OntCE.IntersectionOf.class;
        }
    }

    public static class UnionOfImpl
    extends ComponentsCEImpl<OntCE>
    implements OntCE.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.unionOf, OntCE.class);
        }

        public Class<OntCE.UnionOf> getActualClass() {
            return OntCE.UnionOf.class;
        }
    }

    public static class DataHasValueImpl
    extends ComponentRestrictionCEImpl<Literal, OntNDP>
    implements OntCE.DataHasValue {
        public DataHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL.hasValue, Literal.class, OntNDP.class);
        }

        public Class<OntCE.DataHasValue> getActualClass() {
            return OntCE.DataHasValue.class;
        }
    }

    public static class ObjectHasValueImpl
    extends ComponentRestrictionCEImpl<OntIndividual, OntOPE>
    implements OntCE.ObjectHasValue {
        public ObjectHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL.hasValue, OntIndividual.class, OntOPE.class);
        }

        public Class<OntCE.ObjectHasValue> getActualClass() {
            return OntCE.ObjectHasValue.class;
        }
    }

    public static class DataAllValuesFromImpl
    extends ComponentRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.DataAllValuesFrom {
        public DataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntDR.class, OntNDP.class);
        }

        public Class<OntCE.DataAllValuesFrom> getActualClass() {
            return OntCE.DataAllValuesFrom.class;
        }
    }

    public static class ObjectAllValuesFromImpl
    extends ComponentRestrictionCEImpl<OntCE, OntOPE>
    implements OntCE.ObjectAllValuesFrom {
        public ObjectAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntCE.class, OntOPE.class);
        }

        public Class<OntCE.ObjectAllValuesFrom> getActualClass() {
            return OntCE.ObjectAllValuesFrom.class;
        }
    }

    public static class DataSomeValuesFromImpl
    extends ComponentRestrictionCEImpl<OntDR, OntNDP>
    implements OntCE.DataSomeValuesFrom {
        public DataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntDR.class, OntNDP.class);
        }

        public Class<OntCE.DataSomeValuesFrom> getActualClass() {
            return OntCE.DataSomeValuesFrom.class;
        }
    }

    public static class ObjectSomeValuesFromImpl
    extends ComponentRestrictionCEImpl<OntCE, OntOPE>
    implements OntCE.ObjectSomeValuesFrom {
        public ObjectSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntCE.class, OntOPE.class);
        }

        public Class<OntCE.ObjectSomeValuesFrom> getActualClass() {
            return OntCE.ObjectSomeValuesFrom.class;
        }
    }

    private static interface PredicateFilterProvider {
        public Class<? extends RDFNode> view();

        default public OntFilter getFilter(Property predicate) {
            return (node, graph) -> this.testObjects(predicate, node, graph);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public boolean testObjects(Property predicate, Node node, EnhGraph graph) {
            Class<? extends RDFNode> v = this.view();
            try (ExtendedIterator res = graph.asGraph().find(node, predicate.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    if (!OntObjectImpl.canAs(v, ((Triple)res.next()).getObject(), graph)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
    }

    protected static enum CardinalityType {
        EXACTLY(OWL.qualifiedCardinality, OWL.cardinality),
        MAX(OWL.maxQualifiedCardinality, OWL.maxCardinality),
        MIN(OWL.minQualifiedCardinality, OWL.minCardinality);

        protected final Property qualifiedPredicate;
        protected final Property predicate;

        private CardinalityType(Property qualifiedPredicate, Property predicate) {
            this.qualifiedPredicate = qualifiedPredicate;
            this.predicate = predicate;
        }

        public OntFilter getFilter() {
            return (n, g) -> g.asGraph().contains(n, this.qualifiedPredicate.asNode(), Node.ANY) || g.asGraph().contains(n, this.predicate.asNode(), Node.ANY);
        }

        public Property getPredicate(boolean isQualified) {
            return isQualified ? this.qualifiedPredicate : this.predicate;
        }
    }

    protected static enum RestrictionType implements PredicateFilterProvider
    {
        DATA{

            public Class<OntNDP> view() {
                return OntNDP.class;
            }
        }
        ,
        OBJECT{

            public Class<OntOPE> view() {
                return OntOPE.class;
            }
        };


        public OntFilter getFilter() {
            return this.getFilter(OWL.onProperty);
        }
    }

    protected static enum ObjectRestrictionType implements PredicateFilterProvider
    {
        CLASS{

            public Class<OntCE> view() {
                return OntCE.class;
            }
        }
        ,
        DATA_RANGE{

            public Class<OntDR> view() {
                return OntDR.class;
            }
        }
        ,
        INDIVIDUAL{

            public Class<OntIndividual> view() {
                return OntIndividual.class;
            }
        }
        ,
        LITERAL{

            public Class<Literal> view() {
                return Literal.class;
            }
        };

    }
}

