/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDisjoint;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public abstract class OntDisjointImpl<O extends OntObject>
extends OntObjectImpl
implements OntDisjoint<O> {
    public static final OntFinder PROPERTIES_FINDER = new OntFinder.ByType(OWL.AllDisjointProperties);
    public static OntObjectFactory disjointClassesFactory = OntDisjointImpl.createFactory(ClassesImpl.class, OWL.AllDisjointClasses, OntCE.class, true, OWL.members);
    public static OntObjectFactory differentIndividualsFactory = OntDisjointImpl.createFactory(IndividualsImpl.class, OWL.AllDifferent, OntIndividual.class, true, OWL.members, OWL.distinctMembers);
    public static OntObjectFactory objectPropertiesFactory = OntDisjointImpl.createFactory(ObjectPropertiesImpl.class, OWL.AllDisjointProperties, OntOPE.class, false, OWL.members);
    public static OntObjectFactory dataPropertiesFactory = OntDisjointImpl.createFactory(DataPropertiesImpl.class, OWL.AllDisjointProperties, OntNDP.class, false, OWL.members);
    public static OntObjectFactory abstractPropertiesFactory = new MultiOntObjectFactory(PROPERTIES_FINDER, null, objectPropertiesFactory, dataPropertiesFactory);
    public static OntObjectFactory abstractDisjointFactory = new MultiOntObjectFactory(OntFinder.TYPED, null, abstractPropertiesFactory, disjointClassesFactory, differentIndividualsFactory);

    public OntDisjointImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDisjointImpl.getRequiredRootStatement(this, this.getResourceType());
    }

    protected Property getPredicate() {
        return OWL.members;
    }

    protected abstract Class<O> getComponentType();

    protected abstract Resource getResourceType();

    @Override
    public Stream<O> members() {
        return this.getList().members();
    }

    @Override
    public OntList<O> getList() {
        return OntListImpl.asOntList(this.getRequiredObject(this.getPredicate(), RDFList.class), this.getModel(), this, this.getPredicate(), null, this.getComponentType());
    }

    @Override
    public Stream<OntStatement> spec() {
        return Stream.concat(super.spec(), this.getList().content());
    }

    private static OntObjectFactory createFactory(Class<? extends OntDisjointImpl> impl, Resource type, Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, type);
        OntFinder.ByType finder = new OntFinder.ByType(type);
        OntFilter filter = OntFilter.BLANK.and(new OntFilter.HasType(type));
        return new CommonOntObjectFactory(maker, finder, filter.and(OntDisjointImpl.getHasPredicatesFilter(predicates)).and(OntDisjointImpl.getHasMembersOfFilter(view, allowEmptyList, predicates)), new OntFilter[0]);
    }

    private static OntFilter getHasPredicatesFilter(Property ... predicates) {
        OntFilter res = OntFilter.FALSE;
        for (Property p : predicates) {
            res = res.or(new OntFilter.HasPredicate(p));
        }
        return res;
    }

    private static OntFilter getHasMembersOfFilter(Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        return (node, eg) -> {
            try (ExtendedIterator<Node> res = OntDisjointImpl.listRoots(node, eg.asGraph(), predicates);){
                while (res.hasNext()) {
                    if (!OntDisjointImpl.testList((Node)res.next(), eg, view, allowEmptyList)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        };
    }

    private static ExtendedIterator<Node> listRoots(Node node, Graph graph, Property ... predicates) {
        return Iter.flatMap(Iter.of(predicates), p -> graph.find(node, p.asNode(), Node.ANY).mapWith(Triple::getObject));
    }

    private static boolean testList(Node node, EnhGraph graph, Class<? extends RDFNode> view, boolean allowEmptyList) {
        if (!RDFListImpl.factory.canWrap(node, graph)) {
            return false;
        }
        if (view == null) {
            return true;
        }
        RDFList list = (RDFList)RDFListImpl.factory.wrap(node, graph).as(RDFList.class);
        return list.isEmpty() && allowEmptyList || Iter.asStream(list.iterator().mapWith(FrontsNode::asNode)).anyMatch(n -> OntObjectImpl.canAs(view, n, graph));
    }

    public static OntDisjoint.Classes createDisjointClasses(OntGraphModelImpl model, Stream<OntCE> classes) {
        OntJenaException.notNull(classes, "Null classes stream.");
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.AllDisjointClasses);
        res.addProperty(OWL.members, (RDFNode)model.createList(classes.iterator()));
        return model.getNodeAs(res.asNode(), OntDisjoint.Classes.class);
    }

    public static OntDisjoint.Individuals createDifferentIndividuals(OntGraphModelImpl model, Stream<OntIndividual> individuals) {
        OntJenaException.notNull(individuals, "Null individuals stream.");
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.AllDifferent);
        res.addProperty(OWL.members, (RDFNode)model.createList(individuals.iterator()));
        return model.getNodeAs(res.asNode(), OntDisjoint.Individuals.class);
    }

    public static OntDisjoint.ObjectProperties createDisjointObjectProperties(OntGraphModelImpl model, Stream<OntOPE> properties) {
        OntJenaException.notNull(properties, "Null properties stream.");
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.AllDisjointProperties);
        res.addProperty(OWL.members, (RDFNode)model.createList(properties.iterator()));
        return model.getNodeAs(res.asNode(), OntDisjoint.ObjectProperties.class);
    }

    public static OntDisjoint.DataProperties createDisjointDataProperties(OntGraphModelImpl model, Stream<OntNDP> properties) {
        OntJenaException.notNull(properties, "Null properties stream.");
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.AllDisjointProperties);
        res.addProperty(OWL.members, (RDFNode)model.createList(properties.iterator()));
        return model.getNodeAs(res.asNode(), OntDisjoint.DataProperties.class);
    }

    public static class DataPropertiesImpl
    extends PropertiesImpl<OntNDP>
    implements OntDisjoint.DataProperties {
        public DataPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.DataProperties.class;
        }

        @Override
        protected Class<OntNDP> getComponentType() {
            return OntNDP.class;
        }
    }

    public static class ObjectPropertiesImpl
    extends PropertiesImpl<OntOPE>
    implements OntDisjoint.ObjectProperties {
        public ObjectPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.ObjectProperties.class;
        }

        @Override
        protected Class<OntOPE> getComponentType() {
            return OntOPE.class;
        }
    }

    public static abstract class PropertiesImpl<P extends OntPE>
    extends OntDisjointImpl<P>
    implements OntDisjoint.Properties<P> {
        public PropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDisjointProperties;
        }
    }

    public static class IndividualsImpl
    extends OntDisjointImpl<OntIndividual>
    implements OntDisjoint.Individuals {
        public IndividualsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Stream<OntIndividual> members() {
            return this.lists().flatMap(OntList::members);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.lists().flatMap(OntList::content));
        }

        public Stream<Property> predicates() {
            return Stream.of(this.getPredicate(), this.getAlternativePredicate());
        }

        public Stream<OntList<OntIndividual>> lists() {
            return this.predicates().map(this::findList).filter(Optional::isPresent).map(Optional::get);
        }

        @Override
        public OntList<OntIndividual> getList() {
            Optional<OntList<OntIndividual>> p = this.findList(this.getPredicate());
            Optional<OntList<OntIndividual>> a = this.findList(this.getAlternativePredicate());
            if (p.isPresent() && a.isPresent()) {
                if (p.get().size() > a.get().size()) {
                    return p.get();
                }
                if (p.get().size() < a.get().size()) {
                    return a.get();
                }
            }
            if (p.isPresent()) {
                return p.get();
            }
            if (a.isPresent()) {
                return a.get();
            }
            throw new OntJenaException.IllegalState("Neither owl:members or owl:distinctMembers could be found");
        }

        public Optional<OntList<OntIndividual>> findList(Property predicate) {
            if (!this.hasProperty(predicate)) {
                return Optional.empty();
            }
            return Optional.of(OntListImpl.asOntList(this.getRequiredObject(predicate, RDFList.class), this.getModel(), this, predicate, null, this.getComponentType()));
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.Individuals.class;
        }

        protected Property getAlternativePredicate() {
            return OWL.distinctMembers;
        }

        @Override
        protected Class<OntIndividual> getComponentType() {
            return OntIndividual.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDifferent;
        }
    }

    public static class ClassesImpl
    extends OntDisjointImpl<OntCE>
    implements OntDisjoint.Classes {
        public ClassesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.Classes.class;
        }

        @Override
        protected Class<OntCE> getComponentType() {
            return OntCE.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDisjointClasses;
        }
    }
}

