/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.vocabulary.XSD;

public abstract class OntFRImpl
extends OntObjectImpl
implements OntFR {
    public static OntObjectFactory lengthFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(LengthImpl.class), OntFRImpl.makeFinder(XSD.length), OntFRImpl.makeFilter(XSD.length), new OntFilter[0]);
    public static OntObjectFactory minLengthFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MinLengthImpl.class), OntFRImpl.makeFinder(XSD.minLength), OntFRImpl.makeFilter(XSD.minLength), new OntFilter[0]);
    public static OntObjectFactory maxLengthFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MaxLengthImpl.class), OntFRImpl.makeFinder(XSD.maxLength), OntFRImpl.makeFilter(XSD.maxLength), new OntFilter[0]);
    public static OntObjectFactory minInclusiveFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MinInclusiveImpl.class), OntFRImpl.makeFinder(XSD.minInclusive), OntFRImpl.makeFilter(XSD.minInclusive), new OntFilter[0]);
    public static OntObjectFactory maxInclusiveFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MaxInclusiveImpl.class), OntFRImpl.makeFinder(XSD.maxInclusive), OntFRImpl.makeFilter(XSD.maxInclusive), new OntFilter[0]);
    public static OntObjectFactory minExclusiveFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MinExclusiveImpl.class), OntFRImpl.makeFinder(XSD.minExclusive), OntFRImpl.makeFilter(XSD.minExclusive), new OntFilter[0]);
    public static OntObjectFactory maxExclusiveFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(MaxExclusiveImpl.class), OntFRImpl.makeFinder(XSD.maxExclusive), OntFRImpl.makeFilter(XSD.maxExclusive), new OntFilter[0]);
    public static OntObjectFactory totalDigitsFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(TotalDigitsImpl.class), OntFRImpl.makeFinder(XSD.totalDigits), OntFRImpl.makeFilter(XSD.totalDigits), new OntFilter[0]);
    public static OntObjectFactory fractionDigitsFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(FractionDigitsImpl.class), OntFRImpl.makeFinder(XSD.fractionDigits), OntFRImpl.makeFilter(XSD.fractionDigits), new OntFilter[0]);
    public static OntObjectFactory patternFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(PatternImpl.class), OntFRImpl.makeFinder(XSD.pattern), OntFRImpl.makeFilter(XSD.pattern), new OntFilter[0]);
    public static OntObjectFactory langRangeFRFactory = new CommonOntObjectFactory(OntFRImpl.makeMaker(LangRangeImpl.class), OntFRImpl.makeFinder(RDF.langRange), OntFRImpl.makeFilter(RDF.langRange), new OntFilter[0]);
    public static OntObjectFactory abstractFRFactory = new MultiOntObjectFactory(OntFinder.ANY_SUBJECT, null, lengthFRFactory, minLengthFRFactory, maxLengthFRFactory, minInclusiveFRFactory, maxInclusiveFRFactory, minExclusiveFRFactory, maxExclusiveFRFactory, totalDigitsFRFactory, fractionDigitsFRFactory, patternFRFactory, langRangeFRFactory);

    public OntFRImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return Optional.of(this.getModel().createStatement(this, OntFRImpl.predicate(this.getActualClass()), (RDFNode)this.getValue()));
    }

    @Override
    public Literal getValue() {
        return this.getRequiredObject(OntFRImpl.predicate(this.getActualClass()), Literal.class);
    }

    private static OntMaker makeMaker(Class<? extends OntFRImpl> impl) {
        return new OntMaker.Default(impl);
    }

    private static OntFinder makeFinder(Property predicate) {
        return new OntFinder.ByPredicate(predicate);
    }

    private static OntFilter makeFilter(Property predicate) {
        return OntFilter.BLANK.and((n, g) -> !g.asGraph().find(n, predicate.asNode(), Node.ANY).mapWith(Triple::getObject).filterKeep(Node::isLiteral).toList().isEmpty());
    }

    private static Property predicate(Class<?> view) {
        if (OntFR.Length.class.equals(view)) {
            return XSD.length;
        }
        if (OntFR.MinLength.class.equals(view)) {
            return XSD.minLength;
        }
        if (OntFR.MaxLength.class.equals(view)) {
            return XSD.maxLength;
        }
        if (OntFR.MinInclusive.class.equals(view)) {
            return XSD.minInclusive;
        }
        if (OntFR.MaxInclusive.class.equals(view)) {
            return XSD.maxInclusive;
        }
        if (OntFR.MinExclusive.class.equals(view)) {
            return XSD.minExclusive;
        }
        if (OntFR.MaxExclusive.class.equals(view)) {
            return XSD.maxExclusive;
        }
        if (OntFR.TotalDigits.class.equals(view)) {
            return XSD.totalDigits;
        }
        if (OntFR.FractionDigits.class.equals(view)) {
            return XSD.fractionDigits;
        }
        if (OntFR.Pattern.class.equals(view)) {
            return XSD.pattern;
        }
        if (OntFR.LangRange.class.equals(view)) {
            return RDF.langRange;
        }
        throw new OntJenaException("Unsupported facet restriction " + view);
    }

    public static <T extends OntFR> T create(OntGraphModelImpl model, Class<T> view, Literal literal) {
        Resource res = model.createResource();
        res.addProperty(OntFRImpl.predicate(view), (RDFNode)literal);
        return (T)((OntFR)model.getNodeAs(res.asNode(), view));
    }

    public static class LangRangeImpl
    extends OntFRImpl
    implements OntFR.LangRange {
        public LangRangeImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.LangRange> getActualClass() {
            return OntFR.LangRange.class;
        }
    }

    public static class FractionDigitsImpl
    extends OntFRImpl
    implements OntFR.FractionDigits {
        public FractionDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.FractionDigits> getActualClass() {
            return OntFR.FractionDigits.class;
        }
    }

    public static class TotalDigitsImpl
    extends OntFRImpl
    implements OntFR.TotalDigits {
        public TotalDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.TotalDigits> getActualClass() {
            return OntFR.TotalDigits.class;
        }
    }

    public static class PatternImpl
    extends OntFRImpl
    implements OntFR.Pattern {
        public PatternImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.Pattern> getActualClass() {
            return OntFR.Pattern.class;
        }
    }

    public static class MaxExclusiveImpl
    extends OntFRImpl
    implements OntFR.MaxExclusive {
        public MaxExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MaxExclusive> getActualClass() {
            return OntFR.MaxExclusive.class;
        }
    }

    public static class MinExclusiveImpl
    extends OntFRImpl
    implements OntFR.MinExclusive {
        public MinExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MinExclusive> getActualClass() {
            return OntFR.MinExclusive.class;
        }
    }

    public static class MaxInclusiveImpl
    extends OntFRImpl
    implements OntFR.MaxInclusive {
        public MaxInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MaxInclusive> getActualClass() {
            return OntFR.MaxInclusive.class;
        }
    }

    public static class MinInclusiveImpl
    extends OntFRImpl
    implements OntFR.MinInclusive {
        public MinInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MinInclusive> getActualClass() {
            return OntFR.MinInclusive.class;
        }
    }

    public static class MaxLengthImpl
    extends OntFRImpl
    implements OntFR.MaxLength {
        public MaxLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MaxLength> getActualClass() {
            return OntFR.MaxLength.class;
        }
    }

    public static class MinLengthImpl
    extends OntFRImpl
    implements OntFR.MinLength {
        public MinLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.MinLength> getActualClass() {
            return OntFR.MinLength.class;
        }
    }

    public static class LengthImpl
    extends OntFRImpl
    implements OntFR.Length {
        public LengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFR.Length> getActualClass() {
            return OntFR.Length.class;
        }
    }
}

