/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.InfModelImpl;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntCEImpl;
import ru.avicomp.ontapi.jena.impl.OntDRImpl;
import ru.avicomp.ontapi.jena.impl.OntDisjointImpl;
import ru.avicomp.ontapi.jena.impl.OntFRImpl;
import ru.avicomp.ontapi.jena.impl.OntSWRLImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.impl.UnionModel;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntDisjoint;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntID;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntGraphModelImpl
extends UnionModel
implements OntGraphModel {
    public OntGraphModelImpl(Graph graph, OntPersonality personality) {
        super(graph, (Personality<RDFNode>)((Personality)OntJenaException.notNull(personality, "Null personality")));
    }

    public void syncImports() {
        this.syncImports(this.getPersonality());
    }

    protected void syncImports(OntPersonality personality) {
        OntID id = this.getID();
        id.removeAll(OWL.imports);
        this.imports(personality).map(OntGraphModel::getID).filter(RDFNode::isURIResource).map(Resource::getURI).forEach(id::addImport);
    }

    public OntPersonality getPersonality() {
        return (OntPersonality)super.getPersonality();
    }

    @Override
    public OntID getID() {
        return this.getNodeAs(Graphs.ontologyNode(this.getBaseGraph()).orElseGet(() -> this.createResource().addProperty(RDF.type, (RDFNode)OWL.Ontology).asNode()), OntID.class);
    }

    @Override
    public OntID setID(String uri) {
        return this.getNodeAs(OntGraphModelImpl.createOntologyID(this.getBaseModel(), uri).asNode(), OntID.class);
    }

    public static Resource createOntologyID(Model model, String uri) throws OntJenaException {
        List prev = Iter.flatMap(model.listStatements(null, RDF.type, (RDFNode)OWL.Ontology), s -> s.getSubject().listProperties()).toList();
        if (prev.stream().filter(s -> OWL.imports.equals(s.getPredicate())).map(Statement::getObject).filter(RDFNode::isURIResource).map(RDFNode::asResource).map(Resource::getURI).anyMatch(u -> u.equals(uri))) {
            throw new OntJenaException("Can't create ontology: specified uri (<" + uri + ">) is present in the imports.");
        }
        model.remove(prev);
        Resource res = model.createResource(uri).addProperty(RDF.type, (RDFNode)OWL.Ontology);
        prev.forEach(s -> res.addProperty(s.getPredicate(), s.getObject()));
        return res;
    }

    @Override
    public OntGraphModelImpl addImport(OntGraphModel m) {
        if (OntJenaException.notNull(m, "Null model specified.").getID().isAnon()) {
            throw new OntJenaException("Anonymous sub models are not allowed.");
        }
        if (this.hasOntologyImport(m)) {
            throw new OntJenaException("Ontology <" + m.getID().getURI() + "> is already in imports.");
        }
        this.getGraph().addGraph(m.getGraph());
        this.getID().addImport(m.getID().getURI());
        return this;
    }

    public boolean hasOntologyImport(OntGraphModel other) {
        return this.hasOntologyImport(other.getID().getURI());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOntologyImport(String uri) {
        if (uri == null) return false;
        if (!this.imports().map(OntGraphModel::getID).map(Resource::getURI).anyMatch(uri::equals)) return false;
        return true;
    }

    @Override
    public OntGraphModelImpl removeImport(OntGraphModel m) {
        return this.removeFirst(x -> Graphs.isSameBase(x.getGraph(), m.getGraph()));
    }

    @Override
    public OntGraphModelImpl removeImport(String uri) {
        return this.removeFirst(x -> Objects.equals(uri, x.getID().getURI()));
    }

    protected OntGraphModelImpl removeFirst(Predicate<OntGraphModel> filter) {
        this.imports().filter(filter).findFirst().ifPresent(this::removeModel);
        return this;
    }

    protected void removeModel(OntGraphModel m) {
        this.getGraph().removeGraph(m.getGraph());
        this.getID().removeImport(m.getID().getURI());
    }

    @Override
    public Stream<OntGraphModel> imports() {
        return this.imports(this.getPersonality());
    }

    public Stream<OntGraphModel> imports(OntPersonality personality) {
        return this.getGraph().getUnderlying().graphs().map(g -> new OntGraphModelImpl((Graph)g, personality));
    }

    public OntGraphModelImpl getTopModel() {
        if (this.getGraph().getUnderlying().hasSubGraphs()) {
            return new OntGraphModelImpl(this.getBaseGraph(), this.getPersonality());
        }
        return this;
    }

    @Override
    public InfModel getInferenceModel(Reasoner reasoner) {
        return new InfModelImpl(OntJenaException.notNull(reasoner, "Null reasoner.").bind((Graph)this.getGraph()));
    }

    @Override
    public <O extends OntObject> Stream<O> ontObjects(Class<? extends O> type) {
        return Iter.asStream(this.listOntObjects(type));
    }

    public <O extends OntObject> ExtendedIterator<O> listOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this, type);
    }

    public <O extends OntObject> ExtendedIterator<O> listLocalOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this.getTopModel(), type);
    }

    public static <O extends OntObject> ExtendedIterator<O> listOntObjects(OntGraphModelImpl m, Class<? extends O> type) {
        return m.getPersonality().getOntImplementation(type).iterator((EnhGraph)m).mapWith(e -> (OntObject)m.getNodeAs(e.asNode(), type));
    }

    @Override
    public Stream<OntEntity> ontEntities() {
        return Iter.asStream(this.listOntEntities());
    }

    public ExtendedIterator<OntEntity> listOntEntities() {
        return Iter.flatMap(OntEntity.listEntityTypes(), this::listOntObjects);
    }

    public ExtendedIterator<OntEntity> listLocalOntEntities() {
        return Iter.flatMap(OntEntity.listEntityTypes(), this::listLocalOntObjects);
    }

    public Stream<OntEntity> ambiguousEntities(boolean withImports) {
        Set types = OntEntity.listEntityTypes().toSet();
        return this.ontEntities().filter(e -> withImports || e.isLocal()).filter(e -> types.stream().filter(view -> e.canAs((Class)view) && (withImports || ((OntEntity)e.as((Class)view)).isLocal())).count() > 1L);
    }

    @Override
    public Stream<OntIndividual> classAssertions() {
        return this.statements(null, RDF.type, null).filter(s -> s.getObject().canAs(OntCE.class)).map(OntStatement::getSubject).map(s -> this.findNodeAs(s.asNode(), OntIndividual.class)).filter(Objects::nonNull);
    }

    @Override
    public <E extends OntEntity> E getOntEntity(Class<E> type, String uri) {
        return (E)((OntEntity)this.findNodeAs(NodeFactory.createURI((String)OntJenaException.notNull(uri, "Null uri.")), type));
    }

    public <T extends OntEntity> T createOntEntity(Class<T> type, String iri) {
        try {
            return (T)((OntEntity)this.createOntObject(type, iri));
        }
        catch (OntJenaException.Creation e) {
            throw new OntJenaException(String.format("Can't add entity [%s: %s]: perhaps it's illegal punning.", type.getSimpleName(), iri), (Throwable)((Object)e));
        }
    }

    public <T extends OntObject> T createOntObject(Class<T> type, String uri) {
        Node key = Graphs.createNode(uri);
        OntObject res = (OntObject)this.getPersonality().getOntImplementation(type).create(key, (EnhGraph)this).as(type);
        this.getNodeCache().put((Object)key, (Object)res);
        return (T)res;
    }

    @Override
    public OntGraphModelImpl removeOntObject(OntObject obj) {
        obj.clearAnnotations().content().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(arg_0 -> ((OntGraphModelImpl)this).remove(arg_0));
        this.getNodeCache().remove((Object)obj.asNode());
        return this;
    }

    @Override
    public OntGraphModelImpl removeOntStatement(OntStatement statement) {
        statement.clearAnnotations();
        this.remove(statement);
        return this;
    }

    @Override
    public Stream<OntStatement> statements() {
        return Iter.asStream(this.listStatements().mapWith(OntStatement.class::cast));
    }

    @Override
    public Stream<OntStatement> statements(Resource s, Property p, RDFNode o) {
        return Iter.asStream(this.listOntStatements(s, p, o));
    }

    @Override
    public Stream<OntStatement> localStatements(Resource s, Property p, RDFNode o) {
        return Iter.asStream(this.listLocalStatements(s, p, o));
    }

    public StmtIterator listStatements(Resource s, Property p, RDFNode o) {
        return Iter.createStmtIterator((ExtendedIterator<Triple>)this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)), this::asStatement);
    }

    public ExtendedIterator<OntStatement> listOntStatements(Resource s, Property p, RDFNode o) {
        return WrappedIterator.create((Iterator)this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public ExtendedIterator<OntStatement> listLocalStatements(Resource s, Property p, RDFNode o) {
        return WrappedIterator.create((Iterator)this.getBaseGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public OntStatementImpl createStatement(Resource s, Property p, RDFNode o) {
        return OntStatementImpl.createOntStatementImpl(s, p, o, this);
    }

    @Override
    public OntStatement asStatement(Triple triple) {
        return OntStatementImpl.createOntStatementImpl(triple, this);
    }

    @Override
    public OntDisjoint.Classes createDisjointClasses(Collection<OntCE> classes) {
        return OntDisjointImpl.createDisjointClasses(this, classes.stream());
    }

    @Override
    public OntDisjoint.Individuals createDifferentIndividuals(Collection<OntIndividual> individuals) {
        return OntDisjointImpl.createDifferentIndividuals(this, individuals.stream());
    }

    @Override
    public OntDisjoint.ObjectProperties createDisjointObjectProperties(Collection<OntOPE> properties) {
        return OntDisjointImpl.createDisjointObjectProperties(this, properties.stream());
    }

    @Override
    public OntDisjoint.DataProperties createDisjointDataProperties(Collection<OntNDP> properties) {
        return OntDisjointImpl.createDisjointDataProperties(this, properties.stream());
    }

    public <T extends OntFR> T createFacetRestriction(Class<T> view, Literal literal) {
        return OntFRImpl.create(this, view, literal);
    }

    @Override
    public OntDR.OneOf createOneOfDataRange(Collection<Literal> values) {
        return OntDRImpl.createOneOf(this, values.stream());
    }

    @Override
    public OntDR.Restriction createRestrictionDataRange(OntDT datatype, Collection<OntFR> values) {
        return OntDRImpl.createRestriction(this, datatype, values.stream());
    }

    @Override
    public OntDR.ComplementOf createComplementOfDataRange(OntDR other) {
        return OntDRImpl.createComplementOf(this, other);
    }

    @Override
    public OntDR.UnionOf createUnionOfDataRange(Collection<OntDR> values) {
        return OntDRImpl.createUnionOf(this, values.stream());
    }

    @Override
    public OntDR.IntersectionOf createIntersectionOfDataRange(Collection<OntDR> values) {
        return OntDRImpl.createIntersectionOf(this, values.stream());
    }

    @Override
    public OntCE.ObjectSomeValuesFrom createObjectSomeValuesFrom(OntOPE onProperty, OntCE other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.ObjectSomeValuesFrom.class, onProperty, (RDFNode)other, OWL.someValuesFrom);
    }

    @Override
    public OntCE.DataSomeValuesFrom createDataSomeValuesFrom(OntNDP onProperty, OntDR other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.DataSomeValuesFrom.class, onProperty, (RDFNode)other, OWL.someValuesFrom);
    }

    @Override
    public OntCE.ObjectAllValuesFrom createObjectAllValuesFrom(OntOPE onProperty, OntCE other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.ObjectAllValuesFrom.class, onProperty, (RDFNode)other, OWL.allValuesFrom);
    }

    @Override
    public OntCE.DataAllValuesFrom createDataAllValuesFrom(OntNDP onProperty, OntDR other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.DataAllValuesFrom.class, onProperty, (RDFNode)other, OWL.allValuesFrom);
    }

    @Override
    public OntCE.ObjectHasValue createObjectHasValue(OntOPE onProperty, OntIndividual other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.ObjectHasValue.class, onProperty, (RDFNode)other, OWL.hasValue);
    }

    @Override
    public OntCE.DataHasValue createDataHasValue(OntNDP onProperty, Literal other) {
        return OntCEImpl.createComponentRestrictionCE(this, OntCE.DataHasValue.class, onProperty, (RDFNode)other, OWL.hasValue);
    }

    @Override
    public OntCE.ObjectMinCardinality createObjectMinCardinality(OntOPE onProperty, int cardinality, OntCE onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.ObjectMinCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.DataMinCardinality createDataMinCardinality(OntNDP onProperty, int cardinality, OntDR onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.DataMinCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.ObjectMaxCardinality createObjectMaxCardinality(OntOPE onProperty, int cardinality, OntCE onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.ObjectMaxCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.DataMaxCardinality createDataMaxCardinality(OntNDP onProperty, int cardinality, OntDR onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.DataMaxCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.ObjectCardinality createObjectCardinality(OntOPE onProperty, int cardinality, OntCE onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.ObjectCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.DataCardinality createDataCardinality(OntNDP onProperty, int cardinality, OntDR onObject) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntCE.DataCardinality.class, onProperty, cardinality, onObject);
    }

    @Override
    public OntCE.UnionOf createUnionOf(Collection<OntCE> classes) {
        return OntCEImpl.createComponentsCE(this, OntCE.UnionOf.class, OWL.unionOf, classes.iterator());
    }

    @Override
    public OntCE.IntersectionOf createIntersectionOf(Collection<OntCE> classes) {
        return OntCEImpl.createComponentsCE(this, OntCE.IntersectionOf.class, OWL.intersectionOf, classes.iterator());
    }

    @Override
    public OntCE.OneOf createOneOf(Collection<OntIndividual> individuals) {
        return OntCEImpl.createComponentsCE(this, OntCE.OneOf.class, OWL.oneOf, individuals.iterator());
    }

    @Override
    public OntCE.HasSelf createHasSelf(OntOPE onProperty) {
        return OntCEImpl.createHasSelf(this, onProperty);
    }

    @Override
    public OntCE.NaryDataAllValuesFrom createDataAllValuesFrom(Collection<OntNDP> onProperties, OntDR other) {
        throw new OntJenaException.Unsupported("TODO: " + OntCE.NaryDataAllValuesFrom.class);
    }

    @Override
    public OntCE.NaryDataSomeValuesFrom createDataSomeValuesFrom(Collection<OntNDP> onProperties, OntDR other) {
        throw new OntJenaException.Unsupported("TODO: " + OntCE.NaryDataSomeValuesFrom.class);
    }

    @Override
    public OntCE.ComplementOf createComplementOf(OntCE other) {
        return OntCEImpl.createComplementOf(this, other);
    }

    @Override
    public OntSWRL.Variable createSWRLVariable(String uri) {
        return OntSWRLImpl.createVariable(this, uri);
    }

    @Override
    public OntSWRL.Atom.BuiltIn createBuiltInSWRLAtom(Resource predicate, Collection<OntSWRL.DArg> arguments) {
        return OntSWRLImpl.createBuiltInAtom(this, predicate, arguments);
    }

    @Override
    public OntSWRL.Atom.OntClass createClassSWRLAtom(OntCE clazz, OntSWRL.IArg arg) {
        return OntSWRLImpl.createClassAtom(this, clazz, arg);
    }

    @Override
    public OntSWRL.Atom.DataRange createDataRangeSWRLAtom(OntDR range, OntSWRL.DArg arg) {
        return OntSWRLImpl.createDataRangeAtom(this, range, arg);
    }

    @Override
    public OntSWRL.Atom.DataProperty createDataPropertySWRLAtom(OntNDP dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        return OntSWRLImpl.createDataPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.ObjectProperty createObjectPropertySWRLAtom(OntOPE dataProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createObjectPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.DifferentIndividuals createDifferentIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createDifferentIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.SameIndividuals createSameIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createSameIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Imp createSWRLImp(Collection<OntSWRL.Atom> head, Collection<OntSWRL.Atom> body) {
        return OntSWRLImpl.createImp(this, head, body);
    }

    public PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    @Override
    public OntGraphModelImpl setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public OntGraphModelImpl removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public OntGraphModelImpl clearNsPrefixMap() {
        this.getPrefixMapping().clearNsPrefixMap();
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(Map<String, String> map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    @Override
    public OntGraphModelImpl withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    public String toString() {
        return String.format("OntGraphModel{%s}", this.getID());
    }
}

