/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntID;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class OntIDImpl
extends OntObjectImpl
implements OntID {
    public static OntObjectFactory idFactory = new CommonOntObjectFactory(new OntMaker.Default(OntIDImpl.class), new OntFinder.ByType(OWL.Ontology), new OntFilter.HasType(OWL.Ontology), new OntFilter[0]);

    public OntIDImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public String getVersionIRI() {
        Statement st = this.getProperty(OWL.versionIRI);
        if (st == null || !st.getObject().isURIResource()) {
            return null;
        }
        return st.getObject().asResource().getURI();
    }

    @Override
    public OntIDImpl setVersionIRI(String uri) {
        this.removeAll(OWL.versionIRI);
        if (uri != null) {
            this.addProperty(OWL.versionIRI, (RDFNode)this.getModel().createResource(uri));
        }
        return this;
    }

    @Override
    public OntIDImpl addImport(String uri) throws OntApiException {
        if (OntJenaException.notNull(uri, "Null uri specified.").equals(this.getURI())) {
            throw new OntJenaException("Can't import itself: " + uri);
        }
        this.addImportResource(this.getModel().createResource(uri));
        return this;
    }

    @Override
    public OntIDImpl removeImport(String uri) {
        this.removeImportResource(this.getModel().createResource(uri));
        return this;
    }

    @Override
    public Stream<String> imports() {
        return this.importResources().map(Resource::getURI);
    }

    public Stream<Resource> importResources() {
        return Iter.asStream(this.listProperties(OWL.imports).mapWith(Statement::getObject).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource));
    }

    public void addImportResource(Resource uri) {
        this.addProperty(OWL.imports, (RDFNode)uri);
    }

    public void removeImportResource(Resource uri) {
        this.remove(OWL.imports, (RDFNode)uri);
    }

    @Override
    public String toString() {
        String iri = this.asNode().toString();
        String ver = this.getVersionIRI();
        if (ver != null) {
            return iri + "(" + ver + ")";
        }
        return iri;
    }
}

