/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntIndividualImpl
extends OntObjectImpl
implements OntIndividual {
    public static final OntFilter ANONYMOUS_FILTER = OntIndividualImpl::testAnonymousIndividual;
    public static final Set<Node> ALLOWED_IN_SUBJECT_PREDICATES = Stream.concat(Entities.BUILTIN.properties().stream(), Stream.of(OWL.sameAs, OWL.differentFrom)).map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    public static final Set<Node> BUILT_IN_SUBJECT_PREDICATE_SET = Entities.BUILTIN.reservedProperties().stream().map(FrontsNode::asNode).filter(n -> !ALLOWED_IN_SUBJECT_PREDICATES.contains(n)).collect(Iter.toUnmodifiableSet());
    public static final Set<Node> ALLOWED_IN_OBJECT_PREDICATES = Stream.concat(Entities.BUILTIN.properties().stream(), Stream.of(OWL.sameAs, OWL.differentFrom, OWL.sourceIndividual, OWL.hasValue, RDF.first)).map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    public static final Set<Node> BUILT_IN_OBJECT_PREDICATE_SET = Entities.BUILTIN.reservedProperties().stream().map(FrontsNode::asNode).filter(n -> !ALLOWED_IN_OBJECT_PREDICATES.contains(n)).collect(Iter.toUnmodifiableSet());
    public static OntFinder FINDER = OntFinder.ANY_SUBJECT_AND_OBJECT;
    public static OntObjectFactory anonymousIndividualFactory = new CommonOntObjectFactory(new OntMaker.Default(AnonymousImpl.class), FINDER, ANONYMOUS_FILTER, new OntFilter[0]);
    public static Configurable<OntObjectFactory> abstractIndividualFactory = OntIndividualImpl.buildMultiFactory(FINDER, null, Entities.INDIVIDUAL, anonymousIndividualFactory);

    public OntIndividualImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnonymousIndividual(Node node, EnhGraph eg) {
        if (!node.isBlank()) {
            return false;
        }
        boolean hasType = false;
        try (ExtendedIterator types = eg.asGraph().find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                if (OntObjectImpl.canAs(OntCE.class, (Node)types.next(), eg)) {
                    boolean bl = true;
                    return bl;
                }
                hasType = true;
            }
        }
        if (hasType) {
            return false;
        }
        try (ExtendedIterator bySubject = eg.asGraph().find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate);){
            while (bySubject.hasNext()) {
                if (!BUILT_IN_SUBJECT_PREDICATE_SET.contains(bySubject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        try (ExtendedIterator byObject = eg.asGraph().find(Node.ANY, Node.ANY, node).mapWith(Triple::getPredicate);){
            while (byObject.hasNext()) {
                if (!BUILT_IN_OBJECT_PREDICATE_SET.contains(byObject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(RDFNode node) {
        if (OntJenaException.notNull(node, "Null node.").canAs(OntIndividual.Anonymous.class)) {
            return (OntIndividual.Anonymous)node.as(OntIndividual.Anonymous.class);
        }
        if (node.isAnon()) {
            return new AnonymousImpl(node.asNode(), (EnhGraph)node.getModel());
        }
        throw new OntJenaException.Conversion(node + " could not be " + OntIndividual.Anonymous.class);
    }

    @Override
    public OntStatement attachClass(OntCE clazz) {
        return this.addRDFType(clazz);
    }

    @Override
    public void detachClass(OntCE clazz) {
        this.removeRDFType(clazz);
    }

    public static class AnonymousImpl
    extends OntIndividualImpl
    implements OntIndividual.Anonymous {
        public AnonymousImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.empty();
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntIndividual.Anonymous.class;
        }

        @Override
        public void detachClass(OntCE clazz) {
            if (this.classes().allMatch(clazz::equals)) {
                throw new OntJenaException("Can't detach class " + clazz + ": it is a single for individual " + this);
            }
            super.detachClass(clazz);
        }
    }

    public static class NamedImpl
    extends OntIndividualImpl
    implements OntIndividual.Named {
        public NamedImpl(Node n, EnhGraph m) {
            super(OntObjectImpl.checkNamed(n), m);
        }

        @Override
        public boolean isBuiltIn() {
            return false;
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NamedImpl.getRequiredRootStatement(this, OWL.NamedIndividual);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntIndividual.Named.class;
        }
    }
}

