/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntNPAImpl;
import ru.avicomp.ontapi.jena.impl.OntPEImpl;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntNPA;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public abstract class OntOPEImpl
extends OntPEImpl
implements OntOPE {
    public OntOPEImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public OntNPA.ObjectAssertion addNegativeAssertion(OntIndividual source, OntIndividual target) {
        return OntNPAImpl.create(this.getModel(), source, this, target);
    }

    @Override
    public void removeSuperPropertyOf() {
        this.clearAll(OWL.propertyChainAxiom);
    }

    @Override
    public OntList<OntOPE> createPropertyChain(Collection<OntOPE> properties) {
        return OntListImpl.create(this.getModel(), this, OWL.propertyChainAxiom, OntOPE.class, properties.iterator());
    }

    @Override
    public Stream<OntList<OntOPE>> listPropertyChains() {
        return OntListImpl.stream(this.getModel(), this, OWL.propertyChainAxiom, OntOPE.class);
    }

    @Override
    public void removePropertyChain(RDFNode rdfList) throws OntJenaException.IllegalArgument {
        this.remove(OWL.propertyChainAxiom, (RDFNode)((OntList)this.findPropertyChain(rdfList).orElseThrow(() -> new OntJenaException.IllegalArgument("Can't find list " + rdfList))).clearAnnotations().clear());
    }

    @Override
    public void setFunctional(boolean functional) {
        this.changeRDFType(OWL.FunctionalProperty, functional);
    }

    @Override
    public void setInverseFunctional(boolean inverseFunctional) {
        this.changeRDFType(OWL.InverseFunctionalProperty, inverseFunctional);
    }

    @Override
    public void setAsymmetric(boolean asymmetric) {
        this.changeRDFType(OWL.AsymmetricProperty, asymmetric);
    }

    @Override
    public void setTransitive(boolean transitive) {
        this.changeRDFType(OWL.TransitiveProperty, transitive);
    }

    @Override
    public void setReflexive(boolean reflexive) {
        this.changeRDFType(OWL.ReflexiveProperty, reflexive);
    }

    @Override
    public void setIrreflexive(boolean irreflexive) {
        this.changeRDFType(OWL.IrreflexiveProperty, irreflexive);
    }

    @Override
    public void setSymmetric(boolean symmetric) {
        this.changeRDFType(OWL.SymmetricProperty, symmetric);
    }

    public static class InversePropertyImpl
    extends OntOPEImpl
    implements OntOPE.Inverse {
        public InversePropertyImpl(Node n, EnhGraph g) {
            super(n, g);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.of(this.getModel().createStatement(this, OWL.inverseOf, (RDFNode)this.getDirect()).asRootStatement());
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntOPE.Inverse.class;
        }

        @Override
        public OntNOP getDirect() {
            OntGraphModelImpl m = this.getModel();
            List res = Iter.distinct(this.listObjects(OWL.inverseOf, Resource.class).filterKeep(RDFNode::isURIResource)).toList();
            if (res.size() != 1) {
                throw new OntJenaException.IllegalState("Expected one and only one owl:inverseOf statement, but found: [" + this + " owl:inverseOf " + res + "]");
            }
            return m.getNodeAs(((Resource)res.get(0)).asNode(), OntNOP.class);
        }

        @Override
        public Property asProperty() {
            return this.getDirect().asProperty();
        }
    }

    public static class NamedPropertyImpl
    extends OntOPEImpl
    implements OntNOP {
        public NamedPropertyImpl(Node n, EnhGraph g) {
            super(n, g);
        }

        @Override
        public OntOPE.Inverse createInverse() {
            OntGraphModelImpl m = this.getModel();
            List nodes = m.localStatements(null, OWL.inverseOf, (RDFNode)this).map(OntStatement::getSubject).filter(RDFNode::isAnon).map(FrontsNode::asNode).distinct().collect(Collectors.toList());
            if (nodes.size() > 1) {
                throw new OntJenaException.IllegalState("More than one inverse-of object properties found: [" + nodes + " owl:inverseOf " + this + "]");
            }
            Node n = nodes.isEmpty() ? m.createResource().addProperty(OWL.inverseOf, (RDFNode)this).asNode() : (Node)nodes.get(0);
            return m.getNodeAs(n, OntOPE.Inverse.class);
        }

        @Override
        public boolean isBuiltIn() {
            return Entities.OBJECT_PROPERTY.builtInURIs().contains(this);
        }

        public Class<OntNOP> getActualClass() {
            return OntNOP.class;
        }

        public Property inModel(Model m) {
            return this.getModel() == m ? this : m.createProperty(this.getURI());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NamedPropertyImpl.getOptionalRootStatement(this, OWL.ObjectProperty);
        }
    }
}

