/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.vocabulary.SWRL;

public class OntSWRLImpl
extends OntObjectImpl
implements OntSWRL {
    private static final OntFilter VAR_SWRL_FILTER = OntFilter.URI.and(new OntFilter.HasType(SWRL.Variable));
    public static OntObjectFactory variableSWRLFactory = new CommonOntObjectFactory(new OntMaker.WithType(VariableImpl.class, SWRL.Variable), new OntFinder.ByType(SWRL.Variable), VAR_SWRL_FILTER, new OntFilter[0]);
    public static OntObjectFactory dArgSWRLFactory = new CommonOntObjectFactory(new OntMaker.Default(DArgImpl.class), OntFinder.ANY_SUBJECT_AND_OBJECT, VAR_SWRL_FILTER.or((arg_0, arg_1) -> ((Implementation)LiteralImpl.factory).canWrap(arg_0, arg_1)), new OntFilter[0]);
    public static OntObjectFactory iArgSWRLFactory = new CommonOntObjectFactory(new OntMaker.Default(IArgImpl.class), OntFinder.ANY_SUBJECT, VAR_SWRL_FILTER.or((n, g) -> OntObjectImpl.canAs(OntIndividual.class, n, g)), new OntFilter[0]);
    public static OntObjectFactory abstractArgSWRLFactory = new MultiOntObjectFactory(OntFinder.ANY_SUBJECT_AND_OBJECT, null, dArgSWRLFactory, iArgSWRLFactory);
    public static OntObjectFactory builtInAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(BuiltInAtomImpl.class, SWRL.BuiltinAtom);
    public static OntObjectFactory classAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(OntClassAtomImpl.class, SWRL.ClassAtom);
    public static OntObjectFactory dataRangeAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DataRangeAtomImpl.class, SWRL.DataRangeAtom);
    public static OntObjectFactory dataValuedAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DataPropertyAtomImpl.class, SWRL.DatavaluedPropertyAtom);
    public static OntObjectFactory individualAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(ObjectPropertyAtomImpl.class, SWRL.IndividualPropertyAtom);
    public static OntObjectFactory differentIndividualsAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DifferentIndividualsAtomImpl.class, SWRL.DifferentIndividualsAtom);
    public static OntObjectFactory sameIndividualsAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(SameIndividualsAtomImpl.class, SWRL.SameIndividualAtom);
    public static OntObjectFactory abstractAtomSWRLFactory = new MultiOntObjectFactory(OntFinder.TYPED, null, builtInAtomSWRLFactory, classAtomSWRLFactory, dataRangeAtomSWRLFactory, dataValuedAtomSWRLFactory, individualAtomSWRLFactory, differentIndividualsAtomSWRLFactory, sameIndividualsAtomSWRLFactory);
    public static OntObjectFactory impSWRLFactory = new CommonOntObjectFactory(new OntMaker.Default(ImpImpl.class), new OntFinder.ByType(SWRL.Imp), new OntFilter.HasType(SWRL.Imp), new OntFilter[0]);
    public static OntObjectFactory abstractSWRLFactory = new MultiOntObjectFactory(OntFinder.TYPED, null, abstractAtomSWRLFactory, variableSWRLFactory, impSWRLFactory);

    private static OntObjectFactory makeAtomFactory(Class<? extends AtomImpl> view, Resource type) {
        return new CommonOntObjectFactory(new OntMaker.Default(view), new OntFinder.ByType(type), OntFilter.BLANK.and(new OntFilter.HasType(type)), new OntFilter[0]);
    }

    public OntSWRLImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntSWRL.Variable createVariable(OntGraphModelImpl model, String uri) {
        return model.createOntObject(OntSWRL.Variable.class, uri);
    }

    public static OntSWRL.Atom.BuiltIn createBuiltInAtom(OntGraphModelImpl model, Resource predicate, Collection<OntSWRL.DArg> arguments) {
        Property property = OntSWRLImpl.createBuiltinProperty(model, predicate);
        OntObject res = (OntObject)model.createResource(SWRL.BuiltinAtom).addProperty(SWRL.builtin, (RDFNode)property).as(OntObject.class);
        OntListImpl.create(model, res, SWRL.arguments, null, OntSWRL.DArg.class, arguments.iterator());
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.BuiltIn.class);
    }

    public static Property createBuiltinProperty(OntGraphModelImpl model, Resource predicate) {
        return (Property)OntSWRLImpl.checkNamed(predicate).inModel((Model)model).addProperty(RDF.type, (RDFNode)SWRL.Builtin).as(Property.class);
    }

    public static OntSWRL.Atom.OntClass createClassAtom(OntGraphModelImpl model, OntCE clazz, OntSWRL.IArg arg) {
        OntJenaException.notNull(clazz, "Null class");
        OntJenaException.notNull(arg, "Null i-arg");
        Resource res = model.createResource(SWRL.ClassAtom).addProperty(SWRL.classPredicate, (RDFNode)clazz).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.OntClass.class);
    }

    public static OntSWRL.Atom.DataRange createDataRangeAtom(OntGraphModelImpl model, OntDR range, OntSWRL.DArg arg) {
        OntJenaException.notNull(range, "Null data range");
        OntJenaException.notNull(arg, "Null d-arg");
        Resource res = model.createResource(SWRL.DataRangeAtom).addProperty(SWRL.dataRange, (RDFNode)range).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.DataRange.class);
    }

    public static OntSWRL.Atom.DataProperty createDataPropertyAtom(OntGraphModelImpl model, OntNDP dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        OntJenaException.notNull(dataProperty, "Null data property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second d-arg");
        Resource res = model.createResource(SWRL.DatavaluedPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)dataProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.DataProperty.class);
    }

    public static OntSWRL.Atom.ObjectProperty createObjectPropertyAtom(OntGraphModelImpl model, OntOPE objectProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(objectProperty, "Null object property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.IndividualPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)objectProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.ObjectProperty.class);
    }

    public static OntSWRL.Atom.DifferentIndividuals createDifferentIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.DifferentIndividualsAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.DifferentIndividuals.class);
    }

    public static OntSWRL.Atom.SameIndividuals createSameIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.SameIndividualAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.SameIndividuals.class);
    }

    public static OntSWRL.Imp createImp(OntGraphModelImpl model, Collection<OntSWRL.Atom> head, Collection<OntSWRL.Atom> body) {
        OntJenaException.notNull(head, "Null head");
        OntJenaException.notNull(body, "Null body");
        OntObject res = (OntObject)model.createResource(SWRL.Imp).as(OntObject.class);
        OntListImpl.create(model, res, SWRL.head, SWRL.AtomList, OntSWRL.Atom.class, head.iterator());
        OntListImpl.create(model, res, SWRL.body, SWRL.AtomList, OntSWRL.Atom.class, body.iterator());
        return model.getNodeAs(res.asNode(), OntSWRL.Imp.class);
    }

    public static class ImpImpl
    extends OntSWRLImpl
    implements OntSWRL.Imp {
        public ImpImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntList<OntSWRL.Atom> getHeadList() {
            return this.getList(SWRL.head);
        }

        @Override
        public OntList<OntSWRL.Atom> getBodyList() {
            return this.getList(SWRL.body);
        }

        protected OntList<OntSWRL.Atom> getList(Property predicate) {
            return OntListImpl.asOntList(this.getRequiredObject(predicate, RDFList.class), this.getModel(), this, predicate, SWRL.AtomList, OntSWRL.Atom.class);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.of(super.spec(), this.getHeadList().content(), this.getBodyList().content()).flatMap(Function.identity());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return ImpImpl.getRequiredRootStatement(this, SWRL.Imp);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Imp.class;
        }
    }

    public static class SameIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.SameIndividuals {
        public SameIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL.sameAs);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.SameIndividualAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.SameIndividuals.class;
        }
    }

    public static class DifferentIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.DifferentIndividuals {
        public DifferentIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL.differentFrom);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DifferentIndividualsAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.DifferentIndividuals.class;
        }
    }

    public static abstract class IndividualsAtomImpl
    extends BinaryImpl<Property, OntSWRL.IArg, OntSWRL.IArg> {
        IndividualsAtomImpl(Node n, EnhGraph m, Property predicate) {
            super(n, m, predicate, Property.class, OntSWRL.IArg.class, OntSWRL.IArg.class);
        }

        @Override
        public Property getPredicate() {
            return this.predicate;
        }
    }

    public static class ObjectPropertyAtomImpl
    extends BinaryImpl<OntOPE, OntSWRL.IArg, OntSWRL.IArg>
    implements OntSWRL.Atom.ObjectProperty {
        public ObjectPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.propertyPredicate, OntOPE.class, OntSWRL.IArg.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.IndividualPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.ObjectProperty.class;
        }
    }

    public static class DataPropertyAtomImpl
    extends BinaryImpl<OntNDP, OntSWRL.IArg, OntSWRL.DArg>
    implements OntSWRL.Atom.DataProperty {
        public DataPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.propertyPredicate, OntNDP.class, OntSWRL.IArg.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DatavaluedPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.DataProperty.class;
        }
    }

    public static abstract class BinaryImpl<O extends Resource, F extends OntSWRL.Arg, S extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Binary<O, F, S> {
        protected final Property predicate;
        private final Class<O> objectType;
        private final Class<F> firstArgType;
        private final Class<S> secondArgType;

        BinaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<F> firstArgType, Class<S> secondArgType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.firstArgType = firstArgType;
            this.secondArgType = secondArgType;
        }

        @Override
        public O getPredicate() {
            return (O)((Resource)this.getRequiredObject(this.predicate, this.objectType));
        }

        @Override
        public F getFirstArg() {
            return (F)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.firstArgType));
        }

        @Override
        public S getSecondArg() {
            return (S)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument2, this.secondArgType));
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(this.predicate, SWRL.argument1, SWRL.argument2));
        }
    }

    public static class DataRangeAtomImpl
    extends UnaryImpl<OntDR, OntSWRL.DArg>
    implements OntSWRL.Atom.DataRange {
        public DataRangeAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.dataRange, OntDR.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DataRangeAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.DataRange.class;
        }
    }

    public static class OntClassAtomImpl
    extends UnaryImpl<OntCE, OntSWRL.IArg>
    implements OntSWRL.Atom.OntClass {
        public OntClassAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.classPredicate, OntCE.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.ClassAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.OntClass.class;
        }
    }

    public static abstract class UnaryImpl<O extends OntObject, A extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Unary<O, A> {
        private final Property predicate;
        private final Class<O> objectView;
        private final Class<A> argView;

        UnaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<A> argView) {
            super(n, m);
            this.predicate = predicate;
            this.objectView = objectView;
            this.argView = argView;
        }

        @Override
        public A getArg() {
            return (A)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.argView));
        }

        @Override
        public O getPredicate() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectView));
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(this.predicate, SWRL.argument1));
        }
    }

    public static class BuiltInAtomImpl
    extends AtomImpl<Resource>
    implements OntSWRL.Atom.BuiltIn {
        public BuiltInAtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.BuiltinAtom;
        }

        @Override
        public Resource getPredicate() {
            return this.getRequiredObject(SWRL.builtin, Resource.class);
        }

        @Override
        public OntList<OntSWRL.DArg> getArgList() {
            return OntListImpl.asOntList(this.getRequiredObject(SWRL.arguments, RDFList.class), this.getModel(), this, SWRL.arguments, null, OntSWRL.DArg.class);
        }

        public Stream<OntStatement> predicateStatements() {
            OntStatement b = this.getRequiredProperty(SWRL.builtin);
            OntStatement a = b.getSubject().statement(RDF.type, (RDFNode)SWRL.Builtin).orElseThrow(() -> new OntJenaException.IllegalState("Can't find rdf:type SWRL:Builtin for " + b));
            return Stream.of(a, b);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.of(super.spec(), this.predicateStatements(), this.getArgList().content()).flatMap(Function.identity());
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.BuiltIn.class;
        }
    }

    public static abstract class AtomImpl<P extends RDFNode>
    extends OntSWRLImpl
    implements OntSWRL.Atom<P> {
        public AtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return AtomImpl.getRequiredRootStatement(this, this.getResourceType());
        }

        public abstract Resource getResourceType();
    }

    public static class IArgImpl
    extends OntObjectImpl
    implements OntSWRL.IArg {
        public IArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.IArg.class;
        }
    }

    public static class DArgImpl
    extends OntObjectImpl
    implements OntSWRL.DArg {
        public DArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.DArg.class;
        }
    }

    public static class VariableImpl
    extends OntSWRLImpl
    implements OntSWRL.Variable {
        public VariableImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Variable.class;
        }
    }
}

