/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.shared.JenaException;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.UnionGraph;

public class UnionModel
extends ModelCom {
    protected ThreadLocal<Set<Node>> visited = ThreadLocal.withInitial(HashSet::new);

    public UnionModel(Graph base, Personality<RDFNode> personality) {
        super((Graph)(base instanceof UnionGraph ? base : new UnionGraph(base)), personality);
    }

    protected Cache<Node, RDFNode> getNodeCache() {
        return this.enhNodes;
    }

    public UnionGraph getGraph() {
        return (UnionGraph)super.getGraph();
    }

    public Graph getBaseGraph() {
        return this.getGraph().getBaseGraph();
    }

    public Model getBaseModel() {
        return new ModelCom(this.getBaseGraph());
    }

    public Model write(Writer writer) {
        return this.getBaseModel().write(writer);
    }

    public Model write(Writer writer, String lang) {
        return this.getBaseModel().write(writer, lang);
    }

    public Model write(Writer writer, String lang, String base) {
        return this.getBaseModel().write(writer, lang, base);
    }

    public Model write(OutputStream out) {
        return this.getBaseModel().write(out);
    }

    public Model write(OutputStream out, String lang) {
        return this.getBaseModel().write(out, lang);
    }

    public Model write(OutputStream out, String lang, String base) {
        return this.getBaseModel().write(out, lang, base);
    }

    public boolean isLocal(Statement stm) {
        return this.isLocal(OntJenaException.notNull(stm, "Null statement.").getSubject(), stm.getPredicate(), stm.getObject());
    }

    public boolean isLocal(Resource s, Property p, RDFNode o) {
        return this.getBaseGraph().contains(s.asNode(), p.asNode(), o.asNode());
    }

    public <N extends RDFNode> N findNodeAs(Node node, Class<N> type) {
        try {
            return this.getNodeAs(node, type);
        }
        catch (OntJenaException.Conversion ignore) {
            return null;
        }
    }

    public <N extends RDFNode> N getNodeAs(Node node, Class<N> view) {
        try {
            return this.getNodeAsInternal(node, view);
        }
        catch (ConversionException e) {
            throw new OntJenaException.Conversion(String.format("Failed to convert node <%s> to <%s>", node, view), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> view) {
        Set<Node> nodes = this.visited.get();
        try {
            if (nodes.contains(node)) {
                throw new OntJenaException.Recursion("Can't cast to " + view.getSimpleName() + ": graph contains a recursion for node <" + node + ">");
            }
            nodes.add(node);
            N n = this.getNodeAsInternal(node, view);
            return n;
        }
        catch (OntJenaException.Recursion r) {
            throw r;
        }
        catch (JenaException e) {
            N n = null;
            return n;
        }
        finally {
            nodes.remove(node);
        }
    }

    protected <N extends RDFNode> N getNodeAsInternal(Node node, Class<N> view) {
        return (N)super.getNodeAs(OntJenaException.notNull(node, "Null node"), OntJenaException.notNull(view, "Null class view."));
    }
}

