/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl.conf;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.util.iterator.ExtendedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;

public class CommonOntObjectFactory
extends OntObjectFactory {
    private final OntMaker maker;
    private final OntFinder finder;
    private final OntFilter filter;

    public CommonOntObjectFactory(OntMaker maker, OntFinder finder, OntFilter primary, OntFilter ... additional) {
        this.maker = OntJenaException.notNull(maker, "Null maker.");
        this.finder = OntJenaException.notNull(finder, "Null finder.");
        this.filter = OntJenaException.notNull(primary, "Null primary filter.").accumulate(additional);
    }

    public OntMaker getMaker() {
        return this.maker;
    }

    public OntFinder getFinder() {
        return this.finder;
    }

    public OntFilter getFilter() {
        return this.filter;
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new ConversionException(String.format("Can't wrap node %s to %s", node, this.maker.getImpl()));
        }
        return this.doWrap(node, eg);
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return this.filter.test(node, eg);
    }

    @Override
    public EnhNode create(Node node, EnhGraph eg) {
        if (!this.canCreate(node, eg)) {
            throw new OntJenaException.Creation(String.format("Can't modify graph for %s (%s)", node, this.maker.getImpl()));
        }
        this.maker.make(node, eg);
        return this.doWrap(node, eg);
    }

    @Override
    public boolean canCreate(Node node, EnhGraph eg) {
        return this.maker.getTester().test(node, eg);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        return this.finder.restrict(this.filter).iterator(eg).mapWith(n -> this.maker.instance((Node)n, eg));
    }

    @Override
    protected EnhNode doWrap(Node node, EnhGraph eg) {
        return this.maker.instance(node, eg);
    }
}

