/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFNode;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntStatement;

public interface OntClass
extends OntEntity,
OntCE {
    public OntList<OntCE> createDisjointUnion(Collection<OntCE> var1);

    public Stream<OntList<OntCE>> listDisjointUnions();

    public void removeDisjointUnion(RDFNode var1);

    @Deprecated
    public void removeDisjointUnionOf();

    default public void clearDisjointUnions() {
        this.listDisjointUnions().collect(Collectors.toSet()).forEach(this::removeDisjointUnion);
    }

    default public Optional<OntList<OntCE>> findDisjointUnion(RDFNode list) {
        return this.listDisjointUnions().filter(r -> Objects.equals(r, list)).findFirst();
    }

    default public OntStatement addDisjointUnionOf(OntCE ... classes) {
        return this.createDisjointUnion(Arrays.stream(classes).collect(Collectors.toCollection(LinkedHashSet::new))).getRoot();
    }

    @Deprecated
    default public Stream<OntCE> disjointUnionOf() {
        return this.listDisjointUnions().flatMap(OntList::members).distinct();
    }

    @Deprecated
    default public OntStatement addDisjointUnionOf(Collection<OntCE> classes) {
        return this.createDisjointUnion(classes).getRoot();
    }
}

