/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntDisjoint;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntID;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public interface OntGraphModel
extends Model {
    public Graph getBaseGraph();

    public Model getBaseModel();

    public InfModel getInferenceModel(Reasoner var1);

    public OntID getID();

    public OntID setID(String var1);

    public OntGraphModel addImport(OntGraphModel var1) throws OntJenaException;

    public OntGraphModel removeImport(OntGraphModel var1);

    public OntGraphModelImpl removeImport(String var1);

    public Stream<OntGraphModel> imports();

    public <O extends OntObject> Stream<O> ontObjects(Class<? extends O> var1);

    public Stream<OntEntity> ontEntities();

    public Stream<OntIndividual> classAssertions();

    public <E extends OntEntity> E getOntEntity(Class<E> var1, String var2);

    public Stream<OntStatement> statements();

    public Stream<OntStatement> statements(Resource var1, Property var2, RDFNode var3);

    public Stream<OntStatement> localStatements(Resource var1, Property var2, RDFNode var3);

    public OntStatement asStatement(Triple var1);

    public boolean isLocal(Statement var1);

    public OntGraphModel removeOntObject(OntObject var1);

    public OntGraphModel removeOntStatement(OntStatement var1);

    public <E extends OntEntity> E createOntEntity(Class<E> var1, String var2);

    public <F extends OntFR> F createFacetRestriction(Class<F> var1, Literal var2);

    public OntDisjoint.Classes createDisjointClasses(Collection<OntCE> var1);

    public OntDisjoint.Individuals createDifferentIndividuals(Collection<OntIndividual> var1);

    public OntDisjoint.ObjectProperties createDisjointObjectProperties(Collection<OntOPE> var1);

    public OntDisjoint.DataProperties createDisjointDataProperties(Collection<OntNDP> var1);

    public OntDR.OneOf createOneOfDataRange(Collection<Literal> var1);

    public OntDR.Restriction createRestrictionDataRange(OntDT var1, Collection<OntFR> var2);

    public OntDR.ComplementOf createComplementOfDataRange(OntDR var1);

    public OntDR.UnionOf createUnionOfDataRange(Collection<OntDR> var1);

    public OntDR.IntersectionOf createIntersectionOfDataRange(Collection<OntDR> var1);

    public OntCE.ObjectSomeValuesFrom createObjectSomeValuesFrom(OntOPE var1, OntCE var2);

    public OntCE.DataSomeValuesFrom createDataSomeValuesFrom(OntNDP var1, OntDR var2);

    public OntCE.ObjectAllValuesFrom createObjectAllValuesFrom(OntOPE var1, OntCE var2);

    public OntCE.DataAllValuesFrom createDataAllValuesFrom(OntNDP var1, OntDR var2);

    public OntCE.ObjectHasValue createObjectHasValue(OntOPE var1, OntIndividual var2);

    public OntCE.DataHasValue createDataHasValue(OntNDP var1, Literal var2);

    public OntCE.ObjectMinCardinality createObjectMinCardinality(OntOPE var1, int var2, OntCE var3);

    public OntCE.DataMinCardinality createDataMinCardinality(OntNDP var1, int var2, OntDR var3);

    public OntCE.ObjectMaxCardinality createObjectMaxCardinality(OntOPE var1, int var2, OntCE var3);

    public OntCE.DataMaxCardinality createDataMaxCardinality(OntNDP var1, int var2, OntDR var3);

    public OntCE.ObjectCardinality createObjectCardinality(OntOPE var1, int var2, OntCE var3);

    public OntCE.DataCardinality createDataCardinality(OntNDP var1, int var2, OntDR var3);

    public OntCE.UnionOf createUnionOf(Collection<OntCE> var1);

    public OntCE.IntersectionOf createIntersectionOf(Collection<OntCE> var1);

    public OntCE.OneOf createOneOf(Collection<OntIndividual> var1);

    public OntCE.HasSelf createHasSelf(OntOPE var1);

    public OntCE.NaryDataAllValuesFrom createDataAllValuesFrom(Collection<OntNDP> var1, OntDR var2);

    public OntCE.NaryDataSomeValuesFrom createDataSomeValuesFrom(Collection<OntNDP> var1, OntDR var2);

    public OntCE.ComplementOf createComplementOf(OntCE var1);

    public OntSWRL.Variable createSWRLVariable(String var1);

    public OntSWRL.Atom.BuiltIn createBuiltInSWRLAtom(Resource var1, Collection<OntSWRL.DArg> var2);

    public OntSWRL.Atom.OntClass createClassSWRLAtom(OntCE var1, OntSWRL.IArg var2);

    public OntSWRL.Atom.DataRange createDataRangeSWRLAtom(OntDR var1, OntSWRL.DArg var2);

    public OntSWRL.Atom.DataProperty createDataPropertySWRLAtom(OntNDP var1, OntSWRL.IArg var2, OntSWRL.DArg var3);

    public OntSWRL.Atom.ObjectProperty createObjectPropertySWRLAtom(OntOPE var1, OntSWRL.IArg var2, OntSWRL.IArg var3);

    public OntSWRL.Atom.DifferentIndividuals createDifferentIndividualsSWRLAtom(OntSWRL.IArg var1, OntSWRL.IArg var2);

    public OntSWRL.Atom.SameIndividuals createSameIndividualsSWRLAtom(OntSWRL.IArg var1, OntSWRL.IArg var2);

    public OntSWRL.Imp createSWRLImp(Collection<OntSWRL.Atom> var1, Collection<OntSWRL.Atom> var2);

    public OntGraphModel setNsPrefix(String var1, String var2);

    public OntGraphModel removeNsPrefix(String var1);

    public OntGraphModel clearNsPrefixMap();

    public OntGraphModel setNsPrefixes(PrefixMapping var1);

    public OntGraphModel setNsPrefixes(Map<String, String> var1);

    public OntGraphModel withDefaultMappings(PrefixMapping var1);

    default public Stream<OntStatement> localStatements() {
        return this.localStatements(null, null, null);
    }

    default public <E extends OntEntity> Stream<E> ontEntities(Class<E> type) {
        return this.ontObjects(type);
    }

    default public <E extends OntEntity> E fetchOntEntity(Class<E> type, String uri) {
        E res = this.getOntEntity(type, uri);
        return res == null ? this.createOntEntity(type, uri) : res;
    }

    default public Stream<OntClass> listClasses() {
        return this.ontEntities(OntClass.class);
    }

    default public Stream<OntNAP> listAnnotationProperties() {
        return this.ontEntities(OntNAP.class);
    }

    default public Stream<OntNDP> listDataProperties() {
        return this.ontEntities(OntNDP.class);
    }

    default public Stream<OntNOP> listObjectProperties() {
        return this.ontEntities(OntNOP.class);
    }

    default public Stream<OntDT> listDatatypes() {
        return this.ontEntities(OntDT.class);
    }

    default public Stream<OntIndividual.Named> listNamedIndividuals() {
        return this.ontEntities(OntIndividual.Named.class);
    }

    default public <E extends OntEntity> E getOntEntity(Class<E> type, Resource uri) {
        return this.getOntEntity(type, uri.getURI());
    }

    default public OntNAP getAnnotationProperty(Resource uri) {
        return this.getOntEntity(OntNAP.class, uri);
    }

    default public OntNAP getRDFSComment() {
        return this.getAnnotationProperty((Resource)RDFS.comment);
    }

    default public OntNAP getRDFSLabel() {
        return this.getAnnotationProperty((Resource)RDFS.label);
    }

    default public OntClass getOWLThing() {
        return this.getOntEntity(OntClass.class, OWL.Thing);
    }

    default public OntClass getOWLNothing() {
        return this.getOntEntity(OntClass.class, OWL.Nothing);
    }

    default public OntNOP getOWLTopObjectProperty() {
        return this.getOntEntity(OntNOP.class, (Resource)OWL.topObjectProperty);
    }

    default public OntNOP getOWLBottomObjectProperty() {
        return this.getOntEntity(OntNOP.class, (Resource)OWL.bottomObjectProperty);
    }

    default public OntNDP getOWLTopDataProperty() {
        return this.getOntEntity(OntNDP.class, (Resource)OWL.topDataProperty);
    }

    default public OntNDP getOWLBottomDataProperty() {
        return this.getOntEntity(OntNDP.class, (Resource)OWL.bottomDataProperty);
    }
}

