/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntNPA;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public interface OntIndividual
extends OntObject {
    public OntStatement attachClass(OntCE var1);

    public void detachClass(OntCE var1);

    default public Stream<OntCE> classes() {
        return this.objects(RDF.type, OntCE.class);
    }

    default public Stream<OntIndividual> sameAs() {
        return this.objects(OWL.sameAs, OntIndividual.class);
    }

    default public OntStatement addSameAs(OntIndividual other) {
        return this.addStatement(OWL.sameAs, (RDFNode)other);
    }

    default public void removeSameAs(OntIndividual other) {
        this.remove(OWL.sameAs, (RDFNode)other);
    }

    default public Stream<OntIndividual> differentFrom() {
        return this.objects(OWL.differentFrom, OntIndividual.class);
    }

    default public OntStatement addDifferentFrom(OntIndividual other) {
        return this.addStatement(OWL.differentFrom, (RDFNode)other);
    }

    default public void removeDifferentFrom(OntIndividual other) {
        this.remove(OWL.differentFrom, (RDFNode)other);
    }

    default public OntIndividual addAssertion(OntNAP property, RDFNode value) {
        this.addProperty(property, value);
        return this;
    }

    default public OntIndividual addAssertion(OntNDP property, Literal value) {
        this.addProperty(property, (RDFNode)value);
        return this;
    }

    default public OntIndividual addAssertion(OntNOP property, OntIndividual value) {
        this.addProperty(property, (RDFNode)value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntOPE property, OntIndividual value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntNDP property, Literal value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public Stream<OntStatement> positiveAssertions() {
        return this.statements().filter(s -> s.getPredicate().canAs(OntPE.class));
    }

    default public Stream<OntNPA> negativeAssertions() {
        return this.getModel().ontObjects(OntNPA.class).filter(s -> this.equals(s.getSource()));
    }

    public static interface Anonymous
    extends OntIndividual {
    }

    public static interface Named
    extends OntIndividual,
    OntEntity {
    }
}

