/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntNPA;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public interface OntOPE
extends OntDOP {
    public OntNPA.ObjectAssertion addNegativeAssertion(OntIndividual var1, OntIndividual var2);

    public OntList<OntOPE> createPropertyChain(Collection<OntOPE> var1);

    public Stream<OntList<OntOPE>> listPropertyChains();

    public void removePropertyChain(RDFNode var1) throws OntJenaException;

    @Deprecated
    public void removeSuperPropertyOf();

    default public Stream<OntNPA.ObjectAssertion> negativeAssertions() {
        return this.getModel().ontObjects(OntNPA.ObjectAssertion.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNPA.ObjectAssertion> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Optional<OntList<OntOPE>> findPropertyChain(RDFNode list) {
        return this.listPropertyChains().filter(r -> Objects.equals(r, list)).findFirst();
    }

    default public OntStatement addSuperPropertyOf(OntOPE ... properties) {
        return this.createPropertyChain(Arrays.asList(properties)).getRoot();
    }

    default public void clearPropertyChains() {
        this.listPropertyChains().collect(Collectors.toSet()).forEach(this::removePropertyChain);
    }

    @Deprecated
    default public Stream<RDFList> propertyChains() {
        return this.listPropertyChains().map(c -> (RDFList)c.as(RDFList.class));
    }

    @Deprecated
    default public Stream<OntOPE> superPropertyOf() {
        return this.listPropertyChains().map(OntList::members).findFirst().orElse(Stream.empty());
    }

    @Deprecated
    default public OntStatement addSuperPropertyOf(Collection<OntOPE> properties) {
        return this.createPropertyChain(new ArrayList<OntOPE>(properties)).getRoot();
    }

    default public Stream<OntCE> range() {
        return this.objects(RDFS.range, OntCE.class);
    }

    default public OntStatement addRange(OntCE range) {
        return this.addStatement(RDFS.range, (RDFNode)range);
    }

    default public Stream<OntOPE> subPropertyOf() {
        return this.objects(RDFS.subPropertyOf, OntOPE.class);
    }

    default public OntStatement addSubPropertyOf(OntOPE superProperty) {
        return this.addStatement(RDFS.subPropertyOf, (RDFNode)superProperty);
    }

    default public Stream<OntOPE> disjointWith() {
        return this.objects(OWL.propertyDisjointWith, OntOPE.class);
    }

    default public OntStatement addDisjointWith(OntOPE other) {
        return this.addStatement(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public void removeDisjointWith(OntOPE other) {
        this.remove(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public Stream<OntOPE> equivalentProperty() {
        return this.objects(OWL.equivalentProperty, OntOPE.class);
    }

    default public OntStatement addEquivalentProperty(OntOPE other) {
        return this.addStatement(OWL.equivalentProperty, (RDFNode)other);
    }

    default public void removeEquivalentProperty(OntOPE other) {
        this.remove(OWL.equivalentProperty, (RDFNode)other);
    }

    default public OntOPE getInverseOf() {
        try (Stream<OntOPE> res = this.inverseOf();){
            OntOPE ontOPE = res.findFirst().orElse(null);
            return ontOPE;
        }
    }

    default public Stream<OntOPE> inverseOf() {
        return this.objects(OWL.inverseOf, OntOPE.class);
    }

    default public OntStatement addInverseOf(OntOPE other) {
        return this.addStatement(OWL.inverseOf, (RDFNode)other);
    }

    default public void removeInverseOf(OntOPE other) {
        this.remove(OWL.inverseOf, (RDFNode)other);
    }

    default public boolean isInverseFunctional() {
        return this.hasType(OWL.InverseFunctionalProperty);
    }

    public void setInverseFunctional(boolean var1);

    default public boolean isTransitive() {
        return this.hasType(OWL.TransitiveProperty);
    }

    public void setTransitive(boolean var1);

    default public boolean isSymmetric() {
        return this.hasType(OWL.SymmetricProperty);
    }

    public void setSymmetric(boolean var1);

    default public boolean isAsymmetric() {
        return this.hasType(OWL.AsymmetricProperty);
    }

    public void setAsymmetric(boolean var1);

    default public boolean isReflexive() {
        return this.hasType(OWL.ReflexiveProperty);
    }

    public void setReflexive(boolean var1);

    default public boolean isIrreflexive() {
        return this.hasType(OWL.IrreflexiveProperty);
    }

    public void setIrreflexive(boolean var1);

    public static interface Inverse
    extends OntOPE {
        public OntNOP getDirect();
    }
}

