/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.model.OntResource;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public interface OntObject
extends OntResource {
    @Override
    public OntStatement getRoot();

    public Stream<OntStatement> spec();

    public Stream<OntStatement> content();

    public OntStatement addStatement(Property var1, RDFNode var2);

    public OntObject remove(Property var1, RDFNode var2);

    public Optional<OntStatement> statement(Property var1, RDFNode var2);

    public Optional<OntStatement> statement(Property var1);

    public Stream<OntStatement> statements(Property var1);

    public Stream<OntStatement> statements();

    public Stream<OntStatement> annotations();

    @Override
    public OntObject clearAnnotations();

    public <O extends RDFNode> Stream<O> objects(Property var1, Class<O> var2);

    public OntStatement getRequiredProperty(Property var1);

    default public boolean hasType(Resource type) {
        try (Stream<Resource> types = this.types();){
            boolean bl = types.anyMatch(arg_0 -> ((Resource)type).equals(arg_0));
            return bl;
        }
    }

    default public Stream<Resource> types() {
        return this.objects(RDF.type, Resource.class);
    }
}

