/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntStatement;

interface OntResource
extends Resource {
    public OntGraphModel getModel();

    public OntStatement getRoot();

    public boolean isLocal();

    public Stream<? extends Statement> spec();

    public OntStatement addAnnotation(OntNAP var1, RDFNode var2);

    public OntResource clearAnnotations();

    default public OntStatement addAnnotation(OntNAP predicate, String lexicalForm) {
        return this.addAnnotation(predicate, lexicalForm, null);
    }

    default public OntStatement addAnnotation(OntNAP predicate, String lexicalForm, String lang) {
        return this.addAnnotation(predicate, (RDFNode)this.getModel().createLiteral(lexicalForm, lang));
    }

    default public OntStatement addComment(String txt) {
        return this.addComment(txt, null);
    }

    default public OntStatement addComment(String txt, String lang) {
        return this.addAnnotation(this.getModel().getRDFSComment(), txt, lang);
    }

    default public OntStatement addLabel(String txt) {
        return this.addLabel(txt, null);
    }

    default public OntStatement addLabel(String txt, String lang) {
        return this.addAnnotation(this.getModel().getRDFSLabel(), txt, lang);
    }
}

