/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.model.OntAnnotation;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public interface OntStatement
extends Statement {
    public OntGraphModel getModel();

    public OntStatement addAnnotation(OntNAP var1, RDFNode var2);

    public Stream<OntStatement> annotations();

    public OntStatement deleteAnnotation(OntNAP var1, RDFNode var2) throws OntJenaException;

    public Stream<OntAnnotation> annotationResources();

    public List<OntAnnotation> getAnnotationList();

    @Deprecated
    public boolean isRoot();

    public boolean isLocal();

    public OntObject getSubject();

    default public Optional<OntAnnotation> asAnnotationResource() {
        List<OntAnnotation> res = this.getAnnotationList();
        return res.isEmpty() ? Optional.empty() : Optional.of(res.get(0));
    }

    default public Stream<OntStatement> annotations(OntNAP property) {
        return this.annotations().filter(s -> Objects.equals(property, s.getPredicate()));
    }

    default public void deleteAnnotation(OntNAP property) {
        this.annotations(property).map(Statement::getObject).collect(Collectors.toSet()).forEach(v -> this.deleteAnnotation(property, (RDFNode)v));
    }

    default public boolean isDeclaration() {
        return RDF.type.equals(this.getPredicate());
    }

    default public boolean isAnnotation() {
        return this.getPredicate().canAs(OntNAP.class);
    }

    default public boolean isBulkAnnotation() {
        return this.getSubject().canAs(OntAnnotation.class);
    }

    default public boolean isData() {
        return this.getPredicate().canAs(OntNDP.class);
    }

    default public boolean isObject() {
        return this.getPredicate().canAs(OntNOP.class);
    }

    default public void clearAnnotations() {
        this.annotations().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(a -> this.deleteAnnotation((OntNAP)a.getPredicate().as(OntNAP.class), a.getObject()));
    }

    default public boolean hasAnnotations() {
        try (Stream<OntStatement> annotations = this.annotations();){
            boolean bl = annotations.findAny().isPresent();
            return bl;
        }
    }

    default public OntStatement addAnnotation(OntNAP predicate, String text) {
        return this.addAnnotation(predicate, text, null);
    }

    default public OntStatement addAnnotation(OntNAP predicate, String text, String lang) {
        return this.addAnnotation(predicate, (RDFNode)this.getModel().createLiteral(text, lang));
    }

    default public <N extends RDFNode> N getSubject(Class<N> type) {
        return (N)this.getSubject().as(type);
    }
}

