/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class Iter {
    public static <T> Stream<T> asStream(ClosableIterator<T> iterator) {
        return (Stream)org.apache.jena.atlas.iterator.Iter.asStream(iterator).onClose(() -> iterator.close());
    }

    public static StmtIterator createStmtIterator(ExtendedIterator<Triple> triples, Function<Triple, Statement> map) {
        return new StmtIteratorImpl((Iterator)triples.mapWith(map));
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    public static <T, F> ExtendedIterator<T> flatMap(ExtendedIterator<F> base, Function<? super F, ? extends Iterator<? extends T>> mapper) {
        return WrappedIterator.createIteratorIterator((Iterator)base.mapWith(mapper));
    }

    public static <T> ExtendedIterator<T> concat(ExtendedIterator<? extends T> a, ExtendedIterator<? extends T> b) {
        return a.andThen(b);
    }

    public static <X> ExtendedIterator<X> peek(ExtendedIterator<X> base, Consumer<? super X> action) {
        return base.mapWith(x -> {
            action.accept((Object)x);
            return x;
        });
    }

    public static <X> ExtendedIterator<X> distinct(ExtendedIterator<X> base) {
        return base.filterKeep((Predicate)new FilterUnique());
    }

    @SafeVarargs
    public static <X> ExtendedIterator<X> of(X ... members) {
        return WrappedIterator.create(Arrays.asList(members).iterator());
    }
}

