/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntIndividualImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class Models {
    public static final Comparator<RDFNode> RDF_NODE_COMPARATOR = (r1, r2) -> NodeUtils.compareRDFTerms((Node)r1.asNode(), (Node)r2.asNode());
    public static final Comparator<Statement> STATEMENT_COMPARATOR = Comparator.comparing(Statement::getSubject, RDF_NODE_COMPARATOR).thenComparing(Statement::getPredicate, RDF_NODE_COMPARATOR).thenComparing(Statement::getObject, RDF_NODE_COMPARATOR);
    public static final RDFNode BLANK = new ResourceImpl();
    public static final Comparator<Statement> STATEMENT_COMPARATOR_IGNORE_BLANK = Comparator.comparing(s -> s.getSubject().isAnon() ? BLANK : s.getSubject(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getPredicate().isAnon() ? BLANK : s.getPredicate(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getObject().isAnon() ? BLANK : s.getObject(), RDF_NODE_COMPARATOR);
    public static final Literal TRUE = ResourceFactory.createTypedLiteral((Object)Boolean.TRUE);
    public static final Literal FALSE = ResourceFactory.createTypedLiteral((Object)Boolean.FALSE);

    @Deprecated
    public static Resource createTypedList(Model model, Resource type, Stream<? extends RDFNode> members) {
        return Models.createTypedList(model, type, members.collect(Collectors.toList()));
    }

    public static RDFList createTypedList(Model model, Resource type, Collection<? extends RDFNode> members) {
        return Models.createTypedList(model, type, members.iterator());
    }

    public static RDFList createTypedList(Model model, Resource type, Iterator<? extends RDFNode> members) {
        return OntListImpl.createTypedList((EnhGraph)model, type, members);
    }

    public static boolean isInList(Model model, Resource candidate) {
        return model.contains(null, RDF.first, (RDFNode)candidate);
    }

    public static boolean isInList(Statement s) {
        return RDF.first.equals(s.getPredicate()) || RDF.rest.equals(s.getPredicate()) || RDF.nil.equals((Object)s.getObject());
    }

    public static OntIndividual.Anonymous asAnonymousIndividual(RDFNode node) {
        return OntIndividualImpl.createAnonymousIndividual(node);
    }

    public static Map<String, String> setNsPrefixes(PrefixMapping mapping, Map<String, String> prefixes) {
        Map init = mapping.getNsPrefixMap();
        init.keySet().forEach(arg_0 -> ((PrefixMapping)mapping).removeNsPrefix(arg_0));
        prefixes.forEach((p, u) -> mapping.setNsPrefix(p.replaceAll(":$", ""), u));
        return init;
    }

    public static Stream<String> langValues(Resource subject, Property predicate, String lang) {
        return Iter.asStream(subject.listProperties(predicate)).map(Statement::getObject).filter(RDFNode::isLiteral).map(RDFNode::asLiteral).filter(l -> Models.filterByLang(l, lang)).map(Literal::getString);
    }

    private static boolean filterByLang(Literal literal, String lang) {
        String other = literal.getLanguage();
        if (StringUtils.isEmpty((CharSequence)lang)) {
            return StringUtils.isEmpty((CharSequence)other);
        }
        return lang.trim().equalsIgnoreCase(other);
    }

    public static void deleteAll(Resource inModel) {
        Models.deleteAll(inModel, new HashSet<Node>());
    }

    private static void deleteAll(Resource r, Set<Node> viewed) {
        if (viewed.contains(r.asNode())) {
            return;
        }
        viewed.add(r.asNode());
        Set props = r.listProperties().toSet();
        props.forEach(s -> {
            RDFNode o = s.getObject();
            if (o.isAnon()) {
                Models.deleteAll(o.asResource(), viewed);
            }
            r.getModel().remove(s);
        });
    }

    public static Set<Statement> getAssociatedStatements(Resource inModel) {
        HashSet<Statement> res = new HashSet<Statement>();
        Models.calcAssociatedStatements(inModel, res);
        return res;
    }

    private static void calcAssociatedStatements(Resource root, Set<Statement> res) {
        if (root.canAs(RDFList.class)) {
            RDFListImpl list = (RDFListImpl)root.as(RDFList.class);
            if (list.isEmpty()) {
                return;
            }
            list.collectStatements().forEach(statement -> {
                res.add((Statement)statement);
                if (!list.listFirst().equals(statement.getPredicate())) {
                    return;
                }
                RDFNode obj = statement.getObject();
                if (obj.isAnon()) {
                    Models.calcAssociatedStatements(obj.asResource(), res);
                }
            });
            return;
        }
        root.listProperties().forEachRemaining(statement -> {
            try {
                if (!statement.getObject().isAnon() || res.stream().anyMatch(s -> statement.getObject().equals(s.getSubject()))) {
                    return;
                }
                Models.calcAssociatedStatements(statement.getObject().asResource(), res);
            }
            finally {
                res.add((Statement)statement);
            }
        });
    }

    public static Stream<Statement> listProperties(RDFNode subject) {
        if (subject == null || !subject.isAnon()) {
            return Stream.empty();
        }
        return Iter.asStream(subject.asResource().listProperties()).flatMap(s -> s.getObject().isAnon() ? Models.listProperties((RDFNode)s.getObject().asResource()) : Stream.of(s));
    }

    public static Stream<Resource> listSubjects(RDFNode object) {
        return Models.subjects(object).flatMap(s -> {
            Stream<Resource> r = Stream.of(s);
            return s.isAnon() ? Stream.concat(r, Models.listSubjects((RDFNode)s)) : r;
        });
    }

    public static Stream<Resource> subjects(RDFNode inModel) {
        return Iter.asStream(inModel.getModel().listResourcesWithProperty(null, inModel));
    }

    public static Stream<OntStatement> split(OntStatement statement) {
        return Iter.asStream(Models.listSplitStatements(statement));
    }

    public static ExtendedIterator<OntStatement> listSplitStatements(OntStatement statement) {
        return ((OntStatementImpl)statement).listSplitStatements();
    }

    public static OntStatement createCachedStatement(OntStatement delegate) {
        return OntStatementImpl.createCachedOntStatementImpl(delegate);
    }

    public static String toString(Statement st, PrefixMapping pm) {
        return String.format("[%s, %s, %s]", st.getSubject().asNode().toString(pm, false), st.getPredicate().asNode().toString(pm, false), st.getObject().asNode().toString(pm, true));
    }

    public static String toString(Statement inModel) {
        return Models.toString(inModel, (PrefixMapping)inModel.getModel());
    }

    public static void insert(Supplier<Stream<OntGraphModel>> manager, OntGraphModel ont, boolean replace) {
        String uri = Objects.requireNonNull(ont.getID().getURI(), "Must be named ontology");
        manager.get().filter(m -> m.getID().imports().anyMatch(uri::equals)).peek(m -> {
            if (!replace) {
                return;
            }
            m.imports().filter(i -> uri.equals(i.getID().getURI())).findFirst().ifPresent(i -> ((UnionGraph)m.getGraph()).removeGraph(i.getGraph()));
        }).filter(m -> m.imports().map(OntGraphModel::getID).map(Resource::getURI).noneMatch(uri::equals)).forEach(m -> m.addImport(ont));
    }

    public static Stream<OntGraphModel> flat(OntGraphModel m) {
        return Stream.concat(Stream.of(m), m.imports().flatMap(Models::flat));
    }

    public static Stream<OntStatement> flat(OntStatement st) {
        return Stream.concat(st.annotations(), st.annotations().flatMap(Models::flat));
    }

    public static ExtendedIterator<OntStatement> listStatements(OntGraphModel model, Resource s, Property p, RDFNode o) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalStatements(s, p, o);
        }
        return WrappedIterator.create(model.localStatements(s, p, o).iterator());
    }

    public static <O extends OntObject> ExtendedIterator<O> listOntObjects(OntGraphModel model, Class<? extends O> type) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntObjects(type);
        }
        Stream<O> res = model.ontObjects(type);
        return WrappedIterator.create(res.iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static ExtendedIterator<OntEntity> listEntities(OntGraphModel model) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntEntities();
        }
        return WrappedIterator.create(model.ontEntities().iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static <X extends RDFNode> ExtendedIterator<X> listMembers(OntList<X> list) {
        if (list instanceof OntListImpl) {
            return ((OntListImpl)list).listMembers();
        }
        return WrappedIterator.create(list.members().iterator());
    }
}

