/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.NNF;
import ru.avicomp.ontapi.DataFactoryImpl;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.OWLObjectImpl;

public abstract class OWLAxiomImpl
extends OWLObjectImpl
implements OWLAxiom {
    protected final List<OWLAnnotation> annotations;

    public OWLAxiomImpl(Collection<OWLAnnotation> annotations) {
        this.annotations = Objects.requireNonNull(annotations, "annotations cannot be null").stream().filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public Stream<OWLAnnotation> annotations() {
        return this.annotations.stream();
    }

    public List<OWLAnnotation> annotationsAsList() {
        return this.annotations;
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    protected Collection<OWLAnnotation> mergeAnnos(Stream<OWLAnnotation> annos) {
        return Stream.concat(annos, this.annotations()).filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public OWLAxiom getNNF() {
        return (OWLAxiom)this.accept((OWLAxiomVisitorEx)new NNF((OWLDataFactory)new DataFactoryImpl()));
    }
}

