/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.axioms.OWLClassAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLDisjointClassesAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLEquivalentClassesAxiomImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectUnionOfImpl;

public class OWLDisjointUnionAxiomImpl
extends OWLClassAxiomImpl
implements OWLDisjointUnionAxiom {
    private final OWLClass owlClass;
    private final List<OWLClassExpression> classExpressions;

    public OWLDisjointUnionAxiomImpl(OWLClass owlClass, Stream<OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.owlClass = Objects.requireNonNull(owlClass, "owlClass cannot be null");
        Objects.requireNonNull(classExpressions, "classExpressions cannot be null");
        this.classExpressions = classExpressions.filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public Stream<OWLClassExpression> classExpressions() {
        return this.classExpressions.stream();
    }

    public Stream<OWLClassExpression> operands() {
        return this.classExpressions();
    }

    public List<OWLClassExpression> getOperandsAsList() {
        return this.classExpressions;
    }

    public OWLDisjointUnionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.classExpressions.stream(), NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.classExpressions(), this.mergeAnnos(anns));
    }

    public OWLClass getOWLClass() {
        return this.owlClass;
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom() {
        return new OWLEquivalentClassesAxiomImpl(Arrays.asList(this.owlClass, new OWLObjectUnionOfImpl(this.classExpressions)), NO_ANNOTATIONS);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom() {
        return new OWLDisjointClassesAxiomImpl(this.classExpressions, NO_ANNOTATIONS);
    }
}

