/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.objects.entity;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import ru.avicomp.ontapi.owlapi.OWLObjectImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectComplementOfImpl;

public class OWLClassImpl
extends OWLObjectImpl
implements OWLClass,
Serializable {
    private final IRI iri;
    private final boolean isThing;
    private final boolean isNothing;

    public OWLClassImpl(IRI iri) {
        this.iri = Objects.requireNonNull(iri, "iri cannot be null");
        this.isThing = this.getIRI().isThing();
        this.isNothing = this.getIRI().isNothing();
    }

    public OWLClassExpression getObjectComplementOf() {
        return new OWLObjectComplementOfImpl((OWLClassExpression)this);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    public boolean isOWLThing() {
        return this.isThing;
    }

    public boolean isOWLNothing() {
        return this.isNothing;
    }

    public OWLClassExpression getNNF() {
        return this;
    }

    public Set<OWLClassExpression> asConjunctSet() {
        return CollectionFactory.createSet((Object)this);
    }

    public Stream<OWLClassExpression> conjunctSet() {
        return Stream.of(this);
    }

    public boolean containsConjunct(OWLClassExpression ce) {
        return ce.equals(this);
    }

    public Set<OWLClassExpression> asDisjunctSet() {
        return CollectionFactory.createSet((Object)this);
    }

    public OWLClassExpression getComplementNNF() {
        return new OWLObjectComplementOfImpl((OWLClassExpression)this);
    }

    public Stream<OWLClassExpression> disjunctSet() {
        return Stream.of(this);
    }
}

