/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.transforms.OWLCommonTransform;
import ru.avicomp.ontapi.transforms.OWLDeclarationTransform;
import ru.avicomp.ontapi.transforms.OWLIDTransform;
import ru.avicomp.ontapi.transforms.OWLRecursiveTransform;
import ru.avicomp.ontapi.transforms.RDFSTransform;
import ru.avicomp.ontapi.transforms.SWRLTransform;
import ru.avicomp.ontapi.transforms.Transform;
import ru.avicomp.ontapi.transforms.TransformException;

public abstract class GraphTransformers {
    protected static Store converters = new Store().add(OWLIDTransform.class).add(OWLRecursiveTransform.class).add(RDFSTransform.class).add(OWLCommonTransform.class).add(OWLDeclarationTransform.class).add(SWRLTransform.class);

    public static Store setTransformers(Store store) {
        Objects.requireNonNull(store, "Null converter store specified.");
        Store prev = converters;
        converters = store;
        return prev;
    }

    public static Store getTransformers() {
        return converters;
    }

    public static Graph convert(Graph graph) throws TransformException {
        GraphTransformers.getTransformers().transform(graph);
        return graph;
    }

    public static class DefaultMaker
    implements Maker {
        protected final Class<? extends Transform> impl;

        public DefaultMaker(Class<? extends Transform> impl) throws IllegalArgumentException {
            try {
                if (!Modifier.isPublic(impl.getDeclaredConstructor(Graph.class).getModifiers())) {
                    throw new IllegalArgumentException(impl.getName() + ": no public constructor.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(impl.getName() + " must have public constructor with " + Graph.class.getName() + " as the only parameter.", e);
            }
            this.impl = impl;
        }

        @Override
        public Transform create(Graph graph) throws IllegalStateException {
            try {
                return this.impl.getDeclaredConstructor(Graph.class).newInstance(graph);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Can't init " + this.impl.getName(), e);
            }
        }

        @Override
        public String id() {
            return this.impl.getName();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof DefaultMaker && this.impl.equals(((DefaultMaker)o).impl);
        }

        public int hashCode() {
            return this.impl.hashCode();
        }

        public String toString() {
            return String.format("DefaultMaker{impl=%s}", this.impl);
        }
    }

    public static class StoreException
    extends TransformException {
        protected final Transform transform;
        protected Graph parent;

        protected StoreException(Transform transform, Throwable cause) {
            super(cause);
            this.transform = OntApiException.notNull(transform, "Null transform");
        }

        protected StoreException putParent(Graph graph) {
            this.parent = OntApiException.notNull(graph, "Null parent graph");
            return this;
        }

        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            if (this.parent != null) {
                sb.append(Graphs.getName(this.parent)).append(" => ");
            }
            sb.append(this.transform);
            Throwable cause = this.getCause();
            if (cause != null) {
                sb.append(": ").append(cause.getMessage());
            }
            return sb.toString();
        }
    }

    public static class TransformListener
    extends GraphListenerBase {
        protected Set<Triple> added = new HashSet<Triple>();
        protected Set<Triple> deleted = new HashSet<Triple>();

        protected void addEvent(Triple t) {
            this.added.add(t);
            this.deleted.remove(t);
        }

        protected void deleteEvent(Triple t) {
            this.added.remove(t);
            this.deleted.add(t);
        }

        public void notifyAddGraph(Graph g, Graph other) {
            other.find(Triple.ANY).forEachRemaining(this::addEvent);
        }

        public void notifyDeleteGraph(Graph g, Graph other) {
            other.find(Triple.ANY).forEachRemaining(this::deleteEvent);
        }
    }

    public static class Stats {
        protected final Graph graph;
        protected Map<Type, Map<String, Set<Triple>>> triples = new EnumMap<Type, Map<String, Set<Triple>>>(Type.class);
        protected Set<Stats> sub = new HashSet<Stats>();

        protected Stats(Graph graph) {
            this.graph = Objects.requireNonNull(graph);
        }

        protected void putTriples(Transform transform, Set<Triple> added, Set<Triple> deleted, Set<Triple> unparsed) {
            String name = transform.name();
            this.put(Type.ADDED, name, added);
            this.put(Type.DELETED, name, deleted);
            this.put(Type.UNPARSED, name, unparsed);
        }

        protected void put(Type type, String name, Set<Triple> triples) {
            this.map(type).put(name, triples);
        }

        protected void putStats(Stats other) {
            this.sub.add(other);
        }

        public Set<Triple> getTriples(Type type, String name) {
            return Stats.getUnmodifiable(this.map(type), name);
        }

        public Stream<Triple> triples(Type type) {
            return this.map(type).entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream);
        }

        public boolean hasTriples(Type type, String name) {
            if (!this.triples.containsKey((Object)type)) {
                return false;
            }
            if (!this.triples.get((Object)type).containsKey(name)) {
                return false;
            }
            return !this.triples.get((Object)type).get(name).isEmpty();
        }

        public boolean hasTriples(Type type) {
            if (!this.triples.containsKey((Object)type)) {
                return false;
            }
            return this.triples.get((Object)type).values().stream().anyMatch(x -> !x.isEmpty());
        }

        public boolean hasTriples() {
            return !this.triples.isEmpty();
        }

        public boolean isNotEmpty() {
            return this.hasTriples() && Arrays.stream(Type.values()).anyMatch(this::hasTriples);
        }

        protected Map<String, Set<Triple>> map(Type type) {
            return this.triples.computeIfAbsent(type, t -> new HashMap());
        }

        public Graph getGraph() {
            return this.graph;
        }

        public Stream<Stats> listStats(boolean deep) {
            if (!deep) {
                return this.sub.stream();
            }
            return this.sub.stream().flatMap(s -> Stream.concat(Stream.of(s), s.listStats(true)));
        }

        private static <T> Set<T> getUnmodifiable(Map<String, Set<T>> map, String key) {
            return map.containsKey(key) ? Collections.unmodifiableSet(map.get(key)) : Collections.emptySet();
        }

        public static enum Type {
            ADDED,
            DELETED,
            UNPARSED;

        }
    }

    public static class Store
    implements Serializable {
        private static final Logger LOGGER = LoggerFactory.getLogger(Store.class);
        private static final long serialVersionUID = -1L;
        protected Map<String, Maker> set = new LinkedHashMap<String, Maker>();
        protected Filter filter = g -> true;

        public Store copy() {
            Store res = this.empty();
            res.set.putAll(this.set);
            return res;
        }

        protected Store empty() {
            Store res = new Store();
            res.filter = this.filter;
            return res;
        }

        public boolean contains(String id) {
            return this.get(id).isPresent();
        }

        public Optional<Maker> get(String id) {
            return this.set.containsKey(id) ? Optional.of(this.set.get(id)) : Optional.empty();
        }

        public Store addLast(Maker f) {
            return this.add(f);
        }

        protected Store add(Class<? extends Transform> impl) {
            return this.add(new DefaultMaker(impl));
        }

        public Store add(Maker f) {
            Store res = this.copy();
            res.set.put(f.id(), f);
            return res;
        }

        public Store addFirst(Maker f) {
            Store res = this.empty();
            res.set.put(f.id(), f);
            res.set.putAll(this.set);
            return res;
        }

        public Store insertAfter(String id, Maker f) {
            if (!this.set.containsKey(id)) {
                throw new IllegalArgumentException("Can't find " + id);
            }
            Store res = this.empty();
            this.set.keySet().forEach(i -> {
                res.set.put((String)i, this.set.get(i));
                if (Objects.equals(i, id)) {
                    res.set.put(f.id(), f);
                }
            });
            return res;
        }

        public Store removeFirst() {
            if (this.set.isEmpty()) {
                throw new IllegalStateException("Nothing to remove");
            }
            return this.delete((String)this.set.keySet().toArray()[0]);
        }

        public Store removeLast() {
            if (this.set.isEmpty()) {
                throw new IllegalStateException("Nothing to remove");
            }
            return this.delete((String)this.set.keySet().toArray()[this.set.size() - 1]);
        }

        public Store remove(String id) {
            if (this.set.isEmpty()) {
                throw new IllegalStateException("Nothing to remove");
            }
            if (!this.set.containsKey(id)) {
                throw new IllegalArgumentException("Can't find " + id);
            }
            return this.delete(id);
        }

        protected Store delete(String id) {
            Store res = this.copy();
            res.set.remove(id);
            return res;
        }

        public Stream<String> ids() {
            return this.set.keySet().stream();
        }

        protected Stream<Transform> actions(Graph graph) {
            return this.filter.test(graph) ? this.makers().map(f -> f.create(graph)).filter(Transform::test) : Stream.empty();
        }

        protected Stream<Maker> makers() {
            return this.set.values().stream();
        }

        public Store addFilter(Filter filter) {
            Objects.requireNonNull(filter);
            return this.setFilter(g -> this.filter.test(g) && filter.test(g));
        }

        public Store setFilter(Filter f) {
            Store res = this.copy();
            res.filter = Objects.requireNonNull(f, "Null filter");
            return res;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Stats transform(Graph graph) throws TransformException {
            return this.transform(graph, new HashSet<Graph>());
        }

        public Stats transform(Graph graph, Set<Graph> skip) throws TransformException {
            List children = Graphs.subGraphs(graph).collect(Collectors.toList());
            Graph base = Graphs.getBase(graph);
            Stats res = new Stats(base);
            for (Graph g : children) {
                try {
                    res.putStats(this.transform(g, skip));
                }
                catch (StoreException t) {
                    throw t.putParent(graph);
                }
            }
            if (skip.contains(base)) {
                return res;
            }
            List actions = this.actions(graph).collect(Collectors.toList());
            for (Transform action : actions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Process <%s> on <%s>", action.name(), Graphs.getName(base)));
                }
                GraphEventManager events = base.getEventManager();
                TransformListener listener = new TransformListener();
                try {
                    events.register((GraphListener)listener);
                    action.perform();
                }
                catch (JenaException e) {
                    throw new StoreException(action, (Throwable)e);
                }
                finally {
                    events.unregister((GraphListener)listener);
                }
                res.putTriples(action, listener.added, listener.deleted, action.uncertainTriples().collect(Collectors.toSet()));
            }
            skip.add(base);
            return res;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Store && this.set.equals(((Store)o).set) && this.filter.equals(((Store)o).filter);
        }

        public int hashCode() {
            return Objects.hash(this.set, this.filter);
        }
    }

    @FunctionalInterface
    public static interface Filter
    extends Predicate<Graph>,
    Serializable {
    }

    @FunctionalInterface
    public static interface Maker
    extends Serializable {
        public Transform create(Graph var1);

        default public String id() {
            return this.getClass().getName() + "@" + Objects.hashCode(this);
        }

        public static Maker create(String id, Predicate<Graph> filter, final Consumer<Graph> transform) {
            Objects.requireNonNull(id, "Null id");
            Objects.requireNonNull(transform, "Null transform function");
            return Maker.create(id, g -> new Transform((Graph)g, (Graph)g, filter, id){
                final /* synthetic */ Graph val$g;
                final /* synthetic */ Predicate val$filter;
                final /* synthetic */ String val$id;
                {
                    this.val$g = graph2;
                    this.val$filter = predicate;
                    this.val$id = string;
                    super(graph);
                }

                @Override
                public void perform() throws TransformException {
                    transform.accept(this.val$g);
                }

                @Override
                public boolean test() {
                    return this.val$filter == null || this.val$filter.test(this.graph);
                }

                @Override
                public String name() {
                    return this.val$id;
                }
            });
        }

        public static Maker create(final String id, final Function<Graph, Transform> factory) {
            Objects.requireNonNull(id, "Null id");
            Objects.requireNonNull(factory, "Null transform factory");
            return new Maker(){

                @Override
                public Transform create(Graph graph) {
                    return (Transform)factory.apply(graph);
                }

                @Override
                public String id() {
                    return id;
                }
            };
        }
    }
}

