/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.transforms.Transform;
import ru.avicomp.ontapi.transforms.vocabulary.WRONG_OWL;

public class OWLCommonTransform
extends Transform {
    protected static final boolean PROCESS_INDIVIDUALS_DEFAULT = false;
    private static final Map<Property, Property> CARDINALITY_PREDICATES = Collections.unmodifiableMap(new HashMap<Property, Property>(){
        {
            this.put(OWL.cardinality, OWL.qualifiedCardinality);
            this.put(OWL.maxCardinality, OWL.maxQualifiedCardinality);
            this.put(OWL.minCardinality, OWL.minQualifiedCardinality);
        }
    });
    private boolean processIndividuals;

    public OWLCommonTransform(Graph graph) {
        this(graph, false);
    }

    protected OWLCommonTransform(Graph graph, boolean processIndividuals) {
        super(graph);
        this.processIndividuals = processIndividuals;
    }

    @Override
    public void perform() {
        Stream.of(OWL.DataRange, RDFS.Datatype, OWL.Restriction, OWL.Class).map(p -> this.statements(null, ru.avicomp.ontapi.jena.vocabulary.RDF.type, (RDFNode)p)).flatMap(Function.identity()).forEach(s -> this.undeclare(s.getSubject(), RDFS.Class));
        Stream.of(OWL.ObjectProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty, OWL.TransitiveProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.OntologyProperty).map(p -> this.statements(null, ru.avicomp.ontapi.jena.vocabulary.RDF.type, (RDFNode)p)).flatMap(Function.identity()).forEach(s -> this.undeclare(s.getSubject(), ru.avicomp.ontapi.jena.vocabulary.RDF.Property));
        Stream.of(OWL.InverseFunctionalProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.AsymmetricProperty, OWL.ReflexiveProperty, OWL.IrreflexiveProperty).map(p -> this.statements(null, ru.avicomp.ontapi.jena.vocabulary.RDF.type, (RDFNode)p)).flatMap(Function.identity()).forEach(s -> this.declare(s.getSubject(), OWL.ObjectProperty));
        this.changeType(OWL.OntologyProperty, OWL.AnnotationProperty);
        this.changeType(OWL.DataRange, RDFS.Datatype);
        this.fixInvalidURIs();
        this.fixAxioms();
        if (this.processIndividuals) {
            this.fixNamedIndividuals();
        }
    }

    protected void fixAxioms() {
        this.fixClassExpressions();
        this.fixPropertyChains();
    }

    public void fixInvalidURIs() {
        Set<Statement> propertyChains = this.statements(null, WRONG_OWL.propertyChain, null).collect(Collectors.toSet());
        propertyChains.forEach(s -> {
            this.getBaseModel().remove(s);
            this.getBaseModel().add(s.getSubject(), OWL.propertyChainAxiom, s.getObject());
        });
        Set<Statement> dataProperties = this.statements(null, RDF.type, (RDFNode)WRONG_OWL.DataProperty).collect(Collectors.toSet());
        dataProperties.forEach(s -> {
            this.getBaseModel().remove(s);
            this.getBaseModel().add(s.getSubject(), RDF.type, (RDFNode)OWL.DatatypeProperty);
        });
    }

    public void fixPropertyChains() {
        Set<Resource> anons = this.statements(null, OWL.propertyChainAxiom, null).map(Statement::getSubject).filter(RDFNode::isAnon).filter(s -> s.hasProperty(RDFS.subPropertyOf) && s.getPropertyResourceValue(RDFS.subPropertyOf).isURIResource()).filter(s -> s.getPropertyResourceValue(OWL.propertyChainAxiom).canAs(RDFList.class)).collect(Collectors.toSet());
        anons.forEach(a -> {
            Resource subj = a.getRequiredProperty(RDFS.subPropertyOf).getObject().asResource();
            Resource obj = a.getRequiredProperty(OWL.propertyChainAxiom).getObject().asResource();
            this.getBaseModel().add(subj, OWL.propertyChainAxiom, (RDFNode)obj);
            this.getBaseModel().removeAll(a, RDFS.subPropertyOf, null);
            this.getBaseModel().removeAll(a, OWL.propertyChainAxiom, null);
        });
    }

    protected void fixClassExpressions() {
        Stream.of(OWL.complementOf, OWL.unionOf, OWL.intersectionOf, OWL.oneOf).forEach(property -> {
            Set<Resource> classes = this.statements(null, (Property)property, null).map(Statement::getSubject).filter(RDFNode::isURIResource).collect(Collectors.toSet());
            classes.forEach(c -> this.moveToEquivalentClass((Resource)c, (Property)property));
        });
        this.fixCardinalityRestrictions();
    }

    protected void moveToEquivalentClass(Resource subject, Property predicate) {
        List<Statement> statements = this.statements(subject, predicate, null).collect(Collectors.toList());
        Model m = this.getBaseModel();
        Resource newRoot = m.createResource();
        newRoot.addProperty(ru.avicomp.ontapi.jena.vocabulary.RDF.type, (RDFNode)OWL.Class);
        m.add(subject, OWL.equivalentClass, (RDFNode)newRoot);
        statements.forEach(s -> newRoot.addProperty(s.getPredicate(), s.getObject()));
        m.remove(statements);
    }

    protected void fixCardinalityRestrictions() {
        Stream.concat(this.statements(null, OWL.onClass, null).filter(s -> !OWL.Thing.equals((Object)s.getObject())), this.statements(null, OWL.onDataRange, null).filter(s -> !RDFS.Literal.equals((Object)s.getObject()))).map(Statement::getSubject).filter(s -> s.hasProperty(ru.avicomp.ontapi.jena.vocabulary.RDF.type, (RDFNode)OWL.Restriction)).forEach(r -> CARDINALITY_PREDICATES.forEach((a, b) -> {
            Statement del = r.getProperty(a, null);
            if (del == null) {
                return;
            }
            r.addProperty(b, del.getObject());
            r.getModel().remove(del);
        }));
    }

    protected void fixNamedIndividuals() {
        Set<Statement> statements = this.statements(null, ru.avicomp.ontapi.jena.vocabulary.RDF.type, null).filter(s -> s.getSubject().isURIResource()).filter(s -> s.getObject().isResource()).filter(s -> !this.builtIn.reservedResources().contains(s.getObject().asResource())).collect(Collectors.toSet());
        statements.forEach(s -> this.declare(s.getSubject(), OWL.NamedIndividual));
    }
}

