/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import ru.avicomp.ontapi.jena.utils.BuiltIn;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.transforms.Transform;

public class OWLIDTransform
extends Transform {
    public OWLIDTransform(Graph graph) {
        super(graph, BuiltIn.DUMMY);
    }

    @Override
    public void perform() {
        Model m = this.getBaseModel();
        Resource ontology = Graphs.ontologyNode(this.getBaseGraph()).map(arg_0 -> ((Model)m).getRDFNode(arg_0)).map(RDFNode::asResource).orElseGet(() -> m.createResource().addProperty(RDF.type, (RDFNode)OWL.Ontology));
        Stream<Resource> other = this.statements(null, RDF.type, (RDFNode)OWL.Ontology).map(Statement::getSubject).filter(s -> !ontology.equals(s));
        List<Statement> rest = other.map(o -> this.statements((Resource)o, null, null)).flatMap(Function.identity()).collect(Collectors.toList());
        rest.forEach(s -> ontology.addProperty(s.getPredicate(), s.getObject()));
        m.remove(rest);
    }
}

