/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.transforms.RecursiveTransform;

public class OWLRecursiveTransform
extends RecursiveTransform {
    private static final Set<Node> ALLOWED_PREDICATES = Stream.of(OWL.differentFrom, OWL.propertyDisjointWith, OWL.disjointWith).map(FrontsNode::asNode).collect(Collectors.toSet());

    public OWLRecursiveTransform(Graph graph) {
        super(graph, false, true);
    }

    @Override
    public Stream<Triple> recursiveTriples() {
        return super.recursiveTriples().filter(t -> !t.getObject().equals((Object)t.getSubject())).filter(t -> Iter.asStream(this.getBaseGraph().find(this.createReplacement(Triple.ANY, n -> this.subject ? t.getSubject() : t.getObject()))).map(Triple::getPredicate).noneMatch(ALLOWED_PREDICATES::contains));
    }
}

