/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import ru.avicomp.ontapi.jena.utils.BuiltIn;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.transforms.Transform;
import ru.avicomp.ontapi.transforms.TransformException;
import ru.avicomp.ontapi.transforms.vocabulary.AVC;

public class RecursiveTransform
extends Transform {
    protected static final int EMERGENCY_EXIT_LIMIT = 10000;
    protected final boolean replace;
    protected final boolean subject;

    public RecursiveTransform(Graph graph, boolean replace, boolean startWithSubject) {
        super(graph, BuiltIn.DUMMY);
        this.replace = replace;
        this.subject = startWithSubject;
    }

    public RecursiveTransform(Graph graph) {
        this(graph, true, true);
    }

    public static Stream<Triple> recursiveTriplesBySubject(Graph graph) {
        return RecursiveTransform.anonymous(graph).filter(t -> RecursiveTransform.testSubject(graph, t.getSubject()));
    }

    public static Stream<Triple> recursiveTriplesByObject(Graph graph) {
        return RecursiveTransform.anonymous(graph).filter(t -> RecursiveTransform.testObject(graph, t.getObject()));
    }

    public static Stream<Triple> anonymous(Graph graph) {
        return Iter.asStream(graph.find(Triple.ANY).filterKeep(t -> t.getSubject().isBlank()).filterKeep(t -> t.getObject().isBlank()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean testSubject(Graph graph, Node test) {
        if (!test.isBlank()) return false;
        if (!RecursiveTransform.objectsBySubject(graph, test, new HashSet<Triple>()).anyMatch(arg_0 -> ((Node)test).equals(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean testObject(Graph graph, Node test) {
        if (!test.isBlank()) return false;
        if (!RecursiveTransform.subjectsByObject(graph, test, new HashSet<Triple>()).anyMatch(arg_0 -> ((Node)test).equals(arg_0))) return false;
        return true;
    }

    private static Stream<Node> objectsBySubject(Graph graph, Node subject, Set<Triple> visited) {
        Set nodes = Iter.asStream(graph.find(subject, Node.ANY, Node.ANY)).filter(visited::add).map(Triple::getObject).filter(Node::isBlank).collect(Collectors.toSet());
        return nodes.stream().flatMap(s -> Stream.concat(Stream.of(s), RecursiveTransform.objectsBySubject(graph, s, visited)));
    }

    private static Stream<Node> subjectsByObject(Graph graph, Node object, Set<Triple> visited) {
        Set nodes = Iter.asStream(graph.find(Node.ANY, Node.ANY, object)).filter(visited::add).map(Triple::getSubject).filter(Node::isBlank).collect(Collectors.toSet());
        return nodes.stream().flatMap(o -> Stream.concat(Stream.of(o), RecursiveTransform.subjectsByObject(graph, o, visited)));
    }

    @Override
    public void perform() {
        Graph graph = this.getBaseGraph();
        Optional<Object> r = Optional.empty();
        int count = 0;
        do {
            if (count++ > 10000) {
                throw new TransformException("To many recursions in the graph");
            }
            r.ifPresent(t -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} [{}]", (Object)(this.replace ? "Replace" : "Delete"), t);
                }
                graph.delete(t);
                if (!this.replace) {
                    return;
                }
                graph.add(this.createReplacement((Triple)t));
            });
        } while ((r = this.recursiveTriples().findFirst()).isPresent());
    }

    public Triple createReplacement(Triple base) {
        return this.createReplacement(base, n -> AVC.error(n).asNode());
    }

    public Triple createReplacement(Triple base, UnaryOperator<Node> mapper) {
        return this.subject ? Triple.create((Node)((Node)mapper.apply(base.getSubject())), (Node)base.getPredicate(), (Node)base.getObject()) : Triple.create((Node)base.getSubject(), (Node)base.getPredicate(), (Node)((Node)mapper.apply(base.getObject())));
    }

    public Stream<Triple> recursiveTriples() {
        return this.subject ? RecursiveTransform.recursiveTriplesBySubject(this.getBaseGraph()) : RecursiveTransform.recursiveTriplesByObject(this.getBaseGraph());
    }
}

