/* CelestaParser.java */
/* Generated By:JavaCC: Do not edit this line. CelestaParser.java */
package ru.curs.celesta.score;

import java.util.List;
import java.util.ArrayList;
import java.io.StringReader;

import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;

import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.validator.IdentifierParser;
import ru.curs.celesta.score.io.Resource;

//CHECKSTYLE:OFF
public class CelestaParser implements CelestaParserConstants {
    public static Expr parseComplexFilter(String filter, IdentifierParser identifierParser) {
        try (StringReader sr = new StringReader(filter)) {
            CelestaParser parser = new CelestaParser(sr);
            return parser.sqlExpression(identifierParser);
        } catch (ParseException e) {
            CelestaException ce = new CelestaException("Invalid complex filter '%s': %s", filter, e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

  final public GrainPart extractGrainInfo(AbstractScore s, Resource r) throws ParseException {Token t;
    boolean isDefinition = false;
    String grainName;
    Grain grain;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CREATE:
    case CELESTA_DOC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CELESTA_DOC:{
        jj_consume_token(CELESTA_DOC);
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      jj_consume_token(K_CREATE);
      jj_consume_token(K_GRAIN);
      t = jj_consume_token(S_IDENTIFIER);
isDefinition = true;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
token_source.SwitchTo(SET_SCHEMA_STATE);
      jj_consume_token(K_GRAIN);
      t = jj_consume_token(S_IDENTIFIER);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
grainName = s.getIdentifierParser().parse(t.toString());
        grain = s.getGrains().get(grainName);

        if (grain == null) grain = new Grain(s, t.toString());

        {if ("" != null) return new GrainPart(grain, isDefinition, r);}
    throw new Error("Missing return statement in function");
}

/*Metamodel. Root rule.*/
  final public Grain parseGrainPart(GrainPart grainPart) throws ParseException {/*This work is dedicated to Maria, my misterious muse :-)
     Ivan Ponomarev, June 2013.*/

   Token t;
   Token doc = null;
   boolean val = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CREATE:
    case CELESTA_DOC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CELESTA_DOC:{
        doc = jj_consume_token(CELESTA_DOC);
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        ;
      }
      jj_consume_token(K_CREATE);
      jj_consume_token(K_GRAIN);
      t = jj_consume_token(S_IDENTIFIER);
if (doc != null) {grainPart.setCelestaDocLexem(doc.toString()); doc = null;}
      jj_consume_token(K_GRAIN_VERSION);
      t = jj_consume_token(S_CHAR_LITERAL);
grainPart.setVersion(t.toString());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        jj_consume_token(K_WITH);
token_source.SwitchTo(OPTIONS_STATE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NO:{
          jj_consume_token(K_NO);
val = false;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        jj_consume_token(K_AUTOUPDATE);
grainPart.setAutoupdate(val);
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
token_source.SwitchTo(SET_SCHEMA_STATE);
      jj_consume_token(K_GRAIN);
      t = jj_consume_token(S_IDENTIFIER);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_END_OF_STATEMENT);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_CREATE:
      case K_EXEC:
      case CELESTA_DOC:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:
      case CELESTA_DOC:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CELESTA_DOC:{
          doc = jj_consume_token(CELESTA_DOC);
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          ;
        }
        jj_consume_token(K_CREATE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLE:{
          createTable(grainPart, doc == null? null: doc.toString());
          break;
          }
        case K_INDEX:{
          createIndex(grainPart, doc == null? null: doc.toString());
          break;
          }
        case K_VIEW:{
          createView(grainPart, doc == null? null: doc.toString());
          break;
          }
        case K_MATERIALIZED:{
          createMaterializedView(grainPart, doc == null? null: doc.toString());
          break;
          }
        case K_FUNCTION:{
          createFunction(grainPart, doc == null? null: doc.toString());
          break;
          }
        case K_SEQUENCE:{
          createSequence(grainPart, doc == null? null: doc.toString());
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
doc = null;
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
        alterTable(grainPart);
        break;
        }
      case K_EXEC:{
        jj_consume_token(K_EXEC);
        executeNativeSql(grainPart);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(K_END_OF_STATEMENT);
    }
    jj_consume_token(0);
{if ("" != null) return grainPart.getGrain();}
    throw new Error("Missing return statement in function");
}

  final public void createTable(GrainPart g, String doc) throws ParseException {TableBuilder table = null;
        Token t = null;
    boolean val = true;
    jj_consume_token(K_TABLE);
    t = jj_consume_token(S_IDENTIFIER);
table = new TableBuilder(g, t.toString());
                            table.setCelestaDocLexem(doc);
    jj_consume_token(100);
    tableConstituent(table);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_2;
      }
      jj_consume_token(101);
      tableConstituent(table);
    }
    jj_consume_token(102);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
token_source.SwitchTo(OPTIONS_STATE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_READ:{
        jj_consume_token(K_READ);
        jj_consume_token(K_ONLY);
table.setVersioned(false);
                                  table.setReadOnly(true);
        break;
        }
      case K_NO:
      case K_VERSION:
      case K_AUTOUPDATE:{
        label_3:
        while (true) {
val = true;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NO:{
            jj_consume_token(K_NO);
val = false;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VERSION:{
            jj_consume_token(K_VERSION);
            jj_consume_token(K_CHECK);
table.setVersioned(val);
            break;
            }
          case K_AUTOUPDATE:{
            jj_consume_token(K_AUTOUPDATE);
table.setAutoUpdate(val);
            break;
            }
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NO:
          case K_VERSION:
          case K_AUTOUPDATE:{
            ;
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            break label_3;
          }
        }
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
table.build();
}

  final public void tableConstituent(TableBuilder table) throws ParseException {String name;
  TableBuilder.ForeignKeyBuilder fk;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case CELESTA_DOC:{
      columnDefinition(table);
      break;
      }
    case K_CONSTRAINT:
    case K_FOREIGN:
    case K_PRIMARY:{
      name = constraint(table.getGrain());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRIMARY:{
        primaryKey(table);
table.setPkConstraintName(name);
        break;
        }
      case K_FOREIGN:{
        fk = foreignKey(table);
fk.setConstraintName(name);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void columnDefinition(TableBuilder table) throws ParseException {TableBuilder.ColumnBuilder column = null;
   Token t;
   Token length = null;
   boolean nullable;
   boolean negative = false;
   boolean pk = false;
   TableBuilder.ForeignKeyBuilder fk = null;
   String name;
   Token doc = null;
   SequenceElement sequence = null;
   String defaultValue = null;
   Token precision = null;
   Token scale = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CELESTA_DOC:{
      doc = jj_consume_token(CELESTA_DOC);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    t = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INT:{
      jj_consume_token(K_INT);
column = table.integerColumn(t.toString()); t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_INTEGER:
        case T_MINUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case T_MINUS:{
            jj_consume_token(T_MINUS);
negative = true;
            break;
            }
          default:
            jj_la1[19] = jj_gen;
            ;
          }
          t = jj_consume_token(S_INTEGER);
defaultValue = (negative? "-": "") + t.toString();
          break;
          }
        case K_NEXTVAL:{
          defaultValue = sequenceNextVal();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
            jj_consume_token(K_NULL);
nullable = false;
            break;
            }
          default:
            jj_la1[20] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      break;
      }
    case K_REAL:{
      jj_consume_token(K_REAL);
column = table.floatingColumn(t.toString()); t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case T_MINUS:{
          jj_consume_token(T_MINUS);
negative = true;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_INTEGER:{
          t = jj_consume_token(S_INTEGER);
          break;
          }
        case S_DOUBLE:{
          t = jj_consume_token(S_DOUBLE);
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
defaultValue = (negative? "-": "") + t.toString();
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      break;
      }
    case K_DECIMAL:{
      jj_consume_token(K_DECIMAL);
      jj_consume_token(100);
      precision = jj_consume_token(S_INTEGER);
      jj_consume_token(101);
      scale = jj_consume_token(S_INTEGER);
      jj_consume_token(102);
column = table.decimalColumn(
                t.toString(), Integer.parseInt(precision.toString()), Integer.parseInt(scale.toString())
            );
            t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case T_MINUS:{
          jj_consume_token(T_MINUS);
negative = true;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          ;
        }
        t = jj_consume_token(S_DOUBLE);
defaultValue = (negative? "-": "") + t.toString();
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      break;
      }
    case K_VARCHAR:{
      jj_consume_token(K_VARCHAR);
column = table.stringColumn(t.toString()); t = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 100:{
        jj_consume_token(100);
        length = jj_consume_token(S_INTEGER);
        jj_consume_token(102);
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
column.setLength(length.toString());
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        t = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
      }
    case K_TEXT:{
      jj_consume_token(K_TEXT);
column = table.stringColumn(t.toString());
                      column.setLength("MAX");
                                  t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        t = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      break;
      }
    case K_BLOB:{
      jj_consume_token(K_BLOB);
column = table.binaryColumn(t.toString()); t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        t = jj_consume_token(S_BINARY_LITERAL);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      break;
      }
    case K_DATETIME:{
      jj_consume_token(K_DATETIME);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        jj_consume_token(K_WITH);
token_source.SwitchTo(DATETIME_STATE);
        jj_consume_token(K_TIME);
        jj_consume_token(K_ZONE);
column = table.zonedDateTimeColumn(t.toString());
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        ;
      }
if (column == null) {
                column = table.dateTimeColumn(t.toString());
            }
            t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          t = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case K_GETDATE:{
          t = jj_consume_token(K_GETDATE);
          jj_consume_token(100);
          jj_consume_token(102);
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      break;
      }
    case K_BIT:{
      jj_consume_token(K_BIT);
column = table.booleanColumn(t.toString()); t = null;
      nullable = nullable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          t = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_INTEGER:{
          t = jj_consume_token(S_INTEGER);
          break;
          }
        case K_FALSE:{
          t = jj_consume_token(K_FALSE);
          break;
          }
        case K_TRUE:{
          t = jj_consume_token(K_TRUE);
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = constraint(table.getGrain());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PRIMARY:{
      jj_consume_token(K_PRIMARY);
      jj_consume_token(K_KEY);
pk = true; table.setPkConstraintName(name);
      name = constraint(table.getGrain());
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
column.setNullableAndDefault(nullable, defaultValue != null ? defaultValue : t == null ? null :  t.toString());
          column.setCelestaDocLexem(doc == null? null:doc.toString());

          if (pk) {
            table.addPK(column.getName());
            table.finalizePK();
          }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOREIGN:{
      jj_consume_token(K_FOREIGN);
      jj_consume_token(K_KEY);
fk = table.foreignKey(); fk.addColumn(column.getName()); fk.setConstraintName(name);
      references(fk);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
}

  final public boolean nullable() throws ParseException {boolean result = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:
    case K_NULL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
result = true;
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_NULL);
result = false;
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public void primaryKey(TableBuilder table) throws ParseException {Token t;
  IdentifierParser identifierParser = table.getGrain().getScore().getIdentifierParser();
    jj_consume_token(K_PRIMARY);
    jj_consume_token(K_KEY);
    jj_consume_token(100);
    t = jj_consume_token(S_IDENTIFIER);
table.addPK(t.toString());
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        break label_4;
      }
      jj_consume_token(101);
      t = jj_consume_token(S_IDENTIFIER);
table.addPK(t.toString());
    }
    jj_consume_token(102);
table.finalizePK();
}

  final public TableBuilder.ForeignKeyBuilder foreignKey(TableBuilder table) throws ParseException {Token t;
  TableBuilder.ForeignKeyBuilder fk;
    jj_consume_token(K_FOREIGN);
    jj_consume_token(K_KEY);
fk = table.foreignKey();
    jj_consume_token(100);
    t = jj_consume_token(S_IDENTIFIER);
fk.addColumn(t.toString());
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_5;
      }
      jj_consume_token(101);
      t = jj_consume_token(S_IDENTIFIER);
fk.addColumn(t.toString());
    }
    jj_consume_token(102);
    references(fk);
{if ("" != null) return fk;}
    throw new Error("Missing return statement in function");
}

  final public void references(TableBuilder.ForeignKeyBuilder fk) throws ParseException {Token t;
  Token t2 = null;
  FKRule action;
    jj_consume_token(K_REFERENCES);
    t = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 103:{
      jj_consume_token(103);
      t2 = jj_consume_token(S_IDENTIFIER);
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      ;
    }
if (t2 == null)
      fk.setReferencedTable("", t.toString());
        else
          fk.setReferencedTable(t.toString(), t2.toString());
    jj_consume_token(100);
    t = jj_consume_token(S_IDENTIFIER);
fk.addReferencedColumn(t.toString());
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_6;
      }
      jj_consume_token(101);
      t = jj_consume_token(S_IDENTIFIER);
fk.addReferencedColumn(t.toString());
    }
    jj_consume_token(102);
fk.finalizeReference();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_UPDATE:{
        jj_consume_token(K_UPDATE);
        action = action();
fk.setUpdateRule(action);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:{
          jj_consume_token(K_ON);
          jj_consume_token(K_DELETE);
          action = action();
fk.setDeleteRule(action);
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          ;
        }
        break;
        }
      case K_DELETE:{
        jj_consume_token(K_DELETE);
        action = action();
fk.setDeleteRule(action);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:{
          jj_consume_token(K_ON);
          jj_consume_token(K_UPDATE);
          action = action();
fk.setUpdateRule(action);
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
}

  final public FKRule action() throws ParseException {FKRule result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
result = FKRule.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      jj_consume_token(K_NULL);
result =  FKRule.SET_NULL;
      break;
      }
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
result =  FKRule.CASCADE;
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public void createIndex(GrainPart g, String doc) throws ParseException {Token indexName;
Token tableName;
Token columnName;
Index ind;
    jj_consume_token(K_INDEX);
    indexName = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(K_ON);
    tableName = jj_consume_token(S_IDENTIFIER);
ind = new Index(g, tableName.toString(), indexName.toString());
    ind.setCelestaDocLexem(doc);
    jj_consume_token(100);
    columnName = jj_consume_token(S_IDENTIFIER);
ind.addColumn(columnName.toString());
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        break label_7;
      }
      jj_consume_token(101);
      columnName = jj_consume_token(S_IDENTIFIER);
ind.addColumn(columnName.toString());
    }
    jj_consume_token(102);
ind.finalizeIndex();
}

  final public void alterTable(GrainPart g) throws ParseException {Token t;
  BasicTable table;
  TableBuilder tb;
  String name;
  TableBuilder.ForeignKeyBuilder fk;
  IdentifierParser identifierParser =  g.getGrain().getScore().getIdentifierParser();
    jj_consume_token(K_TABLE);
    t = jj_consume_token(S_IDENTIFIER);
table = g.getGrain().getElement(identifierParser.parse(t.toString()), BasicTable.class);
    jj_consume_token(K_ADD);
    name = constraint(g.getGrain());
    fk = foreignKey(tb = new TableBuilder(table));
fk.setConstraintName(name);
    tb.build();
}

  final public String constraint(Grain g) throws ParseException {Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CONSTRAINT:{
      jj_consume_token(K_CONSTRAINT);
      t = jj_consume_token(S_IDENTIFIER);
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
if (t == null)
  {if ("" != null) return null;}
else {
  g.addConstraintName(t.toString());
  {if ("" != null) return t.toString();}
}
    throw new Error("Missing return statement in function");
}

  final public void createView(GrainPart g, String doc) throws ParseException {View view = null;
        Token viewName = null;
    jj_consume_token(K_VIEW);
    viewName = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(K_AS);
view = new View(g, viewName.toString());
            view.setCelestaDocLexem(doc);
    unionAll(view);
}

  final public void unionAll(View view) throws ParseException {AbstractSelectStmt selectStmt = view.addSelectStatement();
    select(selectStmt);
selectStmt.finalizeParsing();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_UNION:{
        ;
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        break label_8;
      }
      jj_consume_token(K_UNION);
      jj_consume_token(K_ALL);
selectStmt = view.addSelectStatement();
      select(selectStmt);
selectStmt.finalizeParsing();
    }
view.finalizeParsing();
}

  final public void createMaterializedView(GrainPart g, String doc) throws ParseException {MaterializedView view = null;
    Token viewName = null;
    AbstractSelectStmt selectStmt = null;
    jj_consume_token(K_MATERIALIZED);
    jj_consume_token(K_VIEW);
    viewName = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(K_AS);
view = new MaterializedView(g, viewName.toString());
        view.setCelestaDocLexem(doc);
        selectStmt = view.addSelectStatement();
    materializedSelect(selectStmt);
selectStmt.finalizeParsing();
     view.finalizeParsing();
}

  final public void createFunction(GrainPart g, String doc) throws ParseException {ParameterizedView v = null;
    Token viewName = null;
    jj_consume_token(K_FUNCTION);
    viewName = jj_consume_token(S_IDENTIFIER);
v = new ParameterizedView(g, viewName.toString());
        v.setCelestaDocLexem(doc);
    jj_consume_token(100);
    functionParam(v);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        break label_9;
      }
      jj_consume_token(101);
      functionParam(v);
    }
    jj_consume_token(102);
    jj_consume_token(K_AS);
    unionAll(v);
}

  final public void createSequence(GrainPart g, String doc) throws ParseException {SequenceElement s = null;
    Token name = null;
    jj_consume_token(K_SEQUENCE);
    name = jj_consume_token(S_IDENTIFIER);
s = new SequenceElement(g, name.toString());
        s.setCelestaDocLexem(doc);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SEQUENCE_CYCLE:
      case K_SEQUENCE_MAXVALUE:
      case K_SEQUENCE_MINVALUE:
      case K_SEQUENCE_START:
      case K_SEQUENCE_INCREMENT:{
        ;
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SEQUENCE_START:{
        sequenceStartWith(s);
        break;
        }
      case K_SEQUENCE_INCREMENT:{
        sequenceIncrementBy(s);
        break;
        }
      case K_SEQUENCE_MINVALUE:{
        sequenceMinValue(s);
        break;
        }
      case K_SEQUENCE_MAXVALUE:{
        sequenceMaxValue(s);
        break;
        }
      case K_SEQUENCE_CYCLE:{
        sequenceCycle(s);
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
s.finalizeParsing();
}

  final public void sequenceStartWith(SequenceElement s) throws ParseException {long val;
    jj_consume_token(K_SEQUENCE_START);
    jj_consume_token(K_WITH);
    val = signedInteger();
s.startWith(val);
}

  final public void sequenceIncrementBy(SequenceElement s) throws ParseException {long val;
    jj_consume_token(K_SEQUENCE_INCREMENT);
    jj_consume_token(K_BY);
    val = signedInteger();
s.incrementBy(val);
}

  final public long signedInteger() throws ParseException {int sign = 1; Token val;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case T_MINUS:{
      jj_consume_token(T_MINUS);
sign = -1;
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    val = jj_consume_token(S_INTEGER);
{if ("" != null) return sign * Long.parseLong(val.image);}
    throw new Error("Missing return statement in function");
}

  final public void sequenceMinValue(SequenceElement s) throws ParseException {long val;
    jj_consume_token(K_SEQUENCE_MINVALUE);
    val = signedInteger();
s.minValue(val);
}

  final public void sequenceMaxValue(SequenceElement s) throws ParseException {long val;
    jj_consume_token(K_SEQUENCE_MAXVALUE);
    val = signedInteger();
s.maxValue(val);
}

  final public void sequenceCycle(SequenceElement s) throws ParseException {
    jj_consume_token(K_SEQUENCE_CYCLE);
s.setIsCycle(true);
}

  final public void functionParam(ParameterizedView view) throws ParseException {Token doc = null;
    Token t;
    Parameter p;
    String name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CELESTA_DOC:{
      doc = jj_consume_token(CELESTA_DOC);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    t = jj_consume_token(S_IDENTIFIER);
name = t.toString();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INT:{
      jj_consume_token(K_INT);
p = new Parameter(name, ViewColumnType.INT);
      break;
      }
    case K_REAL:{
      jj_consume_token(K_REAL);
p = new Parameter(name, ViewColumnType.REAL);
      break;
      }
    case K_DECIMAL:{
      jj_consume_token(K_DECIMAL);
p = new Parameter(name, ViewColumnType.DECIMAL);
      break;
      }
    case K_VARCHAR:{
      jj_consume_token(K_VARCHAR);
p = new Parameter(name, ViewColumnType.TEXT);
      break;
      }
    case K_TEXT:{
      jj_consume_token(K_TEXT);
p = new Parameter(name, ViewColumnType.TEXT);
      break;
      }
    case K_DATETIME:{
      jj_consume_token(K_DATETIME);
p = new Parameter(name, ViewColumnType.DATE);
      break;
      }
    case K_BIT:{
      jj_consume_token(K_BIT);
p = new Parameter(name, ViewColumnType.BIT);
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
p.setCelestaDocLexem(doc == null? null:doc.toString());
        view.addParameter(p);
}

  final public Expr sqlExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
  List<Expr> operands = new ArrayList<Expr>(5);
    result = sqlAndExpression(identifierParser);
operands.add(result);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OR:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_11;
      }
      jj_consume_token(K_OR);
      result = sqlAndExpression(identifierParser);
operands.add(result);
    }
{if ("" != null) return operands.size() == 1? result : new BinaryLogicalOp(BinaryLogicalOp.OR, operands);}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlAndExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
  List<Expr> operands = new ArrayList<Expr>(5);
    result = sqlUnaryLogicalExpression(identifierParser);
operands.add(result);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_12;
      }
      jj_consume_token(K_AND);
      result = sqlUnaryLogicalExpression(identifierParser);
operands.add(result);
    }
{if ("" != null) return operands.size() == 1? result : new BinaryLogicalOp(BinaryLogicalOp.AND, operands);}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlUnaryLogicalExpression(IdentifierParser identifierParser) throws ParseException {boolean isNot = false;
  Expr result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
isNot = true;
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    result = sqlRelationalExpression(identifierParser);
{if ("" != null) return isNot? new NotExpr(result) : result;}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlRelationalExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
  Expr buf1;
  Expr buf2;
  List<Expr> operands = new ArrayList<Expr>(5);
  int relop;
    result = sqlTermExpr(identifierParser);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:
    case K_IN:
    case K_IS:
    case K_LIKE:
    case 104:
    case 105:
    case 106:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 104:
      case 105:
      case 106:{
        relop = relop();
        buf1 = sqlTermExpr(identifierParser);
result = new Relop(result, buf1, relop);
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
        jj_consume_token(100);
        buf1 = sqlTermExpr(identifierParser);
operands.add(buf1);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 101:{
            ;
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            break label_13;
          }
          jj_consume_token(101);
          buf1 = sqlTermExpr(identifierParser);
operands.add(buf1);
        }
        jj_consume_token(102);
result = new In(result, operands);
        break;
        }
      case K_BETWEEN:{
        jj_consume_token(K_BETWEEN);
        buf1 = sqlTermExpr(identifierParser);
        jj_consume_token(K_AND);
        buf2 = sqlTermExpr(identifierParser);
result = new Between(result, buf1, buf2);
        break;
        }
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        buf1 = sqlTermExpr(identifierParser);
result = new Relop(result, buf1, Relop.LIKE);
        break;
        }
      case K_IS:{
        jj_consume_token(K_IS);
        jj_consume_token(K_NULL);
result = new IsNull(result);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public int relop() throws ParseException {int result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 104:{
      jj_consume_token(104);
result = Relop.EQ;
      break;
      }
    case 105:{
      jj_consume_token(105);
result = Relop.GT;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 104:{
        jj_consume_token(104);
result = Relop.GTEQ;
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        ;
      }
      break;
      }
    case 106:{
      jj_consume_token(106);
result = Relop.LS;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 104:
      case 105:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 104:{
          jj_consume_token(104);
result = Relop.LSEQ;
          break;
          }
        case 105:{
          jj_consume_token(105);
result = Relop.NTEQ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlTermExpr(IdentifierParser identifierParser) throws ParseException {Expr result;
  List<Expr> operands = new ArrayList<Expr>(5);
  int operator = -1;
    result = sqlMultiplicativeExpression(identifierParser);
operands.add(result);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case T_MINUS:
      case 107:
      case 108:{
        ;
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 107:{
        jj_consume_token(107);
operator = BinaryTermOp.PLUS;
        break;
        }
      case T_MINUS:{
        jj_consume_token(T_MINUS);
operator = BinaryTermOp.MINUS;
        break;
        }
      case 108:{
        jj_consume_token(108);
operator = BinaryTermOp.CONCAT;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      result = sqlMultiplicativeExpression(identifierParser);
operands.add(result);
    }
{if ("" != null) return operands.size() == 1? result : new BinaryTermOp(operator, operands);}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlMultiplicativeExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
  List<Expr> operands = new ArrayList<Expr>(5);
  int operator = -1;
    result = sqlUnaryExpression(identifierParser);
operands.add(result);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 109:
      case 110:{
        ;
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 109:{
        jj_consume_token(109);
operator = BinaryTermOp.TIMES;
        break;
        }
      case 110:{
        jj_consume_token(110);
operator = BinaryTermOp.OVER;
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      result = sqlUnaryExpression(identifierParser);
operands.add(result);
    }
{if ("" != null) return operands.size() == 1? result : new BinaryTermOp(operator, operands);}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlUnaryExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
boolean isMinus = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case T_MINUS:{
      jj_consume_token(T_MINUS);
isMinus = true;
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    result = sqlPrimaryExpression(identifierParser);
{if ("" != null) return isMinus? new UnaryMinus(result) : result;}
    throw new Error("Missing return statement in function");
}

  final public Expr sqlPrimaryExpression(IdentifierParser identifierParser) throws ParseException {Expr result;
Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_INTEGER:{
      t = jj_consume_token(S_INTEGER);
result = new IntegerLiteral(t.toString());
      break;
      }
    case S_DOUBLE:{
      t = jj_consume_token(S_DOUBLE);
result = new RealLiteral(t.toString());
      break;
      }
    case S_CHAR_LITERAL:{
      t = jj_consume_token(S_CHAR_LITERAL);
result = new TextLiteral(t.toString());
      break;
      }
    case S_PARAM:{
      t = jj_consume_token(S_PARAM);
result = new ParameterRef(t.toString().substring(1));
      break;
      }
    case K_TRUE:{
      t = jj_consume_token(K_TRUE);
result = new BooleanLiteral(true);
      break;
      }
    case K_FALSE:{
      t = jj_consume_token(K_FALSE);
result = new BooleanLiteral(false);
      break;
      }
    case K_GETDATE:{
      jj_consume_token(K_GETDATE);
      jj_consume_token(100);
      jj_consume_token(102);
result = new GetDate();
      break;
      }
    case 100:{
      jj_consume_token(100);
      result = sqlExpression(identifierParser);
      jj_consume_token(102);
result = new ParenthesizedExpr(result);
      break;
      }
    case S_IDENTIFIER:{
      result = fieldReference(identifierParser);
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public FieldRef fieldReference(IdentifierParser identifierParser) throws ParseException {String tableName = null;
  String fieldName;
  Token t;
    t = jj_consume_token(S_IDENTIFIER);
fieldName = identifierParser.parse(t.toString());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 103:{
      jj_consume_token(103);
      t = jj_consume_token(S_IDENTIFIER);
tableName = fieldName; fieldName = identifierParser.parse(t.toString());
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
{if ("" != null) return new FieldRef(tableName, fieldName);}
    throw new Error("Missing return statement in function");
}

  final public void select(AbstractSelectStmt v) throws ParseException {Expr where;
    jj_consume_token(K_SELECT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
v.setDistinct(true);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    selectItem(v);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_16;
      }
      jj_consume_token(101);
      selectItem(v);
    }
    jj_consume_token(K_FROM);
    fromClause(v);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      where = sqlExpression(v.getGrain().getScore().getIdentifierParser());
v.setWhereCondition(where);
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GROUP:{
      jj_consume_token(K_GROUP);
      jj_consume_token(K_BY);
      groupBy(v);
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
}

  final public void materializedSelect(AbstractSelectStmt v) throws ParseException {
    jj_consume_token(K_SELECT);
    materializedSelectItem(v);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_17;
      }
      jj_consume_token(101);
      materializedSelectItem(v);
    }
    jj_consume_token(K_FROM);
    fromClause(v);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GROUP:{
      jj_consume_token(K_GROUP);
      jj_consume_token(K_BY);
      groupBy(v);
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
}

  final public void groupBy(AbstractSelectStmt view) throws ParseException {FieldRef fr;
    fr = fieldReference(view.getGrain().getScore().getIdentifierParser());
view.addGroupByColumn(fr);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 101:{
        ;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_18;
      }
      jj_consume_token(101);
      fr = fieldReference(view.getGrain().getScore().getIdentifierParser());
view.addGroupByColumn(fr);
    }
}

  final public Expr aggregateFunc(AbstractSelectStmt v) throws ParseException {Expr term;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COUNT:{
      jj_consume_token(K_COUNT);
      jj_consume_token(100);
      jj_consume_token(109);
      jj_consume_token(102);
{if ("" != null) return new Count();}
      break;
      }
    case K_SUM:{
      jj_consume_token(K_SUM);
      jj_consume_token(100);
      term = sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
      jj_consume_token(102);
{if ("" != null) return new Sum(term);}
      break;
      }
    case K_MAX:{
      jj_consume_token(K_MAX);
      jj_consume_token(100);
      term = sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
      jj_consume_token(102);
{if ("" != null) return new Max(term);}
      break;
      }
    case K_MIN:{
      jj_consume_token(K_MIN);
      jj_consume_token(100);
      term = sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
      jj_consume_token(102);
{if ("" != null) return new Min(term);}
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Expr materializedAggregateFunc(AbstractSelectStmt v) throws ParseException {Expr term;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COUNT:{
      jj_consume_token(K_COUNT);
      jj_consume_token(100);
      jj_consume_token(109);
      jj_consume_token(102);
{if ("" != null) return new Count();}
      break;
      }
    case K_SUM:{
      jj_consume_token(K_SUM);
      jj_consume_token(100);
      term = fieldReference(v.getGrain().getScore().getIdentifierParser());
      jj_consume_token(102);
{if ("" != null) return new Sum(term);}
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public void selectItem(AbstractSelectStmt v) throws ParseException {Token doc = null;
  Token aliasToken = null;
  String alias = "";
  Expr expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CELESTA_DOC:{
      doc = jj_consume_token(CELESTA_DOC);
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_GETDATE:
    case K_TRUE:
    case S_DOUBLE:
    case S_INTEGER:
    case T_MINUS:
    case S_IDENTIFIER:
    case S_PARAM:
    case S_CHAR_LITERAL:
    case 100:{
      expr = sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
      break;
      }
    case K_COUNT:
    case K_MAX:
    case K_MIN:
    case K_SUM:{
      expr = aggregateFunc(v);
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      aliasToken = jj_consume_token(S_IDENTIFIER);
alias = aliasToken.toString();
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
if (alias.isEmpty() && expr instanceof FieldRef)
                   alias = ((FieldRef) expr).getColumnName();
     if (doc != null)
        expr.getMeta().setCelestaDocLexem(doc.toString());
     v.addColumn(alias, expr);
}

  final public void materializedSelectItem(AbstractSelectStmt v) throws ParseException {Token doc = null;
  Token aliasToken = null;
  String alias = "";
  Expr expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CELESTA_DOC:{
      doc = jj_consume_token(CELESTA_DOC);
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      expr = fieldReference(v.getGrain().getScore().getIdentifierParser());
      break;
      }
    case K_COUNT:
    case K_SUM:{
      expr = materializedAggregateFunc(v);
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      aliasToken = jj_consume_token(S_IDENTIFIER);
alias = aliasToken.toString();
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      ;
    }
if (alias.isEmpty() && expr instanceof FieldRef)
                   alias = ((FieldRef) expr).getColumnName();
     if (doc != null)
        expr.getMeta().setCelestaDocLexem(doc.toString());
     v.addColumn(alias, expr);
}

  final public TableRef tableReference(AbstractSelectStmt v) throws ParseException {TableRef result;
  Token t;
  String grainName = null;
  String tableName = null;
  String alias;
  IdentifierParser identifierParser = v.getGrain().getScore().getIdentifierParser();
    t = jj_consume_token(S_IDENTIFIER);
tableName = t.toString(); alias = tableName;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 103:{
      jj_consume_token(103);
      t = jj_consume_token(S_IDENTIFIER);
grainName = tableName; tableName = t.toString(); alias = tableName;
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      t = jj_consume_token(S_IDENTIFIER);
alias = t.toString();
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
BasicTable tab;
     if (grainName == null) {
            tab = v.getGrain().getElement(identifierParser.parse(tableName), BasicTable.class);
         } else {
            tab = v.getGrain().getScore().getGrainAsDependency(v.getGrain(), grainName).getElement(identifierParser.parse(tableName), BasicTable.class);
         }
         {if ("" != null) return new TableRef(tab, identifierParser.parse(alias));}
    throw new Error("Missing return statement in function");
}

  final public String sequenceNextVal() throws ParseException {Token t;
  String sequenceName = null;
    jj_consume_token(K_NEXTVAL);
    jj_consume_token(100);
    t = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(102);
sequenceName = t.toString();
    {if ("" != null) return "NEXTVAL(" + sequenceName + ")";}
    throw new Error("Missing return statement in function");
}

  final public void fromClause(AbstractSelectStmt v) throws ParseException {TableRef tRef;
    tRef = tableReference(v);
v.addFromTableRef(tRef);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INNER:
      case K_LEFT:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        break label_19;
      }
      tRef = join(v);
v.addFromTableRef(tRef);
    }
}

  final public TableRef join(AbstractSelectStmt v) throws ParseException {TableRef tRef;
  TableRef.JoinType jt;
  Expr onExpr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INNER:{
      jj_consume_token(K_INNER);
jt = TableRef.JoinType.INNER;
      break;
      }
    case K_LEFT:{
      jj_consume_token(K_LEFT);
jt = TableRef.JoinType.LEFT;
      break;
      }
    case K_RIGHT:{
      jj_consume_token(K_RIGHT);
jt = TableRef.JoinType.RIGHT;
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_JOIN);
    tRef = tableReference(v);
    jj_consume_token(K_ON);
    onExpr = sqlExpression(v.getGrain().getScore().getIdentifierParser());
tRef.setJoinType(jt);
     tRef.setOnExpr(onExpr);
         {if ("" != null) return tRef;}
    throw new Error("Missing return statement in function");
}

  final public void executeNativeSql(GrainPart g) throws ParseException {Token sql;
    boolean isBefore = false;
    Token dbType;
    jj_consume_token(K_NATIVE);
    dbType = jj_consume_token(K_DBTYPE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BEFORE:{
      jj_consume_token(K_BEFORE);
isBefore = true;
      break;
      }
    case K_AFTER:{
      jj_consume_token(K_AFTER);
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    sql = jj_consume_token(NATIVE_SQL);
g.getGrain().addNativeSql(
            sql.toString(),
            isBefore,
            DBType.getByNameIgnoreCase(dbType.toString()),
            g
        );
}

  /** Generated Token Manager. */
  public CelestaParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[100];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x8000,0x0,0x0,0x0,0x8000,0x88080,0x0,0x0,0x88080,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x202000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x0,0x10000,0x0,0x10000,0x10000,0x10000,0x0,0x1000000,0x10000,0x100000,0x10000,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x1000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x14000400,0x14000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1100000,0x0,0x40000,0x0,0x0,0x2000000,0x0,0x2000000,0x0,0x4000,0x4000,0x0,0x1104000,0x200,0x0,0x0,0x4000,0x200,0x0,0x0,0x200,0x0,0x88000000,0x88000000,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x2000,0x0,0x10,0x40000,0x2000,0x0,0x0,0xfc00000,0x0,0x0,0x10,0x0,0x10,0x10,0x40000,0x200,0x200,0x0,0x0,0x20,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x10000,0x0,0x8000,0x200,0x0,0x60,0x60,0x0,0x0,0x0,0x0,0x80,0x80,0x20000,0x80,0x2010,0x0,0x0,0x100000,0x0,0x80000000,0x80000000,0x0,0x0,0x8000,0x100,0x0,0x20,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x4006,0x4000,0x0,0x14006,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x140,0x140,0x150,0x0,0x0,0x10000000,0x0,0x8000000,0x0,0x9000000,0x0,0x8000000,0x1800000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x81000000,0x0,0x7f0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xf,0x8000000,0x0,0x6f0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x8000000,0xb1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb9800000,0x0,0x10000000,0x0,0x10000000,0x0,0x10000000,0x0,0x0,0x10000000,0x0,0x0,0x3000,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x2,0x2,0x2,0x0,0x0,0x2,0x2,0x2,0x0,0x2,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x80,0x20,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x20,0x700,0x700,0x100,0x300,0x300,0x700,0x1800,0x1800,0x6000,0x6000,0x0,0x10,0x80,0x0,0x20,0x0,0x0,0x20,0x0,0x20,0x0,0x0,0x2,0x10,0x0,0x0,0x2,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,};
	}

  /** Constructor with InputStream. */
  public CelestaParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CelestaParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new CelestaParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public CelestaParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CelestaParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CelestaParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public CelestaParser(CelestaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(CelestaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 100; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[111];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 100; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 111; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
