/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaConnection;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.PasswordHider;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;

public final class ConnectionPool
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPool.class);
    private final ConcurrentLinkedQueue<CelestaConnection> pool = new ConcurrentLinkedQueue();
    private final String jdbcConnectionUrl;
    private final String driverClassName;
    private final String login;
    private final String password;
    private DBAdaptor dbAdaptor;
    private volatile boolean isClosed;

    private ConnectionPool(String jdbcConnectionUrl, String driverClassName, String login, String password) {
        this.driverClassName = driverClassName;
        this.login = login;
        this.password = password;
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public static ConnectionPool create(ConnectionPoolConfiguration configuration) {
        return new ConnectionPool(configuration.getJdbcConnectionUrl(), configuration.getDriverClassName(), configuration.getLogin(), configuration.getPassword());
    }

    public void setDbAdaptor(DBAdaptor dbAdaptor) {
        this.dbAdaptor = dbAdaptor;
    }

    public Connection get() {
        if (this.isClosed) {
            throw new CelestaException("ConnectionPool is closed");
        }
        Connection c = this.pool.poll();
        while (c != null) {
            try {
                if (this.dbAdaptor.isValidConnection(c, 1)) {
                    return c;
                }
            }
            catch (CelestaException e) {
                c = null;
            }
            c = this.pool.poll();
        }
        try {
            Class.forName(this.driverClassName);
            c = this.login.isEmpty() ? DriverManager.getConnection(this.jdbcConnectionUrl) : DriverManager.getConnection(this.jdbcConnectionUrl, this.login, this.password);
            c.setAutoCommit(false);
            CelestaConnection celestaConnection = new CelestaConnection(c){

                @Override
                public void close() {
                    try {
                        if (ConnectionPool.this.isClosed) {
                            this.getConnection().close();
                        } else {
                            this.commit();
                            ConnectionPool.this.pool.add(this);
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.error("Error on connection closing", (Throwable)ex);
                    }
                }
            };
            return celestaConnection;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new CelestaException("Could not connect to %s with error: %s", PasswordHider.maskPassword(this.jdbcConnectionUrl), e.getMessage());
        }
    }

    public void commit(Connection conn) {
        try {
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            return;
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            CelestaConnection c;
            this.isClosed = true;
            while ((c = this.pool.poll()) != null) {
                c.close();
            }
        }
    }

    public Object poolSize() {
        return this.pool.size();
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

