/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PasswordHider {
    private static final Pattern ORA_PATTERN = Pattern.compile("/[^@]+@");
    private static final Pattern MSSQL_PATTERN = Pattern.compile("(password)=([^{;]|(\\{(;\\})|[^;]?))+(;|$)", 2);
    private static final Pattern POSTGRESQL_PATTERN = Pattern.compile("(password)=[^&]+(&|$)", 2);
    private static final Pattern GENERIC_PATTERN = Pattern.compile("(password)=.+$", 2);

    private PasswordHider() {
    }

    public static String maskPassword(String url) {
        Matcher m;
        if (url == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (url.toLowerCase().startsWith("jdbc:oracle")) {
            m = ORA_PATTERN.matcher(url);
            while (m.find()) {
                m.appendReplacement(sb, "/*****@");
            }
        } else if (url.toLowerCase().startsWith("jdbc:sqlserver")) {
            m = MSSQL_PATTERN.matcher(url);
            while (m.find()) {
                m.appendReplacement(sb, m.group(1) + "=*****" + m.group(5));
            }
        } else if (url.toLowerCase().startsWith("jdbc:postgresql")) {
            m = POSTGRESQL_PATTERN.matcher(url);
            while (m.find()) {
                m.appendReplacement(sb, m.group(1) + "=*****" + m.group(2));
            }
        } else {
            m = GENERIC_PATTERN.matcher(url);
            while (m.find()) {
                m.appendReplacement(sb, m.group(1) + "=*****");
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

