/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.h2.value.DataType;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.OpenSourceDbAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.ddl.H2DdlGenerator;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;

public final class H2Adaptor
extends OpenSourceDbAdaptor {
    private static final Pattern HEX_STRING = Pattern.compile("X'([0-9A-Fa-f]+)'");

    public H2Adaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer, boolean isH2ReferentialIntegrity) {
        super(connectionPool, ddlConsumer);
        this.configureDb(isH2ReferentialIntegrity);
    }

    @Override
    DdlGenerator getDdlGenerator() {
        return new H2DdlGenerator(this);
    }

    private void configureDb(boolean isH2ReferentialIntegrity) {
        try (Connection connection = this.connectionPool.get();){
            String sql = "SET REFERENTIAL_INTEGRITY " + String.valueOf(isH2ReferentialIntegrity);
            try (Statement stmt = connection.createStatement();){
                stmt.execute(sql);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't manage REFERENTIAL_INTEGRITY", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    boolean userTablesExist(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentIdent(Connection conn, BasicTable t) {
        int n;
        IntegerColumn idColumn = t.getPrimaryKey().values().stream().filter(c -> c instanceof IntegerColumn).map(c -> (IntegerColumn)c).filter(ic -> ic.getSequence() != null).findFirst().get();
        String sequenceName = idColumn.getSequence().getName();
        String sql = String.format("select CURRVAL('\"%s\".\"%s\"')", t.getGrain().getName(), sequenceName);
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        stmt.close();
        return n;
    }

    @Override
    public PreparedStatement getInsertRecordStatement(Connection conn, BasicTable t, boolean[] nullsMask, List<ParameterSetter> program) {
        Iterator<String> columns = t.getColumns().keySet().iterator();
        StringBuilder fields = new StringBuilder();
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < t.getColumns().size(); ++i) {
            String c = columns.next();
            if (nullsMask[i]) continue;
            if (params.length() > 0) {
                fields.append(", ");
                params.append(", ");
            }
            params.append("?");
            fields.append('\"');
            fields.append(c);
            fields.append('\"');
            program.add(ParameterSetter.create(i, (QueryBuildingHelper)this));
        }
        String sql = String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " (%s) values (%s)", fields.toString(), params.toString());
        return H2Adaptor.prepareStatement(conn, sql);
    }

    @Override
    public List<String> getParameterizedViewList(Connection conn, Grain g) {
        String sql = String.format("SELECT ALIAS_NAME FROM INFORMATION_SCHEMA.FUNCTION_ALIASES where alias_schema = '%s'", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot get parameterized views list: %s", e.toString());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbColumnInfo getColumnInfo(Connection conn, Column<?> c) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            String grainName = c.getParentTable().getGrain().getName();
            String tableName = c.getParentTable().getName();
            try (ResultSet rs = metaData.getColumns(null, grainName, tableName, c.getName());){
                if (rs.next()) {
                    DbColumnInfo result = new DbColumnInfo();
                    result.setName(rs.getString("COLUMN_NAME"));
                    String typeName = rs.getString("TYPE_NAME");
                    String columnDefault = rs.getString("COLUMN_DEF");
                    String columnDefaultForIdentity = "NEXTVAL('" + this.tableString(grainName, tableName + "_seq") + "')";
                    if ("integer".equalsIgnoreCase(typeName) && columnDefaultForIdentity.equals(columnDefault)) {
                        result.setType(IntegerColumn.class);
                        result.setNullable(rs.getInt("NULLABLE") != 0);
                        DbColumnInfo dbColumnInfo = result;
                        return dbColumnInfo;
                    }
                    if ("clob".equalsIgnoreCase(typeName)) {
                        result.setType(StringColumn.class);
                        result.setMax(true);
                    } else {
                        for (Class cc : COLUMN_CLASSES) {
                            if (!this.getColumnDefiner(cc).dbFieldType().equalsIgnoreCase(typeName)) continue;
                            result.setType(cc);
                            break;
                        }
                    }
                    result.setNullable(rs.getInt("NULLABLE") != 0);
                    if (result.getType() == StringColumn.class || result.getType() == DecimalColumn.class) {
                        result.setLength(rs.getInt("COLUMN_SIZE"));
                    }
                    if (result.getType() == DecimalColumn.class) {
                        result.setScale(rs.getInt("DECIMAL_DIGITS"));
                    }
                    if (columnDefault != null) {
                        columnDefault = this.modifyDefault(result, columnDefault, conn);
                        result.setDefaultValue(columnDefault);
                    }
                    DbColumnInfo dbColumnInfo = result;
                    return dbColumnInfo;
                }
                DbColumnInfo dbColumnInfo = null;
                return dbColumnInfo;
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    private String modifyDefault(DbColumnInfo ci, String defaultBody, Connection conn) {
        String result;
        block28: {
            result = defaultBody;
            if (IntegerColumn.class == ci.getType()) {
                Pattern p = Pattern.compile("NEXT VALUE FOR \"[^\"]+\"\\.\"([^\"]+)+\"");
                Matcher m = p.matcher(defaultBody);
                if (m.find()) {
                    String sequenceName = m.group(1);
                    result = "NEXTVAL(" + sequenceName + ")";
                }
            } else if (DateTimeColumn.class == ci.getType()) {
                if ("now()".equalsIgnoreCase(defaultBody)) {
                    result = "GETDATE()";
                } else {
                    Matcher m = DATEPATTERN.matcher(defaultBody);
                    m.find();
                    result = String.format("'%s%s%s'", m.group(1), m.group(2), m.group(3));
                }
            } else if (BooleanColumn.class == ci.getType()) {
                result = "'" + defaultBody.toUpperCase() + "'";
            } else if (BinaryColumn.class == ci.getType()) {
                Matcher m = HEX_STRING.matcher(defaultBody);
                if (m.find()) {
                    result = "0x" + m.group(1).toUpperCase();
                }
            } else if (StringColumn.class == ci.getType() && defaultBody.contains("STRINGDECODE")) {
                String sql = "SELECT " + defaultBody;
                try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
                    if (rs.next()) {
                        result = "'" + rs.getString(1) + "'";
                        break block28;
                    }
                    throw new CelestaException("Can't decode default '" + defaultBody + "'");
                }
                catch (SQLException e) {
                    throw new CelestaException("Can't modify default for '" + defaultBody + "'", e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbPkInfo getPKInfo(Connection conn, TableElement t) {
        String sql = String.format("SELECT constraint_name AS indexName, column_name as colName FROM  INFORMATION_SCHEMA.INDEXES WHERE table_schema = '%s' AND table_name = '%s' AND index_type_name = 'PRIMARY KEY'", t.getGrain().getName(), t.getName());
        DbPkInfo result = new DbPkInfo(this);
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result.getName() == null) {
                    String indName = rs.getString("indexName");
                    result.setName(indName);
                }
                String colName = rs.getString("colName");
                result.getColumnNames().add(colName);
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbFkInfo> getFKInfo(Connection conn, Grain g) {
        String sql = "SELECT FK_NAME AS FK_CONSTRAINT_NAME, FKTABLE_NAME AS FK_TABLE_NAME, FKCOLUMN_NAME AS FK_COLUMN_NAME, PKTABLE_SCHEMA AS REF_GRAIN, PKTABLE_NAME AS REF_TABLE_NAME, UPDATE_RULE, DELETE_RULE FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE FKTABLE_SCHEMA = '%s' ORDER BY FK_CONSTRAINT_NAME, ORDINAL_POSITION";
        sql = String.format(sql, g.getName());
        LinkedList<DbFkInfo> result = new LinkedList<DbFkInfo>();
        try (Statement stmt = conn.createStatement();){
            DbFkInfo i = null;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fkName = rs.getString("FK_CONSTRAINT_NAME");
                if (i == null || !i.getName().equals(fkName)) {
                    i = new DbFkInfo(fkName);
                    result.add(i);
                    i.setTableName(rs.getString("FK_TABLE_NAME"));
                    i.setRefGrainName(rs.getString("REF_GRAIN"));
                    i.setRefTableName(rs.getString("REF_TABLE_NAME"));
                    String updateRule = this.resolveConstraintReferential(rs.getInt("UPDATE_RULE"));
                    i.setUpdateRule(H2Adaptor.getFKRule(updateRule));
                    String deleteRule = this.resolveConstraintReferential(rs.getInt("DELETE_RULE"));
                    i.setDeleteRule(H2Adaptor.getFKRule(deleteRule));
                }
                i.getColumnNames().add(rs.getString("FK_COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    private String resolveConstraintReferential(int constraintReferential) {
        String result;
        switch (constraintReferential) {
            case 0: {
                result = "CASCADE";
                break;
            }
            case 1: {
                result = "RESTRICT";
                break;
            }
            case 2: {
                result = "SET NULL";
                break;
            }
            case 3: {
                result = "NO ACTION";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public String getInFilterClause(DataGrainElement dge, DataGrainElement otherDge, List<String> fields, List<String> otherFields, String otherWhere) {
        String template = "( %s ) IN (SELECT %s FROM %s WHERE %s)";
        String fieldsStr = String.join((CharSequence)",", fields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherFieldsStr = String.join((CharSequence)",", otherFields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherTableStr = this.tableString(otherDge.getGrain().getName(), otherDge.getName());
        String result = String.format(template, fieldsStr, otherFieldsStr, otherTableStr, otherWhere);
        return result;
    }

    @Override
    String getLimitedSQL(FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        if (offset == 0L && rowCount == 0L) {
            throw new IllegalArgumentException();
        }
        String sql = offset == 0L ? this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit %d", rowCount) : (rowCount == 0L ? this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit -1 offset %d", offset) : this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit %d offset %d", rowCount, offset));
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DbIndexInfo> getIndices(Connection conn, Grain g) {
        HashMap<String, DbIndexInfo> result = new HashMap<String, DbIndexInfo>();
        String sql = String.format("SELECT table_name as tableName, index_name as indexName, column_name as colName FROM INFORMATION_SCHEMA.INDEXES WHERE table_schema = '%s' AND primary_key <> true", g.getName());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String indexName = rs.getString("indexName");
                DbIndexInfo ii = (DbIndexInfo)result.get(indexName);
                if (ii == null) {
                    String tableName = rs.getString("tableName");
                    ii = new DbIndexInfo(tableName, indexName);
                    result.put(indexName, ii);
                }
                String colName = rs.getString("colName");
                ii.getColumnNames().add(colName);
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean triggerExists(Connection conn, TriggerQuery query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDBPid(Connection conn) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT SESSION_ID()");){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public String translateDate(String date) {
        try {
            Date d = DateTimeColumn.parseISODate(date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return String.format("date '%s'", df.format(d));
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    @Override
    String getSelectTriggerBodySql(TriggerQuery query) {
        String sql = String.format("select SQL from information_schema.triggers where         table_schema = '%s' and table_name = '%s'        and trigger_name = '%s'", query.getSchema(), query.getTableName(), query.getName());
        return sql;
    }

    @Override
    String prepareRowColumnForSelectStaticStrings(String value, String colName, int maxStringLength) {
        int dataType = DataType.getTypeFromClass(value.getClass());
        DataType type = DataType.getDataType((int)dataType);
        return "CAST(? as " + type.name + ") as " + colName;
    }

    @Override
    public DBType getType() {
        return DBType.H2;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DbSequenceInfo getSequenceInfo(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

