/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.ddl.MsSqlDdlGenerator;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public final class MSSQLAdaptor
extends DBAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MSSQLAdaptor.class);
    private static final String SELECT_TOP_1 = "select top 1 %s from ";
    private static final String WHERE_S = " where %s;";

    public MSSQLAdaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer) {
        super(connectionPool, ddlConsumer);
    }

    @Override
    DdlGenerator getDdlGenerator() {
        return new MsSqlDdlGenerator(this);
    }

    @Override
    public boolean tableExists(Connection conn, String schema, String name) {
        return this.objectExists(conn, schema, name);
    }

    /*
     * Exception decompiling
     */
    @Override
    boolean userTablesExist(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    void createSchemaIfNotExists(Connection conn, String name) {
        String sql = String.format("select coalesce(SCHEMA_ID('%s'), -1)", name.replace("\"", ""));
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            rs.next();
            if (rs.getInt(1) == -1) {
                this.ddlAdaptor.createSchema(conn, name);
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
    }

    @Override
    public PreparedStatement getOneFieldStatement(Connection conn, Column<?> c, String where) {
        TableElement t = c.getParentTable();
        String sql = String.format(SELECT_TOP_1 + this.tableString(t.getGrain().getName(), t.getName()) + WHERE_S, c.getQuotedName(), where);
        return MSSQLAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getOneRecordStatement(Connection conn, TableElement t, String where, Set<String> fields) {
        String filedList = MSSQLAdaptor.getTableFieldsListExceptBlobs((DataGrainElement)((Object)t), fields);
        String sql = String.format(SELECT_TOP_1 + this.tableString(t.getGrain().getName(), t.getName()) + WHERE_S, filedList, where);
        return MSSQLAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getInsertRecordStatement(Connection conn, BasicTable t, boolean[] nullsMask, List<ParameterSetter> program) {
        Iterator<String> columns = t.getColumns().keySet().iterator();
        StringBuilder fields = new StringBuilder();
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < t.getColumns().size(); ++i) {
            String c = columns.next();
            if (nullsMask[i]) continue;
            if (params.length() > 0) {
                fields.append(", ");
                params.append(", ");
            }
            params.append("?");
            fields.append('\"');
            fields.append(c);
            fields.append('\"');
            program.add(ParameterSetter.create(i, (QueryBuildingHelper)this));
        }
        String sql = fields.length() == 0 && params.length() == 0 ? "insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " default values;" : String.format("insert " + this.tableString(t.getGrain().getName(), t.getName()) + " (%s) values (%s);", fields.toString(), params.toString());
        return MSSQLAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getDeleteRecordStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete " + this.tableString(t.getGrain().getName(), t.getName()) + WHERE_S, where);
        return MSSQLAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement deleteRecordSetStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete " + this.tableString(t.getGrain().getName(), t.getName()) + " %s;", where.isEmpty() ? "" : "where " + where);
        try {
            PreparedStatement result = conn.prepareStatement(sql);
            return result;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCurrentIdent(Connection conn, BasicTable t) {
        IntegerColumn idColumn = t.getPrimaryKey().values().stream().filter(c -> c instanceof IntegerColumn).map(c -> (IntegerColumn)c).filter(ic -> ic.getSequence() != null).findFirst().get();
        String sql = String.format("SELECT CURRENT_VALUE FROM SYS.sequences WHERE name = '%s'", idColumn.getSequence().getName());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new CelestaException("Id sequence for %s.%s is not initialized.", t.getGrain().getName(), t.getName());
            }
            int n = (int)rs.getLong(1);
            return n;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    @Override
    public String getInFilterClause(DataGrainElement dge, DataGrainElement otherDge, List<String> fields, List<String> otherFields, String otherWhere) {
        String template = "EXISTS (SELECT * FROM %s WHERE %s AND %s)";
        String tableStr = this.tableString(dge.getGrain().getName(), dge.getName());
        String otherTableStr = this.tableString(otherDge.getGrain().getName(), otherDge.getName());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            sb.append(tableStr).append(".\"").append(fields.get(i)).append("\"").append(" = ").append(otherTableStr).append(".\"").append(otherFields.get(i)).append("\"");
            if (i + 1 == fields.size()) continue;
            sb.append(" AND ");
        }
        String result = String.format(template, otherTableStr, sb.toString(), otherWhere);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfVarcharMax(Connection conn, Column<?> c) throws SQLException {
        try (PreparedStatement checkForMax = conn.prepareStatement(String.format("select max_length from sys.columns where object_id  = OBJECT_ID('%s.%s') and name = '%s'", c.getParentTable().getGrain().getName(), c.getParentTable().getName(), c.getName()));){
            ResultSet rs = checkForMax.executeQuery();
            if (rs.next()) {
                int len = rs.getInt(1);
                boolean bl = len == -1;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbColumnInfo getColumnInfo(Connection conn, Column<?> c) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(null, c.getParentTable().getGrain().getName(), c.getParentTable().getName(), c.getName());){
                if (rs.next()) {
                    String defaultBody;
                    DbColumnInfo result = new DbColumnInfo();
                    result.setName(rs.getString("COLUMN_NAME"));
                    String typeName = rs.getString("TYPE_NAME");
                    if ("varbinary".equalsIgnoreCase(typeName) && this.checkIfVarcharMax(conn, c)) {
                        result.setType(BinaryColumn.class);
                    } else if ("int".equalsIgnoreCase(typeName)) {
                        result.setType(IntegerColumn.class);
                    } else if ("float".equalsIgnoreCase(typeName) && rs.getInt("COLUMN_SIZE") == 53) {
                        result.setType(FloatingColumn.class);
                    } else {
                        for (Class cc : COLUMN_CLASSES) {
                            if (!this.getColumnDefiner(cc).dbFieldType().equalsIgnoreCase(typeName)) continue;
                            result.setType(cc);
                            break;
                        }
                    }
                    result.setNullable(rs.getInt("NULLABLE") != 0);
                    if (result.getType() == StringColumn.class) {
                        result.setLength(rs.getInt("COLUMN_SIZE"));
                        result.setMax(this.checkIfVarcharMax(conn, c));
                    }
                    if (result.getType() == DecimalColumn.class) {
                        result.setLength(rs.getInt("COLUMN_SIZE"));
                        result.setScale(rs.getInt("DECIMAL_DIGITS"));
                    }
                    if ((defaultBody = rs.getString("COLUMN_DEF")) != null) {
                        Pattern p;
                        Matcher m;
                        int i = 0;
                        while (defaultBody.charAt(i) == '(' && defaultBody.charAt(defaultBody.length() - i - 1) == ')') {
                            ++i;
                        }
                        defaultBody = defaultBody.substring(i, defaultBody.length() - i);
                        if (IntegerColumn.class == result.getType() && (m = (p = Pattern.compile("NEXT VALUE FOR \\[.*]\\.\\[(.*)]")).matcher(defaultBody)).matches()) {
                            String sequenceName = m.group(1);
                            defaultBody = "NEXTVAL(" + sequenceName + ")";
                        }
                        if (BooleanColumn.class == result.getType() || DateTimeColumn.class == result.getType() || ZonedDateTimeColumn.class == result.getType()) {
                            defaultBody = defaultBody.toUpperCase();
                        }
                        result.setDefaultValue(defaultBody);
                    }
                    DbColumnInfo dbColumnInfo = result;
                    return dbColumnInfo;
                }
                DbColumnInfo dbColumnInfo = null;
                return dbColumnInfo;
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbPkInfo getPKInfo(Connection conn, TableElement t) {
        DbPkInfo result = new DbPkInfo(this);
        try {
            String sql = String.format("select cons.CONSTRAINT_NAME, cols.COLUMN_NAME from INFORMATION_SCHEMA.KEY_COLUMN_USAGE cols inner join INFORMATION_SCHEMA.TABLE_CONSTRAINTS cons on cols.TABLE_SCHEMA = cons.TABLE_SCHEMA and cols.TABLE_NAME = cons.TABLE_NAME and cols.CONSTRAINT_NAME = cons.CONSTRAINT_NAME where cons.CONSTRAINT_TYPE = 'PRIMARY KEY' and cons.TABLE_SCHEMA = '%s' and cons.TABLE_NAME = '%s' order by ORDINAL_POSITION", t.getGrain().getName(), t.getName());
            LOGGER.trace(sql);
            Statement check = conn.createStatement();
            ResultSet rs = check.executeQuery(sql);
            try {
                while (rs.next()) {
                    result.setName(rs.getString(1));
                    result.getColumnNames().add(rs.getString(2));
                }
            }
            finally {
                rs.close();
                check.close();
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbFkInfo> getFKInfo(Connection conn, Grain g) {
        String sql = String.format("SELECT RC.CONSTRAINT_SCHEMA AS 'GRAIN'   , KCU1.CONSTRAINT_NAME AS 'FK_CONSTRAINT_NAME'   , KCU1.TABLE_NAME AS 'FK_TABLE_NAME'   , KCU1.COLUMN_NAME AS 'FK_COLUMN_NAME'   , KCU2.TABLE_SCHEMA AS 'REF_GRAIN'   , KCU2.TABLE_NAME AS 'REF_TABLE_NAME'   , RC.UPDATE_RULE, RC.DELETE_RULE FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU1    ON  KCU1.CONSTRAINT_CATALOG = RC.CONSTRAINT_CATALOG   AND KCU1.CONSTRAINT_SCHEMA  = RC.CONSTRAINT_SCHEMA   AND KCU1.CONSTRAINT_NAME    = RC.CONSTRAINT_NAME INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU2   ON  KCU2.CONSTRAINT_CATALOG = RC.UNIQUE_CONSTRAINT_CATALOG   AND KCU2.CONSTRAINT_SCHEMA  = RC.UNIQUE_CONSTRAINT_SCHEMA   AND KCU2.CONSTRAINT_NAME    = RC.UNIQUE_CONSTRAINT_NAME   AND KCU2.ORDINAL_POSITION   = KCU1.ORDINAL_POSITION WHERE RC.CONSTRAINT_SCHEMA = '%s' ORDER BY KCU1.CONSTRAINT_NAME, KCU1.ORDINAL_POSITION", g.getName());
        LOGGER.trace(sql);
        LinkedList<DbFkInfo> result = new LinkedList<DbFkInfo>();
        try (Statement stmt = conn.createStatement();){
            DbFkInfo i = null;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fkName = rs.getString("FK_CONSTRAINT_NAME");
                if (i == null || !i.getName().equals(fkName)) {
                    i = new DbFkInfo(fkName);
                    result.add(i);
                    i.setTableName(rs.getString("FK_TABLE_NAME"));
                    i.setRefGrainName(rs.getString("REF_GRAIN"));
                    i.setRefTableName(rs.getString("REF_TABLE_NAME"));
                    i.setUpdateRule(MSSQLAdaptor.getFKRule(rs.getString("UPDATE_RULE")));
                    i.setDeleteRule(MSSQLAdaptor.getFKRule(rs.getString("DELETE_RULE")));
                }
                i.getColumnNames().add(rs.getString("FK_COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    @Override
    String getLimitedSQL(FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        if (offset == 0L && rowCount == 0L) {
            throw new IllegalArgumentException();
        }
        String sqlwhere = "".equals(whereClause) ? "" : " where " + whereClause;
        String fieldList = MSSQLAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        if (offset == 0L) {
            String sql = String.format("select top %d %s from %s", rowCount, fieldList, from.getExpression()) + sqlwhere + " order by " + orderBy;
            return sql;
        }
        String rowFilter = rowCount == 0L ? String.format(">= %d", offset + 1L) : String.format("between %d and %d", offset + 1L, offset + rowCount);
        String sql = this.getLimitedSqlWithOffset(orderBy, fieldList, from.getExpression(), sqlwhere, rowFilter);
        return sql;
    }

    private String getLimitedSqlWithOffset(String orderBy, String fieldList, String from, String where, String rowFilter) {
        return String.format("with a as (select ROW_NUMBER() OVER (ORDER BY %s) as [limit_row_number], %s from %s %s)  select * from a where [limit_row_number] %s", orderBy, fieldList, from, where, rowFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DbIndexInfo> getIndices(Connection conn, Grain g) {
        String sql = String.format("select     s.name as SchemaName,    o.name as TableName,    i.name as IndexName,    co.name as ColumnName,    ic.key_ordinal as ColumnOrder from sys.indexes i inner join sys.objects o on i.object_id = o.object_id inner join sys.index_columns ic on ic.object_id = i.object_id     and ic.index_id = i.index_id inner join sys.columns co on co.object_id = i.object_id     and co.column_id = ic.column_id inner join sys.schemas s on o.schema_id = s.schema_id where i.is_primary_key = 0 and o.[type] = 'U'  and s.name = '%s'  order by o.name,  i.[name], ic.key_ordinal;", g.getName());
        LOGGER.trace(sql);
        HashMap<String, DbIndexInfo> result = new HashMap<String, DbIndexInfo>();
        try (Statement stmt = conn.createStatement();){
            DbIndexInfo i = null;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String tabName = rs.getString("TableName");
                String indName = rs.getString("IndexName");
                if (i == null || !i.getTableName().equals(tabName) || !i.getIndexName().equals(indName)) {
                    i = new DbIndexInfo(tabName, indName);
                    result.put(indName, i);
                }
                i.getColumnNames().add(rs.getString("ColumnName"));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerExists(Connection conn, TriggerQuery query) throws SQLException {
        String sql = String.format("SELECT COUNT(*) FROM sys.triggers tr INNER JOIN sys.tables t ON tr.parent_id = t.object_id WHERE t.schema_id = SCHEMA_ID('%s') and tr.name = '%s'", query.getSchema().replace("\"", ""), query.getName().replace("\"", ""));
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    private String generateTsqlForVersioningTrigger(TableElement t) {
        StringBuilder sb = new StringBuilder();
        sb.append("IF  exists (select * from inserted inner join deleted on \n");
        this.addPKJoin(sb, "inserted", "deleted", t);
        sb.append("where inserted.recversion <> deleted.recversion) BEGIN\n");
        sb.append("  RAISERROR ('record version check failure', 16, 1);\n");
        sb.append("END\n");
        sb.append(String.format("update \"%s\".\"%s\" set recversion = recversion + 1 where%n", t.getGrain().getName(), t.getName()));
        sb.append("exists (select * from inserted where \n");
        this.addPKJoin(sb, "inserted", String.format("\"%s\".\"%s\"", t.getGrain().getName(), t.getName()), t);
        sb.append(");\n");
        return sb.toString();
    }

    private void addPKJoin(StringBuilder sb, String left, String right, TableElement t) {
        boolean needAnd = false;
        for (String s : t.getPrimaryKey().keySet()) {
            if (needAnd) {
                sb.append(" AND ");
            }
            sb.append(String.format("  %s.\"%s\" = %s.\"%s\"%n", left, s, right, s));
            needAnd = true;
        }
    }

    @Override
    public PreparedStatement getNavigationStatement(Connection conn, FromClause from, String orderBy, String navigationWhereClause, Set<String> fields, long offset) {
        String sql;
        boolean useWhere;
        if (navigationWhereClause == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder w = new StringBuilder(navigationWhereClause);
        String fieldList = MSSQLAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        boolean bl = useWhere = w.length() > 0;
        if (offset == 0L) {
            if (orderBy.length() > 0) {
                w.append(" order by " + orderBy);
            }
            sql = String.format("select top 1 %s from  %s %s;", fieldList, from.getExpression(), useWhere ? " where " + w : w);
        } else {
            sql = this.getLimitedSqlWithOffset(orderBy, fieldList, from.getExpression(), useWhere ? " where " + w : w.toString(), "=" + offset);
        }
        LOGGER.trace(sql);
        return MSSQLAdaptor.prepareStatement(conn, sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDBPid(Connection conn) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT @@SPID;");){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public boolean nullsFirst() {
        return true;
    }

    @Override
    public List<String> getParameterizedViewList(Connection conn, Grain g) {
        String sql = String.format("SELECT routine_name FROM INFORMATION_SCHEMA.ROUTINES WHERE routine_schema = '%s' AND routine_type='FUNCTION'", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot get parameterized views list: %s", e.toString());
        }
        return result;
    }

    @Override
    String getSelectTriggerBodySql(TriggerQuery query) {
        String sql = String.format(" SELECT OBJECT_DEFINITION (id)%n        FROM sysobjects%n    WHERE id IN(SELECT tr.object_id%n        FROM sys.triggers tr%n        INNER JOIN sys.tables t ON tr.parent_id = t.object_id%n        WHERE t.schema_id = SCHEMA_ID('%s')%n        AND tr.name = '%s');", query.getSchema(), query.getName());
        return sql;
    }

    @Override
    public DBType getType() {
        return DBType.MSSQL;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long nextSequenceValue(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean sequenceExists(Connection conn, String schema, String name) {
        return this.objectExists(conn, schema, name);
    }

    /*
     * Exception decompiling
     */
    @Override
    public DbSequenceInfo getSequenceInfo(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean objectExists(Connection conn, String schema, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

