/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.ddl.OraDdlGenerator;
import ru.curs.celesta.dbutils.adaptors.function.OraFunctions;
import ru.curs.celesta.dbutils.adaptors.function.SchemalessFunctions;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.ZonedDateTimeColumn;
import ru.curs.celesta.score.validator.AnsiQuotedIdentifierParser;

public final class OraAdaptor
extends DBAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OraAdaptor.class);
    private static final String SELECT_S_FROM = "select %s from ";
    private static final String SELECT_TRIGGER_BODY = "select TRIGGER_BODY  from all_triggers where owner = sys_context('userenv','session_user') ";
    private static final Pattern BOOLEAN_CHECK = Pattern.compile("\"([^\"]+)\" *[iI][nN] *\\( *0 *, *1 *\\)");
    private static final Pattern DATE_PATTERN = Pattern.compile("'(\\d\\d\\d\\d)-([01]\\d)-([0123]\\d)'");
    private static final Pattern HEX_STRING = Pattern.compile("'([0-9A-F]+)'");
    private static final Pattern TABLE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9]*)_([a-zA-Z_][a-zA-Z0-9_]*)");
    private static final Map<TriggerType, String> TRIGGER_EVENT_TYPE_DICT = new HashMap<TriggerType, String>();

    public OraAdaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer) {
        super(connectionPool, ddlConsumer);
    }

    @Override
    DdlGenerator getDdlGenerator() {
        return new OraDdlGenerator(this);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean tableExists(Connection conn, String schema, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    boolean userTablesExist(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    void createSchemaIfNotExists(Connection conn, String schema) {
        this.ddlAdaptor.createSchema(conn, schema);
    }

    @Override
    public PreparedStatement getOneFieldStatement(Connection conn, Column<?> c, String where) {
        TableElement t = c.getParentTable();
        String sql = String.format(SELECT_S_FROM + this.tableString(t.getGrain().getName(), t.getName()) + " where %s and rownum = 1", c.getQuotedName(), where);
        return OraAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getOneRecordStatement(Connection conn, TableElement t, String where, Set<String> fields) {
        String fieldList = OraAdaptor.getTableFieldsListExceptBlobs((DataGrainElement)((Object)t), fields);
        String sql = String.format(SELECT_S_FROM + this.tableString(t.getGrain().getName(), t.getName()) + " where %s and rownum = 1", fieldList, where);
        return OraAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getInsertRecordStatement(Connection conn, BasicTable t, boolean[] nullsMask, List<ParameterSetter> program) {
        String sql;
        Iterator<String> columns = t.getColumns().keySet().iterator();
        StringBuilder fields = new StringBuilder();
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < t.getColumns().size(); ++i) {
            String c = columns.next();
            if (nullsMask[i]) continue;
            if (params.length() > 0) {
                fields.append(", ");
                params.append(", ");
            }
            params.append("?");
            fields.append('\"');
            fields.append(c);
            fields.append('\"');
            program.add(ParameterSetter.create(i, (QueryBuildingHelper)this));
        }
        if (fields.length() == 0 && params.length() == 0) {
            String columnToInsert = t.getColumns().keySet().stream().filter(k -> !"recversion".equals(k)).findFirst().get();
            sql = String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " (\"%s\") values (DEFAULT)", columnToInsert);
        } else {
            sql = String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " (%s) values (%s)", fields.toString(), params.toString());
        }
        return OraAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement getDeleteRecordStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete " + this.tableString(t.getGrain().getName(), t.getName()) + " where %s", where);
        return OraAdaptor.prepareStatement(conn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getColumns(Connection conn, TableElement t) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            String tableName = String.format("%s_%s", t.getGrain().getName(), t.getName());
            String sql = String.format("SELECT column_name FROM user_tab_cols WHERE table_name = '%s' order by column_id", tableName);
            LOGGER.trace(sql);
            Statement stmt = conn.createStatement();
            try (ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    String rColumnName = rs.getString("COLUMN_NAME");
                    result.add(rColumnName);
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    @Override
    public PreparedStatement deleteRecordSetStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete from " + this.tableString(t.getGrain().getName(), t.getName()) + " %s", where.isEmpty() ? "" : "where " + where);
        try {
            PreparedStatement result = conn.prepareStatement(sql);
            return result;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValidConnection(Connection conn, int timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String tableString(String schemaName, String tableName) {
        StringBuilder sb = new StringBuilder(this.getSchemaUnderscoreNameTemplate(schemaName, tableName));
        sb.insert(0, '\"').append('\"');
        return sb.toString();
    }

    private String getSchemaUnderscoreNameTemplate(String schemaName, String name) {
        return this.stripNameFromQuotes(schemaName) + "_" + this.stripNameFromQuotes(name);
    }

    private String stripNameFromQuotes(String name) {
        return name.startsWith("\"") ? name.substring(1, name.length() - 1) : name;
    }

    @Override
    public String sequenceString(String schemaName, String sequenceName) {
        return this.sequenceString(schemaName, sequenceName, true);
    }

    private String sequenceString(String schemaName, String sequenceName, boolean isQuoted) {
        StringBuilder sb = new StringBuilder(NamedElement.limitName(this.getSchemaUnderscoreNameTemplate(schemaName, sequenceName)));
        if (isQuoted) {
            sb.insert(0, '\"').append('\"');
        }
        return sb.toString();
    }

    @Override
    public String pkConstraintString(TableElement tableElement) {
        return NamedElement.limitName(tableElement.getPkConstraintName() + "_" + tableElement.getGrain().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCurrentIdent(Connection conn, BasicTable t) {
        IntegerColumn idColumn = t.getPrimaryKey().values().stream().filter(c -> c instanceof IntegerColumn).map(c -> (IntegerColumn)c).filter(ic -> ic.getSequence() != null).findFirst().get();
        String sequenceName = this.tableString(t.getGrain().getName(), idColumn.getSequence().getName());
        String sql = String.format("SELECT %s.CURRVAL FROM DUAL", sequenceName);
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    @Override
    public String getInFilterClause(DataGrainElement dge, DataGrainElement otherDge, List<String> fields, List<String> otherFields, String otherWhere) {
        String template = "( %s ) IN (SELECT %s FROM %s WHERE %s)";
        String fieldsStr = String.join((CharSequence)",", fields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherFieldsStr = String.join((CharSequence)",", otherFields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherTableStr = this.tableString(otherDge.getGrain().getName(), otherDge.getName());
        String result = String.format(template, fieldsStr, otherFieldsStr, otherTableStr, otherWhere);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForBoolean(Connection conn, Column<?> c) throws SQLException {
        String sql = String.format("SELECT SEARCH_CONDITION FROM ALL_CONSTRAINTS WHERE OWNER = sys_context('userenv','session_user') AND TABLE_NAME = '%s_%s'AND CONSTRAINT_TYPE = 'C'", c.getParentTable().getGrain().getName(), c.getParentTable().getName());
        LOGGER.trace(sql);
        try (PreparedStatement checkForBool = conn.prepareStatement(sql);){
            ResultSet rs = checkForBool.executeQuery();
            while (rs.next()) {
                String buf = rs.getString(1);
                Matcher m = BOOLEAN_CHECK.matcher(buf);
                if (!m.find() || !m.group(1).equals(c.getName())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbColumnInfo getColumnInfo(Connection conn, Column<?> c) {
        try {
            DbColumnInfo result;
            String tableName = String.format("%s_%s", c.getParentTable().getGrain().getName(), c.getParentTable().getName());
            String sql = String.format("SELECT COLUMN_NAME, DATA_TYPE, NULLABLE, CHAR_LENGTH, DATA_PRECISION, DATA_SCALE FROM user_tab_cols    WHERE table_name = '%s' and COLUMN_NAME = '%s'", tableName, c.getName());
            LOGGER.trace(sql);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (!rs.next()) {
                    DbColumnInfo dbColumnInfo = null;
                    return dbColumnInfo;
                }
                result = new DbColumnInfo();
                result.setName(rs.getString("COLUMN_NAME"));
                String typeName = rs.getString("DATA_TYPE");
                if (typeName.startsWith("TIMESTAMP")) {
                    if (typeName.endsWith("WITH TIME ZONE")) {
                        result.setType(ZonedDateTimeColumn.class);
                    } else {
                        result.setType(DateTimeColumn.class);
                    }
                } else if ("float".equalsIgnoreCase(typeName)) {
                    result.setType(FloatingColumn.class);
                } else if ("nclob".equalsIgnoreCase(typeName)) {
                    result.setType(StringColumn.class);
                    result.setMax(true);
                } else if ("number".equalsIgnoreCase(typeName) && rs.getInt("DATA_PRECISION") != 0 && rs.getInt("DATA_SCALE") != 0) {
                    result.setType(DecimalColumn.class);
                    result.setLength(rs.getInt("DATA_PRECISION"));
                    result.setScale(rs.getInt("DATA_SCALE"));
                } else {
                    for (Class cc : COLUMN_CLASSES) {
                        if (!this.getColumnDefiner(cc).dbFieldType().equalsIgnoreCase(typeName)) continue;
                        result.setType(cc);
                        break;
                    }
                }
                if (IntegerColumn.class == result.getType() && this.checkForBoolean(conn, c)) {
                    result.setType(BooleanColumn.class);
                }
                result.setNullable("Y".equalsIgnoreCase(rs.getString("NULLABLE")));
                if (result.getType() == StringColumn.class) {
                    result.setLength(rs.getInt("CHAR_LENGTH"));
                }
            }
            finally {
                rs.close();
                stmt.close();
            }
            this.processDefaults(conn, c, result);
            return result;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDefaults(Connection conn, Column<?> c, DbColumnInfo result) throws SQLException {
        TableElement te = c.getParentTable();
        Grain g = te.getGrain();
        try (PreparedStatement getDefault = conn.prepareStatement(String.format("select DATA_DEFAULT from DBA_TAB_COLUMNS where owner = sys_context('userenv','session_user') and TABLE_NAME = '%s_%s' and COLUMN_NAME = '%s'", g.getName(), te.getName(), c.getName()));){
            Matcher m;
            String body;
            block49: {
                ResultSet rs = getDefault.executeQuery();
                if (!rs.next()) {
                    return;
                }
                body = rs.getString(1);
                if (body == null || "null".equalsIgnoreCase(body)) {
                    if (c instanceof IntegerColumn) {
                        IntegerColumn ic = (IntegerColumn)c;
                        String sequenceTriggerName = SchemalessFunctions.generateSequenceTriggerName(ic);
                        String sql = String.format("SELECT REFERENCED_NAME FROM USER_DEPENDENCIES  WHERE NAME = '%s'  AND TYPE = 'TRIGGER'  AND REFERENCED_TYPE = 'SEQUENCE'", sequenceTriggerName);
                        try (Statement stmt = conn.createStatement();
                             ResultSet sequenceRs = stmt.executeQuery(sql);){
                            if (sequenceRs.next()) {
                                String sequenceName = sequenceRs.getString(1);
                                body = "NEXTVAL(" + sequenceName.replace(g.getName() + "_", "") + ")";
                                break block49;
                            }
                            return;
                        }
                    }
                    return;
                }
            }
            if (BooleanColumn.class == result.getType()) {
                body = "0".equals(body.trim()) ? "'FALSE'" : "'TRUE'";
            } else if (DateTimeColumn.class == result.getType()) {
                if (body.toLowerCase().contains("sysdate")) {
                    body = "GETDATE()";
                } else {
                    m = DATE_PATTERN.matcher(body);
                    if (m.find()) {
                        body = String.format("'%s%s%s'", m.group(1), m.group(2), m.group(3));
                    }
                }
            } else if (BinaryColumn.class == result.getType()) {
                m = HEX_STRING.matcher(body);
                if (m.find()) {
                    body = "0x" + m.group(1);
                }
            } else {
                body = body.trim();
            }
            result.setDefaultValue(body);
        }
    }

    private static String getFKTriggerName(String prefix, String fkName) {
        String result = prefix + fkName;
        result = NamedElement.limitName(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbPkInfo getPKInfo(Connection conn, TableElement t) {
        DbPkInfo result = new DbPkInfo(this);
        try {
            String sql = String.format("select cons.constraint_name, column_name from all_constraints cons inner join all_cons_columns cols on cons.constraint_name = cols.constraint_name  and cons.owner = cols.owner where cons.owner = sys_context('userenv','session_user') and cons.table_name = '%s_%s' and cons.constraint_type = 'P' order by cols.position", t.getGrain().getName(), t.getName());
            Statement check = conn.createStatement();
            ResultSet rs = check.executeQuery(sql);
            try {
                while (rs.next()) {
                    result.setName(rs.getString(1));
                    result.getColumnNames().add(rs.getString(2));
                }
            }
            finally {
                rs.close();
                check.close();
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbFkInfo> getFKInfo(Connection conn, Grain g) {
        String sql = String.format("select cols.constraint_name, cols.table_name table_name, ref.table_name ref_table_name, cons.delete_rule, cols.column_name from all_constraints cons inner join all_cons_columns cols on cols.owner = cons.owner and cols.constraint_name = cons.constraint_name   and cols.table_name = cons.table_name inner join all_constraints ref on ref.owner = cons.owner   and ref.constraint_name = cons.r_constraint_name where cons.constraint_type = 'R' and cons.owner = sys_context('userenv','session_user') and ref.constraint_type = 'P' and  cons.table_name like '%s@_%%' escape '@' order by cols.constraint_name, cols.position", g.getName());
        LinkedList<DbFkInfo> result = new LinkedList<DbFkInfo>();
        try (Statement stmt = conn.createStatement();){
            DbFkInfo i = null;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fkName = rs.getString("CONSTRAINT_NAME");
                if (i == null || !i.getName().equals(fkName)) {
                    i = new DbFkInfo(fkName);
                    result.add(i);
                    String tableName = rs.getString("TABLE_NAME");
                    i.setTableName(this.convertNameFromDb(tableName, g));
                    tableName = rs.getString("REF_TABLE_NAME");
                    i.setRefGrainName(tableName.substring(0, tableName.indexOf("_")));
                    i.setRefTableName(tableName.substring(tableName.indexOf("_") + 1));
                    i.setUpdateRule(this.getUpdateBehaviour(conn, tableName, fkName));
                    i.setDeleteRule(OraAdaptor.getFKRule(rs.getString("DELETE_RULE")));
                }
                i.getColumnNames().add(rs.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKRule getUpdateBehaviour(Connection conn, String tableName, String fkName) throws SQLException {
        String sql = String.format("select trigger_name from all_triggers where owner = sys_context('userenv','session_user') and table_name = '%s' and trigger_name in ('%s', '%s') and triggering_event = 'UPDATE'", tableName, OraAdaptor.getFKTriggerName("snl_", fkName), OraAdaptor.getFKTriggerName("csc_", fkName));
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                sql = rs.getString("TRIGGER_NAME");
                if (sql.startsWith("csc_")) {
                    FKRule fKRule = FKRule.CASCADE;
                    return fKRule;
                }
                if (sql.startsWith("snl_")) {
                    FKRule fKRule = FKRule.SET_NULL;
                    return fKRule;
                }
            }
            FKRule fKRule = FKRule.NO_ACTION;
            return fKRule;
        }
    }

    @Override
    String getLimitedSQL(FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        if (offset == 0L && rowCount == 0L) {
            throw new IllegalArgumentException();
        }
        String sql = offset == 0L ? String.format("with a as (%s) select a.* from a where rownum <= %d", this.getSelectFromOrderBy(from, whereClause, orderBy, fields), rowCount) : (rowCount == 0L ? String.format("with a as (%s) select * from (select a.*, ROWNUM rnum from a) where rnum >= %d order by rnum", this.getSelectFromOrderBy(from, whereClause, orderBy, fields), offset + 1L) : this.getLimitedSqlWithOffset(orderBy, fields, from, whereClause, offset, rowCount));
        return sql;
    }

    private String getLimitedSqlWithOffset(String orderBy, Set<String> fields, FromClause from, String where, long offset, long rowCount) {
        return String.format("with a as (%s) select * from (select a.*, ROWNUM rnum from a where rownum <= %d) where rnum >= %d order by rnum", this.getSelectFromOrderBy(from, where, orderBy, fields), offset + rowCount, offset + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DbIndexInfo> getIndices(Connection conn, Grain g) {
        String sql = String.format("select ind.table_name TABLE_NAME, ind.index_name INDEX_NAME, cols.column_name COLUMN_NAME, cols.column_position POSITION from all_indexes ind inner join all_ind_columns cols on ind.owner = cols.index_owner and ind.table_name = cols.table_name and ind.index_name = cols.index_name where ind.owner = sys_context('userenv','session_user') and ind.uniqueness = 'NONUNIQUE' and ind.table_name like '%s@_%%' escape '@'order by ind.table_name, ind.index_name, cols.column_position", g.getName());
        HashMap<String, DbIndexInfo> result = new HashMap<String, DbIndexInfo>();
        try (Statement stmt = conn.createStatement();){
            DbIndexInfo i = null;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String tabName = rs.getString("TABLE_NAME");
                tabName = this.convertNameFromDb(tabName, g);
                String dbIndName = rs.getString("INDEX_NAME");
                String indName = this.convertNameFromDb(dbIndName, g) != null ? this.convertNameFromDb(dbIndName, g) : "##" + dbIndName;
                if (i == null || !i.getTableName().equals(tabName) || !i.getIndexName().equals(indName)) {
                    i = new DbIndexInfo(tabName, indName);
                    result.put(indName, i);
                }
                i.getColumnNames().add(rs.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    @Override
    public List<String> getViewList(Connection conn, Grain g) {
        String sql = String.format("select view_name from all_views where owner = sys_context('userenv','session_user') and view_name like '%s@_%%' escape '@'", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                String dbName = rs.getString(1);
                result.add(this.convertNameFromDb(dbName, g));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot get views list: %s", e.toString());
        }
        return result;
    }

    @Override
    public List<String> getParameterizedViewList(Connection conn, Grain g) {
        String sql = String.format("select OBJECT_NAME from all_objects\n where owner = sys_context('userenv','session_user')\n and object_type = 'FUNCTION' and object_name like '%s@_%%' escape '@'", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                String dbName = rs.getString(1);
                result.add(this.convertNameFromDb(dbName, g));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot get views list: %s", e.toString());
        }
        return result;
    }

    @Override
    public String getCallFunctionSql(ParameterizedView pv) {
        return String.format("TABLE(" + this.tableString(pv.getGrain().getName(), pv.getName()) + "(%s))", pv.getParameters().keySet().stream().map(p -> "?").collect(Collectors.joining(", ")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerExists(Connection conn, TriggerQuery query) throws SQLException {
        String sql = String.format("select TRIGGER_BODY  from all_triggers where owner = sys_context('userenv','session_user') and table_name = '%s_%s' and trigger_name = '%s' and triggering_event = '%s'", query.getSchema(), query.getTableName(), query.getName(), TRIGGER_EVENT_TYPE_DICT.get((Object)query.getType()));
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            boolean result = rs.next();
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public PreparedStatement getNavigationStatement(Connection conn, FromClause from, String orderBy, String navigationWhereClause, Set<String> fields, long offset) {
        String sql;
        if (navigationWhereClause == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder w = new StringBuilder(navigationWhereClause);
        String fieldList = OraAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        if (offset == 0L) {
            if (orderBy.length() > 0) {
                w.append(" order by " + orderBy);
            }
            sql = String.format("select %s from  (select %s from  %s  %s) where rownum = 1", fieldList, fieldList, from.getExpression(), "where " + w);
        } else {
            sql = this.getLimitedSqlWithOffset(orderBy, fields, from, w.toString(), offset - 1L, offset);
        }
        LOGGER.trace(sql);
        return OraAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public String translateDate(String date) {
        return OraFunctions.translateDate(date);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDBPid(Connection conn) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select sys_context('userenv','sessionid') from dual");){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ZonedDateTime prepareZonedDateTimeForParameterSetter(Connection conn, ZonedDateTime z) {
        try (ResultSet rs = SqlUtils.executeQuery(conn, "SELECT SESSIONTIMEZONE FROM DUAL");){
            rs.next();
            String zoneId = rs.getString(1);
            Instant instant = Instant.now();
            ZoneId systemZone = ZoneId.of(zoneId);
            ZoneOffset systemOffset = systemZone.getRules().getOffset(instant);
            int offsetDifInSeconds = systemOffset.getTotalSeconds();
            ZonedDateTime zonedDateTime = z.plusSeconds(offsetDifInSeconds);
            return zonedDateTime;
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
    }

    @Override
    public boolean nullsFirst() {
        return false;
    }

    @Override
    String getSelectTriggerBodySql(TriggerQuery query) {
        String sql = String.format("select TRIGGER_BODY  from all_triggers where owner = sys_context('userenv','session_user') and table_name = '%s_%s' and trigger_name = '%s'", query.getSchema(), query.getTableName(), query.getName());
        return sql;
    }

    @Override
    String constantFromSql() {
        return "FROM DUAL";
    }

    @Override
    public DBType getType() {
        return DBType.ORACLE;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long nextSequenceValue(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean sequenceExists(Connection conn, String schema, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public DbSequenceInfo getSequenceInfo(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String convertNameFromDb(String dbName, Grain g) {
        String name;
        if (g.getScore().getIdentifierParser() instanceof AnsiQuotedIdentifierParser) {
            name = dbName.substring(g.getName().length() + 1);
        } else {
            Matcher m = TABLE_PATTERN.matcher(dbName);
            if (!m.find()) {
                return null;
            }
            name = m.group(2);
        }
        return name;
    }

    static {
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.PRE_INSERT, "INSERT");
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.PRE_UPDATE, "UPDATE");
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.PRE_DELETE, "DELETE");
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.POST_INSERT, "INSERT");
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.POST_UPDATE, "UPDATE");
        TRIGGER_EVENT_TYPE_DICT.put(TriggerType.POST_DELETE, "DELETE");
    }
}

