/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import java.util.regex.Matcher;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.dbutils.adaptors.constants.CommonConstants;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.Column;

class H2BinaryColumnDefiner
extends ColumnDefiner {
    H2BinaryColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "varbinary";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return H2BinaryColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        BinaryColumn bc = (BinaryColumn)c;
        String defaultStr = "";
        if (bc.getDefaultValue() != null) {
            Matcher m = CommonConstants.HEXSTR.matcher(bc.getDefaultValue());
            m.matches();
            defaultStr = "default " + String.format("X'%s'", m.group(1));
        }
        return defaultStr;
    }
}

