/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.SequenceElement;

class H2IntegerColumnDefiner
extends ColumnDefiner {
    H2IntegerColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "integer";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return H2IntegerColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        IntegerColumn ic = (IntegerColumn)c;
        String defaultStr = "";
        SequenceElement s = ic.getSequence();
        if (s != null) {
            defaultStr = "default " + s.getGrain().getQuotedName() + "." + s.getQuotedName() + ".nextval";
        } else if (ic.getDefaultValue() != null) {
            defaultStr = "default " + ic.getDefaultValue();
        }
        return defaultStr;
    }
}

