/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import java.text.SimpleDateFormat;
import ru.curs.celesta.dbutils.adaptors.column.OraColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;

class OraDateTimeColumnDefiner
extends OraColumnDefiner {
    OraDateTimeColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "timestamp";
    }

    @Override
    public String getInternalDefinition(Column<?> c) {
        return OraDateTimeColumnDefiner.join(c.getQuotedName(), this.dbFieldType());
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DateTimeColumn ic = (DateTimeColumn)c;
        String defaultStr = "";
        if (ic.isGetdate()) {
            defaultStr = "default sysdate";
        } else if (ic.getDefaultValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            defaultStr = String.format("default date '%s'", df.format(ic.getDefaultValue()));
        }
        return defaultStr;
    }
}

