/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.StringColumn;

class PostgresStringColumnDefiner
extends ColumnDefiner {
    PostgresStringColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "varchar";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String fieldType = ic.isMax() ? "text" : String.format("%s(%s)", this.dbFieldType(), ic.getLength());
        return PostgresStringColumnDefiner.join(c.getQuotedName(), fieldType, this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + StringColumn.quoteString(ic.getDefaultValue());
        }
        return defaultStr;
    }
}

