/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.View;

public final class DdlAdaptor {
    private final DdlGenerator ddlGenerator;
    private final DdlConsumer ddlConsumer;

    public DdlAdaptor(DdlGenerator ddlGenerator, DdlConsumer ddlConsumer) {
        this.ddlGenerator = ddlGenerator;
        this.ddlConsumer = ddlConsumer;
    }

    public void createSchema(Connection conn, String name) {
        Optional<String> sql = this.ddlGenerator.createSchema(name);
        sql.ifPresent(s -> this.processSql(conn, (String)s));
    }

    public void dropView(Connection conn, String schemaName, String viewName) {
        String sql = this.ddlGenerator.dropView(schemaName, viewName);
        this.processSql(conn, sql);
    }

    public void dropParameterizedView(Connection conn, String schemaName, String viewName) {
        List<String> sqlList = this.ddlGenerator.dropParameterizedView(schemaName, viewName, conn);
        this.processSql(conn, sqlList);
    }

    public void dropIndex(Connection conn, Grain g, DbIndexInfo dBIndexInfo) {
        List<String> sqlList = this.ddlGenerator.dropIndex(g, dBIndexInfo);
        this.processSql(conn, sqlList);
    }

    public void dropFK(Connection conn, String schemaName, String tableName, String fkName) {
        String sql = this.ddlGenerator.dropFk(schemaName, tableName, fkName);
        try {
            this.processSql(conn, sql);
        }
        catch (CelestaException e) {
            throw new CelestaException("Cannot drop foreign key '%s': %s", fkName, e.getMessage());
        }
        List<String> sqlList = this.ddlGenerator.dropUpdateRule(fkName);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException celestaException) {
            // empty catch block
        }
    }

    public void dropTrigger(Connection conn, TriggerQuery query) {
        String sql = this.ddlGenerator.dropTrigger(query);
        this.processSql(conn, sql);
    }

    public void createSequence(Connection conn, SequenceElement s) {
        List<String> sqlList = this.ddlGenerator.createSequence(s);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException("Error while creating sequence %s.%s: %s", s.getGrain().getName(), s.getName(), e.getMessage());
        }
    }

    public void alterSequence(Connection conn, SequenceElement s) {
        List<String> sqlList = this.ddlGenerator.alterSequence(s);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException("Error while altering sequence %s.%s: %s", s.getGrain().getName(), s.getName(), e.getMessage());
        }
    }

    public void createTable(Connection conn, TableElement te) {
        String sql = this.ddlGenerator.createTable(te);
        try {
            this.processSql(conn, sql);
            conn.commit();
            List<String> sqlList = this.ddlGenerator.updateVersioningTrigger(conn, te);
            this.processSql(conn, sqlList);
            sqlList = this.ddlGenerator.afterCreateTable(conn, te);
            this.processSql(conn, sqlList);
        }
        catch (SQLException | CelestaException e) {
            throw new CelestaException("Error on creating %s: %s", te.getName(), e.getMessage());
        }
    }

    public void updateVersioningTrigger(Connection conn, TableElement t) {
        List<String> sqlList = this.ddlGenerator.updateVersioningTrigger(conn, t);
        this.processSql(conn, sqlList);
    }

    public void dropPk(Connection conn, TableElement t, String pkName) {
        String sql = this.ddlGenerator.dropPk(t, pkName);
        try {
            this.processSql(conn, sql);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Cannot drop PK '%s': %s", pkName, e.getMessage()), e);
        }
    }

    public void updateColumn(Connection conn, Column<?> c, DbColumnInfo actual) {
        List<String> sqlList = this.ddlGenerator.updateColumn(conn, c, actual);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Cannot modify column %s on table %s.%s: %s", c.getName(), c.getParentTable().getGrain().getName(), c.getParentTable().getName(), e.getMessage()), e);
        }
    }

    public void createColumn(Connection conn, Column<?> c) {
        String sql = this.ddlGenerator.createColumn(c);
        try {
            this.processSql(conn, sql);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Error of creating %s.%s: %s", c.getParentTable().getName(), c.getName(), e.getMessage()), e);
        }
    }

    public void createPk(Connection conn, TableElement t) {
        String sql = this.ddlGenerator.createPk(t);
        try {
            this.processSql(conn, sql);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Cannot create PK '%s': %s", this.ddlGenerator.pkConstraintString(t), e.getMessage()), e);
        }
    }

    public void createIndex(Connection conn, Index index) {
        List<String> sqlList = this.ddlGenerator.createIndex(index);
        try {
            this.processSql(conn, sqlList);
            conn.commit();
        }
        catch (Exception e) {
            throw new CelestaException(String.format("Cannot create index '%s': %s", index.getName(), e.getMessage()), e);
        }
    }

    public void createFk(Connection conn, ForeignKey fk) {
        try {
            List<String> sqlList = this.ddlGenerator.createFk(conn, fk);
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException("Cannot create foreign key '%s': %s", fk.getConstraintName(), e.getMessage());
        }
    }

    public void createView(Connection conn, View v) {
        String sql = this.ddlGenerator.createView(v);
        try {
            this.processSql(conn, sql);
        }
        catch (CelestaException e) {
            throw new CelestaException("Error while creating view %s.%s: %s", v.getGrain().getName(), v.getName(), e.getMessage());
        }
    }

    public SQLGenerator getViewSQLGenerator() {
        return this.ddlGenerator.getViewSQLGenerator();
    }

    public void createParameterizedView(Connection conn, ParameterizedView pv) {
        List<String> sqlList = this.ddlGenerator.createParameterizedView(pv);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Error while creating parameterized view %s.%s: %s", pv.getGrain().getName(), pv.getName(), e.getMessage()), e);
        }
    }

    public void dropTable(Connection conn, TableElement t) {
        String sql = this.ddlGenerator.dropTable(t);
        this.processSql(conn, sql);
        this.ddlGenerator.dropAutoIncrement(conn, t).ifPresent(s -> this.processSql(conn, (String)s));
        try {
            conn.commit();
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
    }

    public void initDataForMaterializedView(Connection conn, MaterializedView mv) {
        List<String> sqlList = this.ddlGenerator.initDataForMaterializedView(mv);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException("Can't init data for materialized view %s.%s: %s", mv.getGrain().getName(), mv.getName(), e);
        }
    }

    public void dropTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        List<String> sqlList = this.ddlGenerator.dropTableTriggersForMaterializedViews(conn, t);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException("Can't drop triggers for materialized views", e);
        }
    }

    public void createTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        List<String> sqlList = this.ddlGenerator.createTableTriggersForMaterializedViews(t);
        try {
            this.processSql(conn, sqlList);
        }
        catch (CelestaException e) {
            throw new CelestaException(String.format("Could not update triggers on %s.%s for materialized views: %s", t.getGrain().getName(), t.getName(), e.getMessage()), e);
        }
    }

    public void executeNative(Connection conn, String sql) {
        this.processSql(conn, sql);
    }

    private void processSql(Connection conn, String sql) {
        this.ddlConsumer.consume(conn, sql);
    }

    private void processSql(Connection conn, Collection<String> sqlList) {
        for (String sql : sqlList) {
            this.processSql(conn, sql);
        }
    }
}

