/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.sql.Connection;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.TableElement;

public abstract class OpenSourceDdlGenerator
extends DdlGenerator {
    public OpenSourceDdlGenerator(DBAdaptor dmlAdaptor) {
        super(dmlAdaptor);
    }

    @Override
    final List<String> dropIndex(Grain g, DbIndexInfo dBIndexInfo) {
        String sql = this.dropIndex(g.getName(), dBIndexInfo.getIndexName());
        String sql2 = this.dropIndex(g.getName(), dBIndexInfo.getIndexName() + "__vpo");
        return Arrays.asList(sql, sql2);
    }

    @Override
    final String dropTriggerSql(TriggerQuery query) {
        String sql = String.format("DROP TRIGGER \"%s\" ON %s", query.getName(), this.tableString(query.getSchema(), query.getTableName()));
        return sql;
    }

    @Override
    final List<String> updateColumn(Connection conn, Column<?> c, DbColumnInfo actual) {
        Class<?> cClass = c.getClass();
        LinkedList<String> result = new LinkedList<String>();
        String sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " ALTER COLUMN \"%s\" DROP DEFAULT", c.getName());
        result.add(sql);
        this.updateColType(c, actual, result);
        if (c.isNullable() != actual.isNullable()) {
            sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " ALTER COLUMN \"%s\" %s", c.getName(), c.isNullable() ? "DROP NOT NULL" : "SET NOT NULL");
            result.add(sql);
        }
        if (c.getDefaultValue() != null || c instanceof DateTimeColumn && ((DateTimeColumn)c).isGetdate() || c instanceof IntegerColumn && ((IntegerColumn)c).getSequence() != null) {
            sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " ALTER COLUMN \"%s\" SET %s", c.getName(), ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).getDefaultDefinition(c));
            result.add(sql);
        }
        return result;
    }

    @Override
    final Optional<String> dropAutoIncrement(Connection conn, TableElement t) {
        String sql = String.format("drop sequence if exists \"%s\".\"%s_seq\"", t.getGrain().getName(), t.getName());
        return Optional.of(sql);
    }

    abstract void updateColType(Column<?> var1, DbColumnInfo var2, List<String> var3);

    private String dropIndex(String schemaName, String indexName) {
        return String.format("DROP INDEX IF EXISTS %s", this.tableString(schemaName, indexName));
    }
}

