/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.function;

import java.text.SimpleDateFormat;
import java.util.Date;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;

public final class OraFunctions {
    private OraFunctions() {
        throw new AssertionError();
    }

    public static String getBooleanCheckName(Column<?> c) {
        String result = String.format("chk_%s_%s_%s", c.getParentTable().getGrain().getName(), c.getParentTable().getName(), c.getName());
        result = NamedElement.limitName(result);
        return "\"" + result + "\"";
    }

    public static String translateDate(String date) {
        try {
            Date d = DateTimeColumn.parseISODate(date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return String.format("date '%s'", df.format(d));
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public static boolean fromOrToNClob(Column<?> c, DbColumnInfo actual) {
        return !(!actual.isMax() && !OraFunctions.isNclob(c) || actual.isMax() && OraFunctions.isNclob(c));
    }

    private static boolean isNclob(Column<?> c) {
        return c instanceof StringColumn && ((StringColumn)c).isMax();
    }
}

