/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.meta;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.score.TableElement;

public final class DbPkInfo {
    private final DBAdaptor dbAdaptor;
    private String name;
    private final List<String> columnNames = new LinkedList<String>();

    public DbPkInfo(DBAdaptor dbAdaptor) {
        this.dbAdaptor = dbAdaptor;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean isEmpty() {
        return this.columnNames.isEmpty();
    }

    public boolean reflects(TableElement t) {
        if (!this.dbAdaptor.pkConstraintString(t).equals(this.name)) {
            return false;
        }
        if (this.columnNames.size() != t.getPrimaryKey().size()) {
            return false;
        }
        Iterator<String> i1 = t.getPrimaryKey().keySet().iterator();
        Iterator<String> i2 = this.columnNames.iterator();
        while (i1.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }
}

