/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.term;

import java.util.List;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.term.AlwaysFalse;
import ru.curs.celesta.dbutils.term.AlwaysTrue;
import ru.curs.celesta.dbutils.term.WhereTerm;

public final class OrTerm
extends WhereTerm {
    private final WhereTerm l;
    private final WhereTerm r;

    private OrTerm(WhereTerm l, WhereTerm r) {
        this.l = l;
        this.r = r;
    }

    static WhereTerm construct(WhereTerm l, WhereTerm r) {
        if (l instanceof AlwaysTrue || r instanceof AlwaysTrue) {
            return AlwaysTrue.TRUE;
        }
        if (l instanceof AlwaysFalse) {
            return r;
        }
        if (r instanceof AlwaysFalse) {
            return l;
        }
        return new OrTerm(l, r);
    }

    @Override
    public String getWhere() {
        String ls = this.l instanceof OrTerm ? ((OrTerm)this.l).getOpenWhere() : this.l.getWhere();
        String rs = this.r instanceof OrTerm ? ((OrTerm)this.r).getOpenWhere() : this.r.getWhere();
        return String.format("(%s or %s)", ls, rs);
    }

    private String getOpenWhere() {
        return String.format("%s or %s", this.l.getWhere(), this.r.getWhere());
    }

    @Override
    public void programParams(List<ParameterSetter> program, QueryBuildingHelper queryBuildingHelper) {
        this.l.programParams(program, queryBuildingHelper);
        this.r.programParams(program, queryBuildingHelper);
    }
}

