/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ReadOnlyTable;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public final class CelestaSerializer {
    private final PrintWriter writer;

    public CelestaSerializer(PrintWriter writer) {
        this.writer = writer;
    }

    static String toString(MaterializedView mv) throws IOException {
        try (StringWriter sw = new StringWriter();){
            new CelestaSerializer(new PrintWriter(sw)).save(mv);
            String string = sw.toString();
            return string;
        }
    }

    public static String toQueryString(View v) throws IOException {
        try (StringWriter sw = new StringWriter();){
            new CelestaSerializer(new PrintWriter(sw)).saveQuery(v);
            String string = sw.toString();
            return string;
        }
    }

    public void save(GrainPart gp) throws IOException {
        this.save(gp.getGrain(), gp);
    }

    public void save(Grain grain) throws IOException {
        this.save(grain, null);
    }

    private void save(Grain grain, GrainPart gp) throws IOException {
        this.writeCelestaDoc(grain);
        this.writer.printf("CREATE SCHEMA %s VERSION '%s'", grain.getName(), grain.getVersion());
        if (!grain.isAutoupdate()) {
            this.writer.printf(" WITH NO AUTOUPDATE", new Object[0]);
        }
        this.writer.printf(";%n", new Object[0]);
        this.writer.println();
        this.writer.println("-- *** SEQUENCES ***");
        Collection<SequenceElement> sequences = grain.getElements(SequenceElement.class, gp);
        for (SequenceElement sequenceElement : sequences) {
            this.save(sequenceElement);
        }
        this.writer.println("-- *** TABLES ***");
        Collection<Table> tables = grain.getElements(Table.class, gp);
        for (Table table : tables) {
            this.save(table);
        }
        Collection<ReadOnlyTable> collection = grain.getElements(ReadOnlyTable.class, gp);
        for (ReadOnlyTable readOnlyTable : collection) {
            this.save(readOnlyTable);
        }
        this.writer.println("-- *** FOREIGN KEYS ***");
        for (BasicTable basicTable : tables) {
            for (ForeignKey foreignKey : basicTable.getForeignKeys()) {
                this.save(foreignKey);
            }
        }
        this.writer.println("-- *** INDICES ***");
        Collection<Index> collection2 = grain.getElements(Index.class, gp);
        for (Index index : collection2) {
            this.save(index);
        }
        this.writer.println("-- *** VIEWS ***");
        Collection<View> collection3 = grain.getElements(View.class, gp);
        for (View view : collection3) {
            this.save(view);
        }
        this.writer.println("-- *** MATERIALIZED VIEWS ***");
        Collection<MaterializedView> collection4 = grain.getElements(MaterializedView.class, gp);
        for (MaterializedView mv : collection4) {
            this.save(mv);
        }
        this.writer.println("-- *** PARAMETERIZED VIEWS ***");
        Collection<ParameterizedView> collection5 = grain.getElements(ParameterizedView.class, gp);
        for (ParameterizedView pv : collection5) {
            this.save(pv);
        }
    }

    private boolean writeCelestaDoc(NamedElement e) {
        String doc = e.getCelestaDoc();
        if (doc == null) {
            return false;
        }
        this.writer.printf("/**%s*/%n", doc);
        return true;
    }

    void save(SequenceElement s) throws IOException {
        this.writeCelestaDoc(s);
        this.writer.printf("CREATE SEQUENCE %s ", s.getName());
        if (s.hasArgument(SequenceElement.Argument.START_WITH)) {
            this.writer.printf("START WITH %s ", s.getArgument(SequenceElement.Argument.START_WITH));
        }
        if (s.hasArgument(SequenceElement.Argument.INCREMENT_BY)) {
            this.writer.printf("INCREMENT BY %s ", s.getArgument(SequenceElement.Argument.INCREMENT_BY));
        }
        if (s.hasArgument(SequenceElement.Argument.MINVALUE)) {
            this.writer.printf("MINVALUE %s ", s.getArgument(SequenceElement.Argument.MINVALUE));
        }
        if (s.hasArgument(SequenceElement.Argument.MAXVALUE)) {
            this.writer.printf("MAXVALUE %s ", s.getArgument(SequenceElement.Argument.MAXVALUE));
        }
        if (s.hasArgument(SequenceElement.Argument.CYCLE) && ((Boolean)s.getArgument(SequenceElement.Argument.CYCLE)).booleanValue()) {
            this.writer.write("CYCLE ");
        }
        this.writer.println(";");
        this.writer.println();
    }

    void save(Table t) throws IOException {
        this.saveHead(t);
        if (!t.isVersioned()) {
            this.writer.write(" WITH NO VERSION CHECK");
            this.saveTail(t, false);
        } else {
            this.saveTail(t, true);
        }
    }

    void save(ReadOnlyTable t) throws IOException {
        this.saveHead(t);
        this.writer.write(" WITH READ ONLY");
        this.saveTail(t, false);
    }

    private void saveHead(BasicTable t) throws IOException {
        this.writeCelestaDoc(t);
        this.writer.printf("CREATE TABLE %s(%n", t.getQuotedNameIfNeeded());
        boolean comma = false;
        for (Column<?> c : t.getColumns().values()) {
            if (comma) {
                this.writer.println(",");
            }
            this.save(c);
            comma = true;
        }
        if (!t.getPrimaryKey().isEmpty()) {
            if (comma) {
                this.writer.write(",");
            }
            this.writer.println();
            this.writer.write("  CONSTRAINT ");
            this.writer.write(t.getPkConstraintName());
            this.writer.write(" PRIMARY KEY (");
            comma = false;
            for (Column<?> c : t.getPrimaryKey().values()) {
                if (comma) {
                    this.writer.write(", ");
                }
                this.writer.write(c.getQuotedNameIfNeeded());
                comma = true;
            }
            this.writer.println(")");
        }
        this.writer.write(")");
    }

    private void saveTail(BasicTable t, boolean isWith) {
        if (!t.isAutoUpdate()) {
            if (isWith) {
                this.writer.write(" WITH");
            }
            this.writer.write(" NO AUTOUPDATE");
        }
        this.writer.println(";");
        this.writer.println();
    }

    void save(Column<?> c) throws IOException {
        this.writer.write("  ");
        if (this.writeCelestaDoc(c)) {
            this.writer.write("  ");
        }
        this.writer.write(c.getName());
        switch (c.getCelestaType()) {
            case "BLOB": {
                this.saveColumn((BinaryColumn)c);
                break;
            }
            case "BIT": {
                this.saveColumn((BooleanColumn)c);
                break;
            }
            case "DATETIME": {
                this.saveColumn((DateTimeColumn)c);
                break;
            }
            case "DECIMAL": {
                this.saveColumn((DecimalColumn)c);
                break;
            }
            case "DATETIME WITH TIME ZONE": {
                this.saveColumn((ZonedDateTimeColumn)c);
                break;
            }
            case "REAL": {
                this.saveColumn((FloatingColumn)c);
                break;
            }
            case "INT": {
                this.saveColumn((IntegerColumn)c);
                break;
            }
            case "VARCHAR": 
            case "TEXT": {
                this.saveColumn((StringColumn)c);
                break;
            }
            default: {
                throw new IOException(String.format("No serializer for column of type %s was found!", c.getCelestaType()));
            }
        }
    }

    private void saveColumn(BinaryColumn c) throws IOException {
        String defaultVal;
        this.writer.write(" BLOB");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT ");
            this.writer.write(defaultVal);
        }
    }

    private void saveColumn(BooleanColumn c) throws IOException {
        Boolean defaultVal;
        this.writer.write(" BIT");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT '");
            this.writer.write(defaultVal.toString().toUpperCase());
            this.writer.write("'");
        }
    }

    private void saveColumn(DateTimeColumn c) throws IOException {
        this.writer.write(" DATETIME");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if (c.isGetdate()) {
            this.writer.write(" DEFAULT GETDATE()");
        } else {
            Date defaultVal = c.getDefaultValue();
            if (defaultVal != null) {
                this.writer.write(" DEFAULT '");
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                this.writer.write(df.format(defaultVal));
                this.writer.write("'");
            }
        }
    }

    private void saveColumn(DecimalColumn c) throws IOException {
        BigDecimal defaultVal;
        this.writer.write(" DECIMAL");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT ");
            this.writer.write(defaultVal.toString());
        }
    }

    private void saveColumn(FloatingColumn c) throws IOException {
        Double defaultVal;
        this.writer.write(" REAL");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT ");
            this.writer.write(defaultVal.toString());
        }
    }

    private void saveColumn(IntegerColumn c) throws IOException {
        Integer defaultVal;
        this.writer.write(" INT");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT ");
            this.writer.write(defaultVal.toString());
        }
    }

    private void saveColumn(StringColumn c) throws IOException {
        String defaultVal;
        if (c.isMax()) {
            this.writer.write(" TEXT");
        } else {
            this.writer.write(" VARCHAR(");
            this.writer.write(Integer.toString(c.getLength()));
            this.writer.write(")");
        }
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if ((defaultVal = c.getDefaultValue()) != null) {
            this.writer.write(" DEFAULT ");
            this.writer.write(StringColumn.quoteString(defaultVal));
        }
    }

    private void saveColumn(ZonedDateTimeColumn c) throws IOException {
        this.writer.write(" DATETIME WITH TIME ZONE");
        if (!c.isNullable()) {
            this.writer.write(" NOT NULL");
        }
    }

    void save(ForeignKey fk) {
        this.writer.write("ALTER TABLE ");
        this.writer.write(fk.getParentTable().getQuotedNameIfNeeded());
        this.writer.write(" ADD CONSTRAINT ");
        String name = fk.getConstraintName();
        this.writer.write(name);
        this.writer.write(" FOREIGN KEY (");
        boolean comma = false;
        for (Column<?> c : fk.getColumns().values()) {
            if (comma) {
                this.writer.write(", ");
            }
            this.writer.write(c.getQuotedNameIfNeeded());
            comma = true;
        }
        this.writer.write(") REFERENCES ");
        this.writer.write(fk.getReferencedTable().getGrain().getQuotedNameIfNeeded());
        this.writer.write(".");
        this.writer.write(fk.getReferencedTable().getQuotedNameIfNeeded());
        this.writer.write("(");
        comma = false;
        for (Column<?> c : fk.getReferencedTable().getPrimaryKey().values()) {
            if (comma) {
                this.writer.write(", ");
            }
            this.writer.write(c.getQuotedNameIfNeeded());
            comma = true;
        }
        this.writer.write(")");
        switch (fk.getUpdateRule()) {
            case CASCADE: {
                this.writer.write(" ON UPDATE CASCADE");
                break;
            }
            case SET_NULL: {
                this.writer.write(" ON UPDATE SET NULL");
                break;
            }
        }
        switch (fk.getDeleteRule()) {
            case CASCADE: {
                this.writer.write(" ON DELETE CASCADE");
                break;
            }
            case SET_NULL: {
                this.writer.write(" ON DELETE SET NULL");
                break;
            }
        }
        this.writer.println(";");
    }

    void save(Index i) {
        this.writeCelestaDoc(i);
        this.writer.write("CREATE INDEX ");
        this.writer.write(i.getQuotedNameIfNeeded());
        this.writer.write(" ON ");
        this.writer.write(i.getTable().getQuotedNameIfNeeded());
        this.writer.write("(");
        boolean comma = false;
        for (Column<?> c : i.getColumns().values()) {
            if (comma) {
                this.writer.write(", ");
            }
            this.writer.write(c.getQuotedNameIfNeeded());
            comma = true;
        }
        this.writer.println(");");
    }

    void save(View v) throws IOException {
        this.writeCelestaDoc(v);
        v.createViewScript(this.writer, new ViewCelestaSQLGen(v));
        this.writer.println(";");
        this.writer.println();
    }

    private void saveQuery(View v) throws IOException {
        v.selectScript(this.writer, new ViewCelestaSQLGen(v));
    }

    void save(MaterializedView mv) throws IOException {
        this.writeCelestaDoc(mv);
        MaterializedViewCelestaSQLGen gen = new MaterializedViewCelestaSQLGen(mv);
        this.writer.println(((SQLGenerator)gen).preamble(mv));
        mv.selectScript(this.writer, gen);
        this.writer.println(";");
        this.writer.println();
    }

    void save(ParameterizedView pv) throws IOException {
        this.writeCelestaDoc(pv);
        pv.createViewScript(this.writer, new ParameterizedViewCelestaSQLGen(pv));
        this.writer.println(";");
        this.writer.println();
    }

    private static class ParameterizedViewCelestaSQLGen
    extends AbstractViewCelestaSQLGen<ParameterizedView> {
        ParameterizedViewCelestaSQLGen(ParameterizedView view) {
            super(view);
        }

        @Override
        protected String preamble(AbstractView dummyView) {
            return String.format("create %s %s (%s) as", ((ParameterizedView)this.view).viewType(), this.viewName(this.view), ((ParameterizedView)this.view).getParameters().values().stream().map(p -> p.getName() + " " + p.getType().toString()).collect(Collectors.joining(", ")));
        }
    }

    private static class MaterializedViewCelestaSQLGen
    extends AbstractViewCelestaSQLGen<MaterializedView> {
        MaterializedViewCelestaSQLGen(MaterializedView view) {
            super(view);
        }
    }

    private static class ViewCelestaSQLGen
    extends AbstractViewCelestaSQLGen<View> {
        ViewCelestaSQLGen(View view) {
            super(view);
        }
    }

    private static abstract class AbstractViewCelestaSQLGen<V extends AbstractView>
    extends SQLGenerator {
        final V view;

        AbstractViewCelestaSQLGen(V view) {
            this.view = view;
        }

        @Override
        protected String preamble(AbstractView dummyView) {
            return String.format("create %s %s as", ((AbstractView)this.view).viewType(), this.viewName((AbstractView)this.view));
        }

        @Override
        protected String viewName(AbstractView dummyView) {
            return ((NamedElement)this.view).getQuotedNameIfNeeded();
        }

        @Override
        protected String tableName(TableRef tRef) {
            BasicTable t = tRef.getTable();
            if (t.getGrain() == ((GrainElement)this.view).getGrain()) {
                return String.format("%s as %s", t.getQuotedNameIfNeeded(), tRef.getAlias());
            }
            return String.format("%s.%s as %s", t.getGrain().getQuotedNameIfNeeded(), t.getQuotedNameIfNeeded(), tRef.getAlias());
        }

        @Override
        protected boolean quoteNames() {
            return false;
        }
    }
}

