/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.NamedElementHolder;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;

public final class ForeignKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForeignKey.class);
    private final BasicTable parentTable;
    private BasicTable referencedTable;
    private FKRule deleteRule = FKRule.NO_ACTION;
    private FKRule updateRule = FKRule.NO_ACTION;
    private String constraintName;
    private final NamedElementHolder<Column<?>> columns = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' defined more than once in foreign key for table '%s'.", name, ForeignKey.this.parentTable.getName());
        }
    };
    private final List<Column<?>> referencedColumns = new LinkedList();

    ForeignKey(BasicTable parentTable) {
        if (parentTable == null) {
            throw new IllegalArgumentException();
        }
        this.parentTable = parentTable;
    }

    public ForeignKey(BasicTable parentTable, BasicTable referencedTable, String[] columnNames) throws ParseException {
        this(parentTable);
        for (String n : columnNames) {
            this.addColumn(n);
        }
        this.setReferencedTable(referencedTable.getGrain().getName(), referencedTable.getName());
    }

    public void setDeleteRule(FKRule deleteBehaviour) throws ParseException {
        if (deleteBehaviour == null) {
            throw new IllegalArgumentException();
        }
        if (deleteBehaviour == FKRule.SET_NULL) {
            this.checkNullable();
        }
        this.parentTable.getGrain().modify();
        this.deleteRule = deleteBehaviour;
    }

    public void setUpdateRule(FKRule updateBehaviour) throws ParseException {
        if (updateBehaviour == null) {
            throw new IllegalArgumentException();
        }
        if (updateBehaviour == FKRule.SET_NULL) {
            this.checkNullable();
        }
        this.parentTable.getGrain().modify();
        this.updateRule = updateBehaviour;
    }

    private void checkNullable() throws ParseException {
        for (Column<?> c : this.columns) {
            if (c.isNullable()) continue;
            throw new ParseException(String.format("Error while creating FK for table '%s': column '%s' is not nullable and therefore 'SET NULL' behaviour cannot be applied.", this.parentTable.getName(), c.getName()));
        }
    }

    public Map<String, Column<?>> getColumns() {
        return this.columns.getElements();
    }

    public BasicTable getParentTable() {
        return this.parentTable;
    }

    public BasicTable getReferencedTable() {
        return this.referencedTable;
    }

    public FKRule getDeleteRule() {
        return this.deleteRule;
    }

    public FKRule getUpdateRule() {
        return this.updateRule;
    }

    void addColumn(String columnName) throws ParseException {
        columnName = this.getParentTable().getGrain().getScore().getIdentifierParser().parse(columnName);
        Column<?> c = this.parentTable.getColumns().get(columnName);
        if (c == null) {
            throw new ParseException(String.format("Error while creating FK: no column '%s' defined in table '%s'.", columnName, this.parentTable.getName()));
        }
        this.columns.addElement(c);
    }

    void setReferencedTable(String grain, String table) throws ParseException {
        BasicTable t;
        Grain gm;
        table = this.getParentTable().getGrain().getScore().getIdentifierParser().parse(table);
        if ("".equals(grain) || this.parentTable.getGrain().getName().equals(grain)) {
            gm = this.parentTable.getGrain();
        } else {
            AbstractScore score = this.parentTable.getGrain().getScore();
            gm = score.getGrain(grain);
            if (gm.isModified()) {
                score.parseGrain(grain);
            }
            if (!gm.isParsingComplete()) {
                throw new ParseException(String.format("Error creating foreign key '%s'-->'%s.%s': due to previous parsing errors or cycle reference involving grains '%s' and '%s'.", this.parentTable.getName(), grain, table, this.parentTable.getGrain().getName(), grain));
            }
        }
        this.referencedTable = t = gm.getElement(table, BasicTable.class);
        Map<String, Column<?>> refpk = this.referencedTable.getPrimaryKey();
        if (this.columns.size() != refpk.size()) {
            throw new ParseException(String.format("Error creating foreign key for table %s: it has different size with PK of table '%s'", this.parentTable.getName(), this.referencedTable.getName()));
        }
        Iterator<Column<?>> i = this.referencedTable.getPrimaryKey().values().iterator();
        for (Column<?> c : this.columns) {
            Column<?> c2 = i.next();
            if (c.getClass() != c2.getClass()) {
                throw new ParseException(String.format("Error creating foreign key for table %s: its field types do not coincide with field types of PK of table '%s'", this.parentTable.getName(), this.referencedTable.getName()));
            }
            if (!(c2 instanceof StringColumn) || ((StringColumn)c2).getLength() == ((StringColumn)c).getLength()) continue;
            throw new ParseException(String.format("Error creating foreign key for table %s: its string field length do not coincide with field length of PK of table '%s'", this.parentTable.getName(), this.referencedTable.getName()));
        }
        this.parentTable.addFK(this);
    }

    public int hashCode() {
        int result = 0;
        for (Column<?> c : this.columns) {
            result ^= c.getName().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)obj;
            if (this.columns.size() == fk.columns.size()) {
                Iterator<Column<?>> i = fk.columns.iterator();
                for (Column<?> c : this.columns) {
                    Column<?> c2 = i.next();
                    if (c.getName().equals(c2.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.equals(obj);
    }

    void addReferencedColumn(String columnName) throws ParseException {
        if (this.referencedTable == null) {
            throw new IllegalStateException();
        }
        columnName = this.getParentTable().getGrain().getScore().getIdentifierParser().parse(columnName);
        Column<?> c = this.referencedTable.getColumns().get(columnName);
        if (c == null) {
            throw new ParseException(String.format("Error creating foreign key for table '%s': column '%s' is not defined in table '%s'", this.parentTable.getName(), columnName, this.referencedTable.getName()));
        }
        this.referencedColumns.add(c);
    }

    void finalizeReference() throws ParseException {
        if (this.referencedTable == null) {
            throw new IllegalStateException();
        }
        Map<String, Column<?>> pk = this.referencedTable.getPrimaryKey();
        int size = this.referencedColumns.size();
        if (pk.size() != size) {
            this.referencedColumns.clear();
            throw new ParseException(String.format("Error creating foreign key for table '%s': primary key length in table '%s' is %d, but the number of reference fields is %d.", this.parentTable.getName(), this.referencedTable.getName(), pk.size(), size));
        }
        Iterator<Column<?>> i = pk.values().iterator();
        for (Column<?> c : this.referencedColumns) {
            Column<?> c2 = i.next();
            if (c.getName().equals(c2.getName())) continue;
            this.referencedColumns.clear();
            throw new ParseException(String.format("Error creating foreign key for table '%s': expected primary key field '%s'.'%s', but was '%s'.", this.parentTable.getName(), this.referencedTable.getName(), c2.getName(), c.getName()));
        }
        this.referencedColumns.clear();
    }

    public String getConstraintName() {
        if (this.constraintName != null) {
            return this.constraintName;
        }
        String result = String.format("fk_%s_%s_%s_%s_%s", this.parentTable.getGrain().getName(), this.parentTable.getName(), this.referencedTable.getGrain().getName(), this.referencedTable.getName(), this.columns.getElements().keySet().iterator().next());
        result = NamedElement.limitName(result);
        LOGGER.trace("{}", (Object)result);
        return result;
    }

    public void setConstraintName(String constraintName) throws ParseException {
        if (constraintName != null) {
            this.parentTable.getGrain().getScore().getIdentifierParser().parse(constraintName);
        }
        this.constraintName = constraintName;
    }

    public void delete() throws ParseException {
        this.parentTable.removeFK(this);
    }
}

