/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Map;
import java.util.function.Function;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.Aggregate;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableRef;

final class MaterializedSelectStmt
extends AbstractSelectStmt {
    final MaterializedView view;

    MaterializedSelectStmt(MaterializedView view) {
        super(view);
        this.view = view;
    }

    @Override
    void setWhereCondition(Expr whereCondition) throws ParseException {
        throw new ParseException(String.format("Exception while parsing materialized view %s.%s Materialized views doesn't support where condition.", this.view.getGrain().getName(), this.view.getName()));
    }

    @Override
    void finalizeParsing() throws ParseException {
        boolean aggregate = this.columns.entrySet().stream().anyMatch(e -> e.getValue() instanceof Aggregate);
        if (!aggregate) {
            throw new ParseException(String.format("%s %s.%s must have at least one aggregate column", this.view.viewType(), this.view.getGrain().getName(), this.view.getName()));
        }
        this.finalizeColumnsParsing();
        this.finalizeGroupByParsing();
    }

    @Override
    void finalizeColumnsParsing() throws ParseException {
        super.finalizeColumnsParsing();
        for (Map.Entry entry : this.columns.entrySet()) {
            MaterializedView.MatColFabricFunction matColFabricFunction;
            Column colRef;
            String alias = (String)entry.getKey();
            Expr expr = (Expr)entry.getValue();
            if (expr instanceof Count) {
                colRef = null;
                matColFabricFunction = MaterializedView.COL_CLASSES_AND_FABRIC_FUNCS.get(IntegerColumn.class);
            } else {
                colRef = (Column)((Function)MaterializedView.EXPR_CLASSES_AND_COLUMN_EXTRACTORS.get(expr.getClass())).apply(expr);
                matColFabricFunction = MaterializedView.COL_CLASSES_AND_FABRIC_FUNCS.get(colRef.getClass());
            }
            if (matColFabricFunction == null) {
                throw new ParseException(String.format("Unsupported type '%s' of column '%s' in materialized view %s was found", expr.getMeta().getCelestaType(), alias, this.view.getName()));
            }
            Column<?> col = matColFabricFunction.apply(this.view, colRef, alias);
            if (expr instanceof Aggregate) continue;
            this.view.pk.addElement(col);
            col.setNullableAndDefault(false, null);
        }
    }

    @Override
    void finalizeGroupByParsing() throws ParseException {
        super.finalizeGroupByParsing();
        for (String alias : this.groupByColumns.keySet()) {
            Column<?> colRef = ((FieldRef)this.columns.get(alias)).getColumn();
            if (!colRef.isNullable()) continue;
            throw new ParseException(String.format("Nullable column %s was found in GROUP BY expression for %s '%s.%s'.", alias, this.view.viewType(), this.view.getGrain().getName(), this.view.getName()));
        }
    }

    @Override
    void addFromTableRef(TableRef ref) throws ParseException {
        if (!this.view.getGrain().equals(ref.getTable().getGrain())) {
            throw new ParseException(String.format("%s '%s.%s' contains a table from another grain.", this.view.viewType(), this.view.getGrain().getName(), this.view.getName()));
        }
        super.addFromTableRef(ref);
    }
}

