/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.validator.IdentifierParser;

public abstract class NamedElement {
    public static final int MAX_IDENTIFIER_LENGTH = 30;
    private static final Pattern COMMENT = Pattern.compile("/\\*\\*(.*)\\*/", 32);
    private final String name;
    private final String quotedName;
    private String celestaDoc;

    public NamedElement(String name, IdentifierParser identifierParser) throws ParseException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = identifierParser.parse(name);
        this.quotedName = String.format("\"%s\"", this.name);
    }

    public static String limitName(String value) {
        return NamedElement.limitName(value, "");
    }

    public static String limitName(String value, String postfix) {
        String result = value;
        if (result.length() + postfix.length() > 30) {
            int trimLength = 30 - postfix.length() - 8;
            if (trimLength < 4) {
                throw new IllegalArgumentException(String.format("Restricted name for %s couldn't be created.", value + postfix));
            }
            result = String.format("%s%08X", result.substring(0, trimLength), result.hashCode());
        }
        return result + postfix;
    }

    public final String getName() {
        return this.name;
    }

    public final String getQuotedName() {
        return this.quotedName;
    }

    public final String getQuotedNameIfNeeded() {
        Pattern p = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_]*");
        if (p.matcher(this.name).matches()) {
            return this.name;
        }
        return this.quotedName;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NamedElement) {
            return Objects.equals(this.name, ((NamedElement)obj).getName());
        }
        return false;
    }

    public String getCelestaDoc() {
        return this.celestaDoc;
    }

    void setCelestaDocLexem(String celestaDoc) throws ParseException {
        if (celestaDoc == null) {
            this.celestaDoc = null;
        } else {
            Matcher m = COMMENT.matcher(celestaDoc);
            if (!m.matches()) {
                throw new ParseException("Celestadoc should match pattern /**...*/, was " + celestaDoc);
            }
            this.setCelestaDoc(m.group(1));
        }
    }

    public void setCelestaDoc(String celestaDoc) throws ParseException {
        this.celestaDoc = celestaDoc;
    }
}

